/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class IndeterminateProgressBarPainterExtension
implements PainterExtension {
    @NotNull
    protected final AquaUILayoutInfo uiLayout;
    @NotNull
    protected final IndeterminateProgressIndicatorConfiguration pg;
    @Nullable
    protected final Map<String, Color> colors;
    @NotNull
    protected final Color background;
    @NotNull
    protected final Color thumb;

    public IndeterminateProgressBarPainterExtension(@NotNull AquaUILayoutInfo uiLayout, @NotNull IndeterminateProgressIndicatorConfiguration g, @Nullable VAppearance appearance) {
        this.uiLayout = uiLayout;
        this.pg = g;
        this.colors = appearance != null ? appearance.getColors() : null;
        AquaUIPainter.State state = this.pg.getState();
        boolean isDark = appearance != null && appearance.isDark();
        Color color = this.background = isDark ? new Color(255, 255, 255, 24) : new Color(0, 0, 0, 16);
        if (state == AquaUIPainter.State.DISABLED || state.isInactive()) {
            this.thumb = isDark ? new Color(255, 255, 255, 64) : new Color(0, 0, 0, 64);
        } else {
            Color accent = this.colors != null ? this.colors.get("controlAccent") : null;
            this.thumb = accent != null ? accent : Color.LIGHT_GRAY;
        }
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        boolean isVertical = this.pg.getOrientation() == AquaUIPainter.Orientation.VERTICAL;
        float arc = this.pg.getSize() == AquaUIPainter.Size.SMALL ? 3.0f : 6.0f;
        g = (Graphics2D)g.create();
        g.clip(new Rectangle2D.Float(0.0f, 0.0f, width, height));
        g.setColor(this.background);
        g.fill(new RoundRectangle2D.Float(0.0f, 0.0f, width, height, arc, arc));
        g.setColor(this.thumb);
        int frameCount = 90;
        float length = isVertical ? height : width;
        int segment = (int)(length / 4.0f);
        float interval = (length + (float)segment) / (float)frameCount;
        int animationFrame = this.pg.getAnimationFrame();
        int position1 = (int)Math.floor(interval * (float)animationFrame - (float)segment);
        int position2 = (int)Math.ceil(position1 + segment);
        int thick = Math.round(isVertical ? width : height);
        if (isVertical) {
            int pos = (int)length - position1 - segment;
            g.fill(new RoundRectangle2D.Float(0.0f, pos, thick, position2 - position1, arc, arc));
        } else {
            g.fill(new RoundRectangle2D.Float(position1, 0.0f, position2 - position1, thick, arc, arc));
        }
        g.dispose();
    }
}

