/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.ImageUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.ReusableCompositor;
import org.violetlib.vappearances.VAppearance;

public class FromMaskOperator
implements ReusableCompositor.PixelOperator {
    @Nullable
    private final VAppearance appearance;

    public FromMaskOperator(@Nullable VAppearance appearance) {
        this.appearance = appearance;
    }

    @Override
    public int combine(int destinationPixel, int sourcePixel) {
        boolean isDark = this.appearance != null && this.appearance.isDark();
        int alpha = ImageUtils.alpha(sourcePixel);
        if (alpha == 0) {
            return destinationPixel;
        }
        int newAlpha = Math.min(255, alpha * 5);
        int target = isDark ? 73 : 186;
        int value = target * newAlpha / 255;
        sourcePixel = ImageUtils.createPixel(newAlpha, value, value, value);
        return JNRUtils.combine(destinationPixel, sourcePixel);
    }
}

