/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.coreui.ColorWellRenderer;
import org.violetlib.jnr.aqua.coreui.CoreUIPainter;
import org.violetlib.jnr.aqua.impl.CircularSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.LegacyScrollBarPainterExtension;
import org.violetlib.jnr.aqua.impl.LinearSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.OverlayScrollBarPainterExtension;
import org.violetlib.jnr.aqua.impl.PopUpArrowPainter;
import org.violetlib.jnr.aqua.impl.PullDownArrowPainter;
import org.violetlib.jnr.aqua.impl.RoundToolbarButtonPainterExtension;
import org.violetlib.jnr.aqua.impl.TableColumnHeaderCellPainterExtension;
import org.violetlib.jnr.aqua.impl.ThinSplitPaneDividerPainterExtension;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.DarkGroupBoxRenderer;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class AugmentedCoreUIPainter
extends CoreUIPainter {
    public AugmentedCoreUIPainter() {
    }

    public AugmentedCoreUIPainter(boolean useJRS) {
        super(useJRS);
    }

    @Override
    @NotNull
    public AugmentedCoreUIPainter copy() {
        return new AugmentedCoreUIPainter(this.useJRS);
    }

    @Override
    @NotNull
    protected Renderer getGroupBoxRenderer(@NotNull GroupBoxConfiguration g) {
        if (this.appearance != null && this.appearance.isDark()) {
            Renderer r = super.getGroupBoxRenderer(g);
            BasicRenderer br = r.getBasicRenderer();
            assert (br != null);
            DarkGroupBoxRenderer rr = new DarkGroupBoxRenderer(br, this.appearance);
            return Renderer.create(rr, r.getRendererDescription());
        }
        return super.getGroupBoxRenderer(g);
    }

    @Override
    @NotNull
    protected Renderer getButtonRenderer(@NotNull ButtonConfiguration g) {
        int platformVersion;
        Renderer r = super.getButtonRenderer(g);
        if (g.getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            boolean isDark = this.appearance != null && this.appearance.isDark();
            return new ColorWellRenderer(g, r, isDark);
        }
        if (g.getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR && (platformVersion = JNRPlatformUtils.getPlatformVersion()) >= 101600) {
            RoundToolbarButtonPainterExtension px = new RoundToolbarButtonPainterExtension(g, this.appearance);
            return Renderer.create(px);
        }
        return r;
    }

    @Override
    @NotNull
    protected Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration g) {
        Renderer r = super.getComboBoxButtonRenderer(g);
        return r;
    }

    @Override
    @Nullable
    public Renderer getBasicPopupButtonRenderer(@NotNull PopupButtonConfiguration g) {
        Renderer r = super.getBasicPopupButtonRenderer(g);
        return r;
    }

    @Override
    @NotNull
    protected Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration g) {
        Renderer r = super.getSegmentedButtonRenderer(g);
        if (this.isCustomSegmentedButtonRendererNeeded(g)) {
            return this.createCustomSegmentedButtonRenderer(g, r);
        }
        return r;
    }

    protected boolean isCustomSegmentedButtonRendererNeeded(@NotNull SegmentedButtonConfiguration g) {
        if (g.getPosition() == AquaUIPainter.Position.ONLY) {
            return false;
        }
        return g.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE || g.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
    }

    @Nullable
    protected SegmentedButtonAdjustment getSegmentedButtonAdjustment(@NotNull SegmentedButtonConfiguration g, int scaleFactor) {
        if (g.getPosition() == AquaUIPainter.Position.ONLY) {
            return null;
        }
        AquaUIPainter.SegmentedButtonWidget w = g.getWidget();
        if (w.isSeparated() && scaleFactor == 2) {
            return null;
        }
        if (scaleFactor > 2) {
            return null;
        }
        int leftDividerRequested = 0;
        int rightDividerRequested = 0;
        if (g.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE) {
            leftDividerRequested = scaleFactor;
        }
        if (g.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE) {
            rightDividerRequested = scaleFactor;
        }
        SegmentedButtonAdjustment basic = this.getSegmentedDividerAvailable(g, scaleFactor);
        int leftDividerActual = leftDividerRequested > 0 ? basic.leftDividerActual : 0;
        int rightDividerActual = rightDividerRequested > 0 ? basic.rightDividerActual : 0;
        return new SegmentedButtonAdjustment(leftDividerActual, leftDividerRequested, rightDividerActual, rightDividerRequested);
    }

    @NotNull
    private SegmentedButtonAdjustment getSegmentedDividerAvailable(@NotNull SegmentedButtonConfiguration g, int scaleFactor) {
        int rightDividerActual;
        int leftDividerActual;
        AquaUIPainter.SegmentedButtonWidget w = g.getWidget();
        int version = this.getSegmentedButtonRenderingVersion();
        if (scaleFactor == 1) {
            if (version == 0 || version == 1 || version == 2) {
                if (w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE) {
                    leftDividerActual = 1;
                    rightDividerActual = 1;
                } else {
                    leftDividerActual = 0;
                    rightDividerActual = 1;
                }
            } else {
                leftDividerActual = 0;
                rightDividerActual = 1;
            }
        } else if (version == 2 || version == 3) {
            if (w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE) {
                leftDividerActual = 2;
                rightDividerActual = 2;
            } else if (w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED || w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE) {
                leftDividerActual = 2;
                rightDividerActual = 0;
            } else {
                leftDividerActual = 1;
                rightDividerActual = 1;
            }
        } else {
            leftDividerActual = 1;
            rightDividerActual = 1;
        }
        return new SegmentedButtonAdjustment(leftDividerActual, 0, rightDividerActual, 0);
    }

    @NotNull
    protected Renderer createCustomSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration g, @NotNull Renderer r) {
        return new MySegmentedButtonRenderer(g, r);
    }

    @NotNull
    protected SegmentedRendering createFlippedRendering(@NotNull SegmentedButtonConfiguration sg, int height, int scaleFactor) {
        SegmentedButtonConfiguration g = new SegmentedButtonConfiguration(sg.getWidget(), sg.getSize(), sg.getState(), sg.isSelected(), sg.isFocused(), sg.getDirection(), AquaUIPainter.Position.MIDDLE, sg.getRightDividerState(), sg.getLeftDividerState(), sg.getTracking());
        int sourceWidth = 100;
        Renderer unconfiguredSource = AugmentedCoreUIPainter.super.getSegmentedButtonRenderer(g);
        ReusableCompositor source = new ReusableCompositor();
        source.reset(sourceWidth, height, scaleFactor);
        unconfiguredSource.composeTo(source);
        ReusableCompositor output = source.createHorizontallyFlippedCopy();
        SegmentedButtonAdjustment sourceDividers = this.getSegmentedDividerAvailable(g, scaleFactor);
        SegmentedButtonAdjustment dividers = new SegmentedButtonAdjustment(sourceDividers.rightDividerActual, sourceDividers.leftDividerActual);
        return new SegmentedRendering(output, dividers);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration g) {
        if (g.getWidget() == AquaUIPainter.DividerWidget.THIN_DIVIDER) {
            ThinSplitPaneDividerPainterExtension px = new ThinSplitPaneDividerPainterExtension(g, this.appearance);
            return Renderer.create(px);
        }
        return super.getSplitPaneDividerRenderer(g);
    }

    @Override
    @NotNull
    public Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration g) {
        TableColumnHeaderCellPainterExtension px = new TableColumnHeaderCellPainterExtension(g, this.appearance);
        return Renderer.create(px);
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration g) {
        Renderer r = super.getSliderRenderer(g);
        if (g.getWidget() == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            Renderer pr = Renderer.create(new CircularSliderPainterExtension(g, this.appearance));
            return Renderer.createCompositeRenderer(r, pr);
        }
        return r;
    }

    @Override
    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration g) {
        int style = this.getSliderRenderingVersion();
        if (style == 0 && g.isLinear() && g.hasTickMarks()) {
            return Renderer.create(new LinearSliderPainterExtension(this.uiLayout, g, this.appearance));
        }
        return super.getSliderTickMarkRenderer(g);
    }

    @Override
    @NotNull
    protected Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration g) {
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        AquaUIPainter.ScrollBarWidget sw = g.getWidget();
        if (platformVersion < 101400) {
            return super.getScrollBarRenderer(g);
        }
        if (sw == AquaUIPainter.ScrollBarWidget.LEGACY) {
            return Renderer.create(new LegacyScrollBarPainterExtension(this.uiLayout, g, this.appearance));
        }
        return Renderer.create(new OverlayScrollBarPainterExtension(this.uiLayout, g, this.appearance));
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration g) {
        Renderer r = super.getPopupArrowRenderer(g);
        if (this.isArrowNeeded(g)) {
            if (g.isPopUp()) {
                return Renderer.create(new PopUpArrowPainter(g, this.appearance));
            }
            return Renderer.create(new PullDownArrowPainter(g, this.appearance));
        }
        return r;
    }

    private boolean isArrowNeeded(@NotNull PopupButtonConfiguration g) {
        AquaUIPainter.PopupButtonWidget w = g.getPopupButtonWidget();
        return w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED || w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED;
    }

    @Override
    @NotNull
    public String toString() {
        return "Augmented " + super.toString();
    }

    protected static class SegmentedButtonAdjustment {
        public final int leftDividerActual;
        public final int leftDividerRequested;
        public final int rightDividerActual;
        public final int rightDividerRequested;

        public SegmentedButtonAdjustment(int leftDividerActual, int leftDividerRequested, int rightDividerActual, int rightDividerRequested) {
            this.leftDividerActual = leftDividerActual;
            this.leftDividerRequested = leftDividerRequested;
            this.rightDividerActual = rightDividerActual;
            this.rightDividerRequested = rightDividerRequested;
        }

        public SegmentedButtonAdjustment(int left, int right) {
            this.leftDividerActual = left;
            this.rightDividerActual = right;
            this.leftDividerRequested = 0;
            this.rightDividerRequested = 0;
        }
    }

    protected class MySegmentedButtonRenderer
    extends Renderer {
        @NotNull
        private final SegmentedButtonConfiguration g;
        @NotNull
        private final Renderer r;

        public MySegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration g, Renderer r) {
            this.g = g;
            this.r = r;
        }

        @Override
        public void composeTo(@NotNull ReusableCompositor compositor) {
            int scaleFactor = compositor.getScaleFactor();
            SegmentedButtonAdjustment adjustment = AugmentedCoreUIPainter.this.getSegmentedButtonAdjustment(this.g, scaleFactor);
            if (adjustment == null) {
                this.r.composeTo(compositor);
            } else {
                int columns;
                int x;
                int availableColumns;
                int sx;
                ReusableCompositor dividerSource;
                int columnsNeeded;
                int w = compositor.getRasterWidth();
                int h = compositor.getRasterHeight();
                int leftInset = 0;
                int rightInset = 0;
                ReusableCompositor basicSource = compositor.createSimilar();
                this.r.composeTo(basicSource);
                if (adjustment.leftDividerRequested > adjustment.leftDividerActual) {
                    leftInset = adjustment.leftDividerRequested;
                }
                if (adjustment.rightDividerRequested > adjustment.rightDividerActual) {
                    rightInset = adjustment.rightDividerRequested;
                }
                compositor.composeFrom(basicSource, leftInset, 0, leftInset, 0, w - leftInset - rightInset, h);
                SegmentedRendering flipped = null;
                if (leftInset > 0) {
                    columnsNeeded = adjustment.leftDividerRequested;
                    dividerSource = basicSource;
                    sx = 0;
                    availableColumns = adjustment.leftDividerActual;
                    if (availableColumns == 0) {
                        flipped = AugmentedCoreUIPainter.this.createFlippedRendering(this.g, h, scaleFactor);
                        dividerSource = flipped.rendering;
                        availableColumns = flipped.dividers.leftDividerActual;
                    }
                    if (availableColumns > 0) {
                        x = 0;
                        while (columnsNeeded > 0) {
                            columns = Math.min(columnsNeeded, availableColumns);
                            compositor.composeFrom(dividerSource, sx, 0, x, 0, columns, h);
                            columnsNeeded -= columns;
                            x += columns;
                        }
                    } else {
                        System.err.println("Unsupported left divider from right:" + this.g);
                    }
                }
                if (rightInset > 0) {
                    columnsNeeded = adjustment.rightDividerRequested;
                    dividerSource = basicSource;
                    sx = w - adjustment.rightDividerActual;
                    availableColumns = adjustment.rightDividerActual;
                    if (availableColumns == 0) {
                        if (flipped == null) {
                            flipped = AugmentedCoreUIPainter.this.createFlippedRendering(this.g, h, scaleFactor);
                        }
                        dividerSource = flipped.rendering;
                        availableColumns = flipped.dividers.rightDividerActual;
                        sx = dividerSource.getRasterWidth() - availableColumns;
                    }
                    if (availableColumns > 0) {
                        x = w - adjustment.rightDividerRequested;
                        while (columnsNeeded > 0) {
                            columns = Math.min(columnsNeeded, availableColumns);
                            compositor.composeFrom(dividerSource, sx, 0, x, 0, columns, h);
                            columnsNeeded -= columns;
                            x += columns;
                        }
                    } else {
                        System.err.println("Unsupported right divider from left: " + this.g);
                    }
                }
            }
        }
    }

    protected static class SegmentedRendering {
        @NotNull
        public final ReusableCompositor rendering;
        @NotNull
        public final SegmentedButtonAdjustment dividers;

        public SegmentedRendering(@NotNull ReusableCompositor rendering, @NotNull SegmentedButtonAdjustment dividers) {
            this.rendering = rendering;
            this.dividers = dividers;
        }
    }
}

