/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.HybridAquaUIPainter;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.impl.ImageCache;
import org.violetlib.jnr.impl.JNRPlatformUtils;

public class AquaNativeRendering {
    private static boolean isInitialized;
    @Nullable
    private static AquaUIPainter preferredPainter;

    @NotNull
    public static AquaUIPainter createPainter() throws UnsupportedOperationException {
        if (!isInitialized) {
            AquaNativeRendering.findPainterClasses();
        }
        if (preferredPainter != null) {
            return preferredPainter.copy();
        }
        throw new UnsupportedOperationException("Unable to create a native painter");
    }

    public static void invalidateAppearances() {
        AquaUIPainterBase.nativeInvalidateAppearances();
    }

    public static void clearCache() {
        ImageCache.getInstance().flush();
    }

    private AquaNativeRendering() {
    }

    @NotNull
    public static String getReleaseName() {
        return AquaNativeRendering.getStringResource("RELEASE.txt");
    }

    @NotNull
    public static String getBuildID() {
        return AquaNativeRendering.getStringResource("BUILD.txt");
    }

    @NotNull
    public static String getVersionString() {
        return "VAquaRendering: release " + AquaNativeRendering.getReleaseName() + " (build " + AquaNativeRendering.getBuildID() + ")";
    }

    public static void showVersion() {
        System.err.println("VAquaRendering: release " + AquaNativeRendering.getReleaseName() + ", build " + AquaNativeRendering.getBuildID());
    }

    @NotNull
    private static String getStringResource(@NotNull String name) {
        InputStream s = AquaNativeRendering.class.getResourceAsStream(name);
        if (s != null) {
            try {
                int ch;
                BufferedReader r = new BufferedReader(new InputStreamReader(s));
                StringBuilder sb = new StringBuilder();
                while ((ch = r.read()) >= 0) {
                    sb.append((char)ch);
                }
                return sb.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "Unknown";
    }

    private static synchronized void findPainterClasses() {
        boolean useJRS;
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        AquaUIPainter jrsPainter = null;
        String name = "org.violetlib.jnr.aqua.impl.AugmentedAquaNativePainter";
        AquaUIPainter viewPainter = AquaNativeRendering.getPainter(name, null);
        int jrsVersion = NativeSupport.getJavaRuntimeSupportMajorVersion();
        boolean useJRSToAccessCoreUI = useJRS = jrsVersion >= 15;
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        if (platformVersion >= 101400) {
            useJRSToAccessCoreUI = false;
        }
        String name2 = "org.violetlib.jnr.aqua.coreui.AugmentedCoreUIPainter";
        AquaUIPainter coreUIPainter = AquaNativeRendering.getPainter(name2, useJRSToAccessCoreUI);
        if (useJRS) {
            String name3 = "org.violetlib.jnr.aqua.jrs.AugmentedJRSPainter";
            jrsPainter = AquaNativeRendering.getPainter(name3, null);
        }
        if (viewPainter != null && coreUIPainter != null) {
            preferredPainter = new HybridAquaUIPainter(viewPainter, coreUIPainter, jrsPainter);
        } else if (coreUIPainter != null) {
            AquaNativeRendering.debug("Using Core UI painter as preferred painter");
            preferredPainter = coreUIPainter;
        } else if (viewPainter != null) {
            AquaNativeRendering.debug("Using NSView painter as preferred painter");
            preferredPainter = viewPainter;
        } else {
            AquaNativeRendering.debug("Using JRS painter as preferred painter");
            preferredPainter = jrsPainter;
        }
    }

    protected static void debug(@NotNull String s) {
    }

    @Nullable
    protected static AquaUIPainter getPainter(@NotNull String name, @Nullable Boolean parameter) {
        Class c = AquaNativeRendering.getClass(name);
        if (c != null) {
            if (AquaUIPainter.class.isAssignableFrom(c)) {
                try {
                    if (parameter != null) {
                        Constructor cons = c.getConstructor(Boolean.TYPE);
                        return (AquaUIPainter)cons.newInstance(parameter);
                    }
                    Constructor cons = c.getConstructor(new Class[0]);
                    return (AquaUIPainter)cons.newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    System.err.println("Unable to instantiate painter class: " + name);
                    ex.printStackTrace();
                }
            } else {
                System.err.println("Painter class is not valid: " + name);
            }
        } else {
            AquaNativeRendering.debug("Painter class not found: " + name);
        }
        return null;
    }

    @Nullable
    protected static Class getClass(@NotNull String name) {
        ClassLoader loader = AquaNativeRendering.class.getClassLoader();
        try {
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }
}

