/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.util.ArrayList;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import org.violetlib.aqua.AquaUtils;

public class SystemPropertyChangeManager {
    private static final WeakHashMap<JComponent, JComponent> components = new WeakHashMap();

    public static void register(JComponent jComponent) {
        components.put(jComponent, null);
    }

    public static void unregister(JComponent jComponent) {
        components.remove(jComponent);
    }

    public static void notifyChange(Object object) {
        Set<JComponent> set = components.keySet();
        if (!set.isEmpty()) {
            ArrayList<JComponent> arrayList = new ArrayList<JComponent>(set);
            for (JComponent jComponent : arrayList) {
                SystemPropertyChangeListener systemPropertyChangeListener = AquaUtils.getUI(jComponent, SystemPropertyChangeListener.class);
                if (systemPropertyChangeListener != null) {
                    systemPropertyChangeListener.systemPropertyChanged(jComponent, object);
                    continue;
                }
                components.remove(jComponent);
            }
        }
    }

    public static interface SystemPropertyChangeListener {
        public void systemPropertyChanged(JComponent var1, Object var2);
    }
}

