/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.io.InputStreamReader;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.SystemPropertyChangeManager;
import org.violetlib.aqua.Utils;

public class OSXSystemProperties {
    public static Object USER_PREFERENCE_CHANGE_TYPE = "UserPreferenceChangeType";
    public static int simulatedOSVersion = 0;
    public static final int OSVersion = OSXSystemProperties.getOSVersion();
    private static boolean hasBeenSynchronized;
    private static boolean isFullKeyboardAccessEnabled;
    private static boolean useOverlayScrollBars;
    private static boolean reduceTransparency;

    private static int getOSVersion() {
        String string;
        if (simulatedOSVersion > 0) {
            Utils.logDebug("Using simulated OS Version: " + simulatedOSVersion);
            return simulatedOSVersion;
        }
        String string2 = System.getProperty("os.version");
        int n = OSXSystemProperties.parseSystemVersion(string2);
        if (n == 0) {
            Utils.logError("Unable to parse macOS version: " + string2);
        } else if (n == 1016 && (string = OSXSystemProperties.readSystemVersion()) != null) {
            int n2 = OSXSystemProperties.parseSystemVersion(string);
            if (n2 > 0) {
                n = n2;
                Utils.logDebug("Substituting macOS version: " + n);
            } else {
                Utils.logError("Unable to parse macOS version: " + string);
            }
        }
        return n;
    }

    @Nullable
    private static String readSystemVersion() {
        String[] stringArray = new String[]{"/usr/bin/sw_vers", "-productVersion"};
        String[] stringArray2 = new String[]{"SYSTEM_VERSION_COMPAT=0"};
        String string = OSXSystemProperties.command("sw_vers", stringArray, stringArray2);
        if (string != null) {
            return string;
        }
        return null;
    }

    @Nullable
    private static String command(@NotNull String string, String @NotNull [] stringArray, String @Nullable [] stringArray2) {
        try {
            int n;
            Process process = Runtime.getRuntime().exec(stringArray, stringArray2);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStreamReader.read()) != -1 && n != 10) {
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            Utils.logError("Unable to run " + string, throwable);
            return null;
        }
    }

    private static int parseSystemVersion(@NotNull String string) {
        try {
            String string2;
            int n;
            int n2;
            int n3 = string.indexOf(46);
            if (n3 > 0 && (n2 = Integer.parseInt(string.substring(0, n3))) > 0 && (n = Integer.parseInt((n3 = (string2 = string.substring(n3 + 1)).indexOf(46)) >= 0 ? string2.substring(0, n3) : string2)) >= 0 && n < 100) {
                return n2 * 100 + n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static boolean useInsetViewStyle() {
        return OSVersion >= 1016;
    }

    public static boolean isFullKeyboardAccessEnabled() {
        OSXSystemProperties.ensureSynchronized();
        return isFullKeyboardAccessEnabled;
    }

    public static boolean isReduceTransparency() {
        OSXSystemProperties.ensureSynchronized();
        return reduceTransparency;
    }

    public static boolean doScrollPanesSupportRTL() {
        return false;
    }

    public static boolean isShowAllFiles() {
        if (AquaNativeSupport.load()) {
            return OSXSystemProperties.nativeGetShowAllFiles();
        }
        return false;
    }

    public static boolean useOverlayScrollBars() {
        OSXSystemProperties.ensureSynchronized();
        return useOverlayScrollBars;
    }

    public static boolean isScrollToClick() {
        if (AquaNativeSupport.load()) {
            return OSXSystemProperties.nativeGetScrollToClick();
        }
        return false;
    }

    public static synchronized void register(JComponent jComponent) {
        SystemPropertyChangeManager.register(jComponent);
    }

    public static synchronized void unregister(JComponent jComponent) {
        SystemPropertyChangeManager.unregister(jComponent);
    }

    private static void ensureSynchronized() {
        if (!hasBeenSynchronized) {
            if (AquaNativeSupport.load()) {
                Runnable runnable = () -> SwingUtilities.invokeLater(OSXSystemProperties::synchronize);
                OSXSystemProperties.enableCallback(runnable);
                OSXSystemProperties.synchronize();
            } else {
                hasBeenSynchronized = true;
            }
        }
    }

    private static synchronized void synchronize() {
        boolean bl = isFullKeyboardAccessEnabled;
        isFullKeyboardAccessEnabled = OSXSystemProperties.nativeGetFullKeyboardAccessEnabled();
        boolean bl2 = useOverlayScrollBars;
        useOverlayScrollBars = OSXSystemProperties.nativeGetUseOverlayScrollBars();
        boolean bl3 = reduceTransparency;
        reduceTransparency = OSXSystemProperties.nativeGetReduceTransparency();
        if (hasBeenSynchronized && isFullKeyboardAccessEnabled != bl || useOverlayScrollBars != bl2 || reduceTransparency != bl3) {
            SystemPropertyChangeManager.notifyChange(USER_PREFERENCE_CHANGE_TYPE);
        }
        hasBeenSynchronized = true;
    }

    private static native boolean nativeGetFullKeyboardAccessEnabled();

    private static native boolean nativeGetShowAllFiles();

    private static native boolean nativeGetScrollToClick();

    private static native boolean nativeGetUseOverlayScrollBars();

    private static native boolean nativeGetReduceTransparency();

    private static native void enableCallback(Runnable var0);
}

