/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentTracker {
    private final HierarchyListener hierarchyListener = hierarchyEvent -> {
        boolean bl;
        Window window;
        long l = hierarchyEvent.getChangeFlags();
        if ((l & 1L) != 0L) {
            window = SwingUtilities.getWindowAncestor(this.tracked);
            if (!Objects.equals(this.window, window)) {
                Window window2 = this.window;
                this.window = window;
                this.windowIsDisplayable = window != null && window.isDisplayable();
                this.windowChanged(window2, this.window);
            } else {
                this.ancestorChanged();
            }
        }
        if ((l & 2L) != 0L && (window = SwingUtilities.getWindowAncestor(this.tracked)) != null && window == this.window && (bl = window.isDisplayable()) != this.windowIsDisplayable) {
            this.windowIsDisplayable = bl;
            this.windowChanged(this.window, this.window);
        }
        if ((l & 4L) != 0L) {
            this.visibleBoundsChanged(this.window);
        }
    };
    private final HierarchyBoundsListener hierarchyBoundsListener = new HierarchyBoundsListener(){

        @Override
        public void ancestorMoved(@NotNull HierarchyEvent hierarchyEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void ancestorResized(@NotNull HierarchyEvent hierarchyEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }
    };
    private final ComponentListener componentListener = new ComponentListener(){

        @Override
        public void componentResized(@NotNull ComponentEvent componentEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void componentMoved(@NotNull ComponentEvent componentEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void componentShown(@NotNull ComponentEvent componentEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void componentHidden(@NotNull ComponentEvent componentEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }
    };
    @Nullable
    private Component tracked;
    @Nullable
    private Window window;
    private boolean windowIsDisplayable;

    public void attach(@Nullable Component component) {
        if (this.tracked != component) {
            if (this.tracked != null) {
                Window window = this.window;
                this.tracked.removeHierarchyListener(this.hierarchyListener);
                this.tracked.removeHierarchyBoundsListener(this.hierarchyBoundsListener);
                this.tracked.removeComponentListener(this.componentListener);
                this.tracked = null;
                this.window = null;
                this.windowIsDisplayable = false;
                this.detached(window);
            }
            if (component != null) {
                this.tracked = component;
                this.tracked.addHierarchyListener(this.hierarchyListener);
                this.tracked.addHierarchyBoundsListener(this.hierarchyBoundsListener);
                this.tracked.addComponentListener(this.componentListener);
                this.window = SwingUtilities.getWindowAncestor(this.tracked);
                this.windowIsDisplayable = this.window != null && this.window.isDisplayable();
                this.attached(this.window);
            }
        }
    }

    protected void detached(@Nullable Window window) {
    }

    protected void attached(@Nullable Window window) {
    }

    protected void windowChanged(@Nullable Window window, @Nullable Window window2) {
    }

    protected void ancestorChanged() {
    }

    protected void visibleBoundsChanged(@Nullable Window window) {
    }
}

