/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import org.violetlib.jnr.InsetterNotInvertibleException;
import org.violetlib.jnr.impl.Insetter1;

public class RigidInsetter1
implements Insetter1 {
    private final float regionSize;
    private final float componentSize;
    private final float d1;

    public RigidInsetter1(float regionSize, float componentSize, float d1) {
        if (regionSize < 0.0f || componentSize < 0.0f) {
            throw new IllegalArgumentException("Invalid negative region or component size");
        }
        if (regionSize > componentSize) {
            throw new IllegalArgumentException("Invalid region size exceeds component size");
        }
        if (d1 < 0.0f || d1 > componentSize - regionSize) {
            throw new IllegalArgumentException("Invalid offset");
        }
        this.regionSize = regionSize;
        this.componentSize = componentSize;
        this.d1 = d1;
    }

    @Override
    public float getRegionOrigin(float componentSize) {
        return this.d1;
    }

    @Override
    public float getRegionSize(float componentSize) {
        return this.regionSize;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public float getComponentSize(float regionSize) throws InsetterNotInvertibleException {
        return Math.max(this.componentSize, regionSize + this.getFixedInset1() + this.getFixedInset2());
    }

    @Override
    public float getFixedInset1() {
        return this.d1;
    }

    @Override
    public float getFixedInset2() {
        return this.componentSize - this.regionSize - this.d1;
    }

    @Override
    public float getFixedRegionSize() {
        return this.regionSize;
    }
}

