/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.BasicImageSupport;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.ImageUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.jnr.impl.PixelRaster;

public class ReusableCompositor {
    @Nullable
    private int[] data;
    @NotNull
    private final PixelRaster dataAccess = new MyPixelRaster();
    @Nullable
    private BufferedImage b;
    private boolean isConfigured;
    private boolean isEmpty;
    private int rasterWidth;
    private int rasterHeight;
    private int scaleFactor;

    public ReusableCompositor() {
    }

    public ReusableCompositor(@NotNull int[] data, int rw, int rh, int scaleFactor) {
        if (rw < 0 || rh < 0) {
            throw new IllegalArgumentException("Invalid negative raster width and/or height");
        }
        if (scaleFactor < 1 || scaleFactor > 8) {
            throw new IllegalArgumentException("Invalid or unsupported scale factor");
        }
        this.data = data;
        this.rasterWidth = rw;
        this.rasterHeight = rh;
        this.scaleFactor = scaleFactor;
        this.isConfigured = true;
        this.isEmpty = true;
    }

    @NotNull
    public static ColorModel getColorModel() {
        return BasicImageSupport.getColorModel();
    }

    public int getRasterWidth() {
        return this.rasterWidth;
    }

    public int getRasterHeight() {
        return this.rasterHeight;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public float getWidth() {
        return (float)this.rasterWidth / (float)this.scaleFactor;
    }

    public float getHeight() {
        return (float)this.rasterHeight / (float)this.scaleFactor;
    }

    @NotNull
    public ReusableCompositor createSimilar() {
        ReusableCompositor c = new ReusableCompositor();
        c.reset(this.rasterWidth, this.rasterHeight, this.scaleFactor);
        return c;
    }

    @NotNull
    public ReusableCompositor createSimilar(float width, float height) {
        ReusableCompositor c = new ReusableCompositor();
        int rw = (int)Math.ceil(width * (float)this.scaleFactor);
        int rh = (int)Math.ceil(height * (float)this.scaleFactor);
        c.reset(rw, rh, this.scaleFactor);
        return c;
    }

    @NotNull
    public ReusableCompositor createHorizontallyFlippedCopy() {
        ReusableCompositor output = this.createSimilar();
        output.copyHorizontallyFlippedFrom(this);
        return output;
    }

    @NotNull
    public ReusableCompositor createVerticallyFlippedCopy() {
        ReusableCompositor output = this.createSimilar();
        output.copyVerticallyFlippedFrom(this);
        return output;
    }

    public void reset(int rasterWidth, int rasterHeight, int scaleFactor) {
        if (rasterWidth < 0 || rasterHeight < 0) {
            throw new IllegalArgumentException("Invalid negative raster width and/or height");
        }
        if (scaleFactor < 1 || scaleFactor > 8) {
            throw new IllegalArgumentException("Invalid or unsupported scale factor");
        }
        this.rasterWidth = rasterWidth;
        this.rasterHeight = rasterHeight;
        this.scaleFactor = scaleFactor;
        this.isEmpty = true;
    }

    protected void ensureConfigured() {
        if (!this.isConfigured) {
            this.isConfigured = true;
            int requiredSize = this.rasterWidth * this.rasterHeight;
            if (requiredSize > 0) {
                if (this.data == null || this.data.length < requiredSize) {
                    this.data = new int[requiredSize];
                    this.b = null;
                } else {
                    Arrays.fill(this.data, 0);
                }
            }
        }
    }

    public void render(@NotNull BasicRenderer r, int rasterWidth, int rasterHeight, int scaleFactor) {
        this.reset(rasterWidth, rasterHeight, scaleFactor);
        this.ensureConfigured();
        if (this.data != null) {
            float rw = (float)rasterWidth / (float)scaleFactor;
            float rh = (float)rasterHeight / (float)scaleFactor;
            r.render(this.data, rasterWidth, rasterHeight, rw, rh);
            this.isEmpty = false;
        }
    }

    public void compose(@NotNull Object o) {
        if (o instanceof BasicRenderer) {
            BasicRenderer br = (BasicRenderer)o;
            this.composeRenderer(br);
        } else if (o instanceof PainterExtension) {
            PainterExtension px = (PainterExtension)o;
            this.composePainter(px, 0.0f, 0.0f);
        } else if (o instanceof ReusableCompositor) {
            ReusableCompositor rc = (ReusableCompositor)o;
            this.composeFrom(rc, 0, 0, this.rasterWidth, this.rasterHeight);
        } else if (o instanceof PixelRaster) {
            PixelRaster r = (PixelRaster)o;
            this.composeFrom(r, 0, 0, this.rasterWidth, this.rasterHeight);
        } else if (o instanceof PixelSource) {
            PixelSource sr = (PixelSource)o;
            sr.composeTo(this);
        } else {
            throw new UnsupportedOperationException("Unsupported pixel source");
        }
    }

    public void composeRenderer(@NotNull BasicRenderer r) {
        this.ensureConfigured();
        if (this.data != null) {
            if (this.isEmpty) {
                float rw = (float)this.rasterWidth / (float)this.scaleFactor;
                float rh = (float)this.rasterHeight / (float)this.scaleFactor;
                r.render(this.data, this.rasterWidth, this.rasterHeight, rw, rh);
                this.isEmpty = false;
            } else {
                this.composeRenderer(r, 0, 0, this.rasterWidth, this.rasterHeight);
            }
        }
    }

    public void composeRenderer(@NotNull BasicRenderer r, int dx, int dy, int dw, int dh) {
        if (dw > 0 && dh > 0) {
            ReusableCompositor temp = new ReusableCompositor();
            temp.render(r, dw, dh, this.scaleFactor);
            this.composeFrom(temp, dx, dy, dw, dh);
        }
    }

    public void composePainter(@NotNull PainterExtension px, int dx, int dy, int dw, int dh) {
        if (dw > 0 && dh > 0) {
            ReusableCompositor temp = new ReusableCompositor();
            temp.reset(dw, dh, this.scaleFactor);
            temp.composePainter(px, 0.0f, 0.0f);
            this.composeFrom(temp, dx, dy, dw, dh);
        }
    }

    private void copyHorizontallyFlippedFrom(@NotNull ReusableCompositor source) {
        this.ensureConfigured();
        if (this.data != null) {
            this.copyHorizontallyFlippedFrom(source.dataAccess);
        }
    }

    private void copyHorizontallyFlippedFrom(@NotNull PixelRaster source) {
        this.ensureConfigured();
        if (this.data != null) {
            source.provide((sourceData, sourceWidth, sourceHeight) -> {
                if (sourceWidth > 0 && sourceHeight > 0) {
                    this.isEmpty = true;
                    for (int row = 0; row < this.rasterHeight; ++row) {
                        for (int col = 0; col < this.rasterWidth; ++col) {
                            int sourceCol = this.rasterWidth - col - 1;
                            int pixel = sourceData[row * sourceWidth + sourceCol];
                            int alpha = ImageUtils.alpha(pixel);
                            if (alpha == 0) continue;
                            this.isEmpty = false;
                            this.data[row * this.rasterWidth + col] = pixel;
                        }
                    }
                }
            });
        }
    }

    private void copyVerticallyFlippedFrom(@NotNull ReusableCompositor source) {
        this.ensureConfigured();
        if (this.data != null) {
            this.copyVerticallyFlippedFrom(source.dataAccess);
        }
    }

    private void copyVerticallyFlippedFrom(@NotNull PixelRaster source) {
        this.ensureConfigured();
        if (this.data != null) {
            source.provide((sourceData, sourceWidth, sourceHeight) -> {
                if (sourceWidth > 0 && sourceHeight > 0) {
                    this.isEmpty = true;
                    for (int row = 0; row < this.rasterHeight; ++row) {
                        for (int col = 0; col < this.rasterWidth; ++col) {
                            int sourceRow = this.rasterHeight - row - 1;
                            int pixel = sourceData[sourceRow * sourceWidth + col];
                            int alpha = ImageUtils.alpha(pixel);
                            if (alpha == 0) continue;
                            this.isEmpty = false;
                            this.data[row * this.rasterWidth + col] = pixel;
                        }
                    }
                }
            });
        }
    }

    public void composeFrom(@NotNull ReusableCompositor source, int dx, int dy, int dw, int dh) {
        this.ensureConfigured();
        if (this.data != null) {
            this.composeFrom(source.dataAccess, dx, dy, dw, dh);
        }
    }

    public void composeFrom(@NotNull PixelRaster source, int dx, int dy, int dw, int dh) {
        this.ensureConfigured();
        if (this.data != null) {
            source.provide((sourceData, sourceWidth, sourceHeight) -> {
                if (sourceWidth > 0 && sourceHeight > 0) {
                    this.isEmpty = false;
                    int columnCount = Math.min(dw, sourceWidth);
                    int rowCount = Math.min(dh, sourceHeight);
                    for (int rowOffset = 0; rowOffset < rowCount; ++rowOffset) {
                        int row = dy + rowOffset;
                        if (row < 0 || row >= this.rasterHeight) continue;
                        for (int colOffset = 0; colOffset < columnCount; ++colOffset) {
                            int pixel;
                            int alpha;
                            int col = dx + colOffset;
                            if (col < 0 || col >= this.rasterWidth || (alpha = ImageUtils.alpha(pixel = sourceData[rowOffset * sourceWidth + colOffset])) == 0) continue;
                            if (alpha != 255) {
                                pixel = JNRUtils.combine(this.data[row * this.rasterWidth + col], pixel);
                            }
                            this.data[row * this.rasterWidth + col] = pixel;
                        }
                    }
                }
            });
        }
    }

    public void composeFrom(@NotNull ReusableCompositor source, int sx, int sy, int dx, int dy, int dw, int dh) {
        this.ensureConfigured();
        if (this.data != null) {
            this.composeFrom(source.dataAccess, sx, sy, dx, dy, dw, dh);
        }
    }

    public void composeFrom(@NotNull PixelRaster source, int sx, int sy, int dx, int dy, int dw, int dh) {
        this.ensureConfigured();
        if (this.data != null) {
            source.provide((sourceData, sourceWidth, sourceHeight) -> {
                if (sourceWidth > 0 && sourceHeight > 0) {
                    this.isEmpty = false;
                    for (int rowOffset = 0; rowOffset < dh; ++rowOffset) {
                        int sourceRow = sy + rowOffset;
                        int row = dy + rowOffset;
                        if (row < 0 || row >= this.rasterHeight || sourceRow < 0 || sourceRow >= sourceHeight) continue;
                        for (int colOffset = 0; colOffset < dw; ++colOffset) {
                            int pixel;
                            int alpha;
                            int sourceColumn = sx + colOffset;
                            int col = dx + colOffset;
                            if (col < 0 || col >= this.rasterWidth || sourceColumn < 0 || sourceColumn >= sourceWidth || (alpha = ImageUtils.alpha(pixel = sourceData[sourceRow * sourceWidth + sourceColumn])) == 0) continue;
                            if (alpha != 255) {
                                pixel = JNRUtils.combine(this.data[row * this.rasterWidth + col], pixel);
                            }
                            this.data[row * this.rasterWidth + col] = pixel;
                        }
                    }
                }
            });
        }
    }

    public void composePainter(@NotNull PainterExtension px, float x, float y) {
        BufferedImage im = this.getImage();
        if (im != null) {
            this.isEmpty = false;
            Graphics2D g = im.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.scale(this.scaleFactor, this.scaleFactor);
            g.translate(x, y);
            float rw = (float)this.rasterWidth / (float)this.scaleFactor;
            float rh = (float)this.rasterHeight / (float)this.scaleFactor;
            px.paint(g, rw, rh);
        }
    }

    public void renderFrom(@NotNull BasicRenderer r) {
        this.ensureConfigured();
        if (this.data != null) {
            this.isEmpty = false;
            float w = (float)this.rasterWidth / (float)this.scaleFactor;
            float h = (float)this.rasterHeight / (float)this.scaleFactor;
            r.render(this.data, this.rasterWidth, this.rasterHeight, w, h);
        }
    }

    public void blendFrom(@NotNull ReusableCompositor source, @NotNull PixelOperator op) {
        this.blendFrom(source, op, 0, 0, this.rasterWidth, this.rasterHeight);
    }

    public void blendFrom(@NotNull ReusableCompositor source, @NotNull PixelOperator op, int dx, int dy, int dw, int dh) {
        this.ensureConfigured();
        if (this.data != null) {
            this.blendFrom(source.dataAccess, op, dx, dy, dw, dh);
        }
    }

    public void blendFrom(@NotNull PixelRaster source, @NotNull PixelOperator op, int dx, int dy, int dw, int dh) {
        this.ensureConfigured();
        if (this.data != null) {
            source.provide((sourceData, sourceWidth, sourceHeight) -> {
                if (sourceWidth > 0 && sourceHeight > 0) {
                    for (int rowOffset = 0; rowOffset < dh; ++rowOffset) {
                        int row = dy + rowOffset;
                        if (row < 0 || row >= this.rasterHeight) continue;
                        for (int colOffset = 0; colOffset < dw; ++colOffset) {
                            int sourcePixel;
                            int destinationIndex;
                            int destinationPixel;
                            int pixel;
                            int alpha;
                            int col = dx + colOffset;
                            if (col < 0 || col >= this.rasterWidth || (alpha = ImageUtils.alpha(pixel = op.combine(destinationPixel = this.data[destinationIndex = row * this.rasterWidth + col], sourcePixel = sourceData[rowOffset * sourceWidth + colOffset]))) == 0) continue;
                            this.data[destinationIndex] = pixel;
                            this.isEmpty = false;
                        }
                    }
                }
            });
        }
    }

    public void erase(int dx, int dy, int dw, int dh) {
        if (dw > 0 && dh > 0) {
            this.ensureConfigured();
            if (this.data != null) {
                for (int rowOffset = 0; rowOffset < dh; ++rowOffset) {
                    int row = dy + rowOffset;
                    if (row < 0 || row >= this.rasterHeight) continue;
                    for (int colOffset = 0; colOffset < dw; ++colOffset) {
                        int col = dx + colOffset;
                        if (col < 0 || col >= this.rasterWidth) continue;
                        this.data[row * this.rasterWidth + col] = 0;
                    }
                }
            }
        }
    }

    @Nullable
    public BufferedImage getImage() {
        this.ensureConfigured();
        if (this.b == null && this.data != null) {
            this.b = BasicImageSupport.createImage(this.data, this.rasterWidth, this.rasterHeight);
        }
        return this.b;
    }

    public void paint(@NotNull Graphics2D g) {
        BufferedImage im = this.getImage();
        if (im != null) {
            g.drawImage(im, null, null);
        }
    }

    private class MyPixelRaster
    implements PixelRaster {
        @NotNull
        private final int[] emptyRaster = new int[0];

        private MyPixelRaster() {
        }

        @Override
        public void provide(@NotNull PixelRaster.Accessor a) {
            if (ReusableCompositor.this.data == null) {
                a.access(this.emptyRaster, 0, 0);
            } else {
                a.access(ReusableCompositor.this.data, ReusableCompositor.this.rasterWidth, ReusableCompositor.this.rasterHeight);
            }
        }
    }

    public static interface PixelSource {
        public void composeTo(@NotNull ReusableCompositor var1);
    }

    public static interface PixelOperator {
        public int combine(int var1, int var2);
    }
}

