/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.RasterDescription;
import org.violetlib.jnr.impl.RendererDescription;

public final class MultiResolutionRendererDescription
implements RendererDescription {
    @NotNull
    private final RendererDescription rd1;
    @NotNull
    private final RendererDescription rd2;

    public MultiResolutionRendererDescription(@NotNull RendererDescription rd1, @NotNull RendererDescription rd2) {
        this.rd1 = rd1;
        this.rd2 = rd2;
    }

    @Override
    public boolean isTrivial() {
        return this.rd1.isTrivial() && this.rd2.isTrivial();
    }

    @NotNull
    public RendererDescription getDescription1() {
        return this.rd1;
    }

    @NotNull
    public RendererDescription getDescription2() {
        return this.rd2;
    }

    @Override
    @NotNull
    public RasterDescription getRasterBounds(@NotNull Rectangle2D target, int scaleFactor) {
        return scaleFactor == 1 ? this.rd1.getRasterBounds(target, scaleFactor) : this.rd2.getRasterBounds(target, scaleFactor);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiResolutionRendererDescription that = (MultiResolutionRendererDescription)o;
        return Objects.equals(this.rd1, that.rd1) && Objects.equals(this.rd2, that.rd2);
    }

    public int hashCode() {
        return Objects.hash(this.rd1, this.rd2);
    }
}

