/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.impl.CombinedInsetter;
import org.violetlib.jnr.impl.FixedInsetter1;
import org.violetlib.jnr.impl.FloatingInsetter1;
import org.violetlib.jnr.impl.Insetter1;
import org.violetlib.jnr.impl.RigidInsetter1;

public class Insetters {
    @NotNull
    public static Insetter createFixed(float top, float left, float bottom, float right) {
        return new CombinedInsetter(new FixedInsetter1(left, right), new FixedInsetter1(top, bottom));
    }

    @NotNull
    public static Insetter createFixed(float top, float left, float bottom, float right, @Nullable LayoutInfo layoutInfo) {
        Insetter1 horizontal = null;
        Insetter1 vertical = null;
        if (layoutInfo != null) {
            float fixedComponentHeight;
            float fixedComponentWidth = layoutInfo.getFixedVisualWidth();
            if (fixedComponentWidth > 0.0f) {
                horizontal = new RigidInsetter1(fixedComponentWidth - (left + right), fixedComponentWidth, left);
            }
            if ((fixedComponentHeight = layoutInfo.getFixedVisualHeight()) > 0.0f) {
                vertical = new RigidInsetter1(fixedComponentHeight - (top + bottom), fixedComponentHeight, top);
            }
        }
        if (horizontal == null) {
            horizontal = new FixedInsetter1(left, right);
        }
        if (vertical == null) {
            vertical = new FixedInsetter1(top, bottom);
        }
        return new CombinedInsetter(horizontal, vertical);
    }

    @NotNull
    public static Insetter createLeftAligned(float regionWidth, float left, float top, float bottom) {
        return new CombinedInsetter(FloatingInsetter1.createLeftTopAligned(regionWidth, left), new FixedInsetter1(top, bottom));
    }

    @NotNull
    public static Insetter createRightAligned(float regionWidth, float right, float top, float bottom) {
        return new CombinedInsetter(FloatingInsetter1.createRightBottomAligned(regionWidth, right), new FixedInsetter1(top, bottom));
    }

    @NotNull
    public static Insetter createTopAligned(float regionHeight, float top, float left, float right) {
        return new CombinedInsetter(new FixedInsetter1(left, right), FloatingInsetter1.createLeftTopAligned(regionHeight, top));
    }

    @NotNull
    public static Insetter createBottomAligned(float regionHeight, float bottom, float left, float right) {
        return new CombinedInsetter(new FixedInsetter1(left, right), FloatingInsetter1.createRightBottomAligned(regionHeight, bottom));
    }
}

