/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.LayoutInfo;

public class BasicLayoutInfo
implements LayoutInfo {
    private final float fixedWidth;
    private final float fixedHeight;
    private final float minimumWidth;
    private final float minimumHeight;
    @NotNull
    private static final LayoutInfo EMPTY = new BasicLayoutInfo(0.0f, 0.0f, 0.0f, 0.0f);

    @NotNull
    public static LayoutInfo getInstance() {
        return EMPTY;
    }

    @NotNull
    public static LayoutInfo createFixedWidth(float fixedWidth) {
        return new BasicLayoutInfo(fixedWidth, 0.0f, 0.0f, 0.0f);
    }

    @NotNull
    public static LayoutInfo createFixedHeight(float fixedHeight) {
        return new BasicLayoutInfo(0.0f, fixedHeight, 0.0f, 0.0f);
    }

    @NotNull
    public static LayoutInfo createFixed(float fixedWidth, float fixedHeight) {
        return new BasicLayoutInfo(fixedWidth, fixedHeight, 0.0f, 0.0f);
    }

    @NotNull
    public static LayoutInfo createMinimumWidth(float minWidth) {
        return new BasicLayoutInfo(0.0f, 0.0f, minWidth, 0.0f);
    }

    @NotNull
    public static LayoutInfo createMinimumHeight(float minHeight) {
        return new BasicLayoutInfo(0.0f, 0.0f, 0.0f, minHeight);
    }

    @NotNull
    public static LayoutInfo createMinimum(float minWidth, float minHeight) {
        return new BasicLayoutInfo(0.0f, 0.0f, minWidth, minHeight);
    }

    @NotNull
    public static LayoutInfo create(boolean isWidthFixed, float width, boolean isHeightFixed, float height) {
        float fixedWidth = isWidthFixed ? width : 0.0f;
        float fixedHeight = isHeightFixed ? height : 0.0f;
        float minWidth = isWidthFixed ? 0.0f : width;
        float minHeight = isHeightFixed ? 0.0f : height;
        return new BasicLayoutInfo(fixedWidth, fixedHeight, minWidth, minHeight);
    }

    private BasicLayoutInfo(float fixedWidth, float fixedHeight, float minimumWidth, float minimumHeight) throws IllegalArgumentException {
        if (fixedWidth < 0.0f) {
            throw new IllegalArgumentException("Invalid negative fixed width");
        }
        if (fixedHeight < 0.0f) {
            throw new IllegalArgumentException("Invalid negative fixed height");
        }
        if (minimumWidth < 0.0f) {
            throw new IllegalArgumentException("Invalid negative minimum width");
        }
        if (minimumHeight < 0.0f) {
            throw new IllegalArgumentException("Invalid negative minimum height");
        }
        if (minimumWidth > 0.0f && fixedWidth > 0.0f && minimumWidth != fixedWidth) {
            throw new IllegalArgumentException("Incompatible fixed and minimum width");
        }
        if (minimumHeight > 0.0f && fixedHeight > 0.0f && minimumHeight != fixedHeight) {
            throw new IllegalArgumentException("Incompatible fixed and minimum height");
        }
        this.fixedWidth = fixedWidth;
        this.fixedHeight = fixedHeight;
        this.minimumWidth = minimumWidth > 0.0f ? minimumWidth : fixedWidth;
        this.minimumHeight = minimumHeight > 0.0f ? minimumHeight : fixedHeight;
    }

    @Override
    public float getFixedVisualWidth() {
        return this.fixedWidth;
    }

    @Override
    public float getFixedVisualHeight() {
        return this.fixedHeight;
    }

    @Override
    public float getMinimumVisualWidth() {
        return this.minimumWidth;
    }

    @Override
    public float getMinimumVisualHeight() {
        return this.minimumHeight;
    }
}

