/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AnimatedButtonConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ListBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellConfiguration;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.FromMaskOperator;
import org.violetlib.jnr.aqua.impl.LinearSliderRenderer;
import org.violetlib.jnr.aqua.impl.PopupRenderer;
import org.violetlib.jnr.aqua.impl.SliderTickConfiguration;
import org.violetlib.jnr.aqua.impl.TitleBarRendererBase;
import org.violetlib.jnr.aqua.jrs.JRSRenderedPainter;
import org.violetlib.jnr.aqua.jrs.JRSRenderer;
import org.violetlib.jnr.aqua.jrs.JRSRendererDescriptions;
import org.violetlib.jnr.aqua.jrs.JRSRendererMaker;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;
import org.violetlib.jnr.impl.jrs.JRSUIConstants;
import org.violetlib.jnr.impl.jrs.JRSUIControl;
import org.violetlib.jnr.impl.jrs.JRSUIState;
import org.violetlib.vappearances.VAppearance;

public class JRSPainter
extends AquaUIPainterBase {
    protected final JRSRendererMaker maker;
    @NotNull
    private static final JRSRendererDescriptions rendererDescriptions = new JRSRendererDescriptions();

    public JRSPainter() throws UnsupportedOperationException {
        super(rendererDescriptions);
        try {
            JRSUIControl.initJRSUI();
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Unable to initialize the native library: " + ex);
        }
        this.maker = new JRSRendererMaker();
    }

    @Override
    @NotNull
    public JRSPainter copy() {
        return new JRSPainter();
    }

    @Override
    @NotNull
    protected Painter getPainter(@NotNull Configuration g, @NotNull VAppearance appearance, @NotNull Renderer r, float width, float height) {
        JRSUIState state;
        JRSRenderer jr;
        BasicRenderer br = r.getBasicRenderer();
        if (br instanceof JRSRenderer && !(jr = (JRSRenderer)br).isAnimating() && (state = jr.getControlState()) != null) {
            return new JRSRenderedPainter(state, appearance, r, width, height);
        }
        return super.getPainter(g, appearance, r, width, height);
    }

    protected void configureSize(@NotNull AquaUIPainter.Size sz) {
        switch (sz) {
            case REGULAR: {
                this.maker.set(JRSUIConstants.Size.REGULAR);
                break;
            }
            case SMALL: {
                this.maker.set(JRSUIConstants.Size.SMALL);
                break;
            }
            case MINI: {
                this.maker.set(JRSUIConstants.Size.MINI);
                break;
            }
            case LARGE: {
                this.maker.set(JRSUIConstants.Size.LARGE);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void configureState(@NotNull AquaUIPainter.State st) {
        switch (st) {
            case ACTIVE: {
                this.maker.set(JRSUIConstants.State.ACTIVE);
                break;
            }
            case INACTIVE: {
                this.maker.setProperty(JRSUIConstants.State.INACTIVE);
                break;
            }
            case DISABLED: 
            case DISABLED_INACTIVE: {
                this.maker.setProperty(JRSUIConstants.State.DISABLED);
                break;
            }
            case PRESSED: {
                this.maker.setProperty(JRSUIConstants.State.PRESSED);
                break;
            }
            case ACTIVE_DEFAULT: {
                this.maker.setProperty(JRSUIConstants.State.PULSED);
                break;
            }
            case ROLLOVER: {
                this.maker.setProperty(JRSUIConstants.State.ROLLOVER);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void configureLayoutDirection(@NotNull AquaUIPainter.UILayoutDirection ld) {
    }

    protected void configureOrientation(@NotNull AquaUIPainter.Orientation o) {
        switch (o) {
            case HORIZONTAL: {
                this.maker.set(JRSUIConstants.Orientation.HORIZONTAL);
                break;
            }
            case VERTICAL: {
                this.maker.set(JRSUIConstants.Orientation.VERTICAL);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void configureDirection(@NotNull AquaUIPainter.Direction d) {
        switch (d) {
            case NONE: {
                this.maker.set(JRSUIConstants.Direction.NONE);
                break;
            }
            case UP: {
                this.maker.set(JRSUIConstants.Direction.UP);
                break;
            }
            case DOWN: {
                this.maker.set(JRSUIConstants.Direction.DOWN);
                break;
            }
            case LEFT: {
                this.maker.set(JRSUIConstants.Direction.LEFT);
                break;
            }
            case RIGHT: {
                this.maker.set(JRSUIConstants.Direction.RIGHT);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    @NotNull
    protected Renderer getButtonRenderer(@NotNull ButtonConfiguration g) {
        AquaUIPainter.ButtonWidget bw = this.toCanonicalButtonStyle(g.getButtonWidget());
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            if (g.getButtonState() != AquaUIPainter.ButtonState.ON) {
                return NULL_RENDERER;
            }
            ToolBarItemWellConfiguration tg = new ToolBarItemWellConfiguration(g.getState(), true);
            return this.getToolBarItemWellRenderer(tg);
        }
        RendererDescription rd = rendererDescriptions.getButtonRendererDescription(g);
        this.maker.reset();
        AquaUIPainter.State st = g.getState();
        AquaUIPainter.ButtonState bs = g.getButtonState();
        boolean hasRolloverEffect = false;
        switch (bw) {
            case BUTTON_PUSH: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH);
                break;
            }
            case BUTTON_BEVEL: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL);
                break;
            }
            case BUTTON_BEVEL_ROUND: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL_ROUND);
                break;
            }
            case BUTTON_CHECK_BOX: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_CHECK_BOX);
                break;
            }
            case BUTTON_RADIO: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_RADIO);
                break;
            }
            case BUTTON_DISCLOSURE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_DISCLOSURE);
                break;
            }
            case BUTTON_HELP: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_ROUND_HELP);
                break;
            }
            case BUTTON_GRADIENT: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL_INSET);
                break;
            }
            case BUTTON_RECESSED: {
                if (!this.shouldPaintRecessedBackground(st, bs)) {
                    return NULL_RENDERER;
                }
                hasRolloverEffect = true;
                st = this.adjustRecessedState(st);
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_SCOPE);
                break;
            }
            case BUTTON_INLINE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_INSET2);
                break;
            }
            case BUTTON_ROUNDED_RECT: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_INSET);
                break;
            }
            case BUTTON_TEXTURED: 
            case BUTTON_TEXTURED_TOOLBAR: 
            case BUTTON_TEXTURED_TOOLBAR_ICONS: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_TEXTURED);
                break;
            }
            case BUTTON_ROUND: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_ROUND);
                break;
            }
            case BUTTON_ROUND_INSET: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_ROUND_INSET);
                break;
            }
            case BUTTON_ROUND_TEXTURED: 
            case BUTTON_ROUND_TEXTURED_TOOLBAR: {
                throw new UnsupportedOperationException();
            }
            case BUTTON_DISCLOSURE_TRIANGLE: {
                this.maker.set(JRSUIConstants.Widget.DISCLOSURE_TRIANGLE);
                break;
            }
            case BUTTON_PUSH_INSET2: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_INSET2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (st == AquaUIPainter.State.ROLLOVER && !hasRolloverEffect) {
            st = AquaUIPainter.State.ACTIVE;
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT || bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            if (bs == AquaUIPainter.ButtonState.ON && (st == AquaUIPainter.State.ACTIVE || st == AquaUIPainter.State.INACTIVE)) {
                st = AquaUIPainter.State.PRESSED;
            }
            bs = AquaUIPainter.ButtonState.STATELESS;
        }
        this.configureSize(g.getSize());
        this.configureState(st);
        this.maker.set(JRSUIConstants.AlignmentVertical.CENTER);
        this.maker.set(JRSUIConstants.AlignmentHorizontal.CENTER);
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            AnimatedButtonConfiguration ag;
            AquaUIPainter.ButtonState previousButtonState;
            switch (g.getButtonState()) {
                case ON: {
                    this.maker.set(JRSUIConstants.Direction.DOWN);
                    break;
                }
                case OFF: {
                    this.maker.set(g.getLayoutDirection() == AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT ? JRSUIConstants.Direction.RIGHT : JRSUIConstants.Direction.LEFT);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            int animationFrame = -1;
            if (g instanceof AnimatedButtonConfiguration && (previousButtonState = (ag = (AnimatedButtonConfiguration)g).getPreviousButtonState()) != bs) {
                animationFrame = 1 + Math.round(2.0f * ag.getTransition());
                if (bs == AquaUIPainter.ButtonState.OFF) {
                    animationFrame = 4 - animationFrame;
                }
                this.maker.set(g.getLayoutDirection() == AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT ? JRSUIConstants.Direction.RIGHT : JRSUIConstants.Direction.LEFT);
            }
            this.maker.setAnimationFrame(animationFrame);
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            this.maker.set(bs == AquaUIPainter.ButtonState.OFF ? JRSUIConstants.Direction.DOWN : JRSUIConstants.Direction.UP);
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX || bw == AquaUIPainter.ButtonWidget.BUTTON_RADIO || bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL || bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND || bw == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR_ICONS || bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            switch (bs) {
                case ON: {
                    this.maker.setValue(1.0);
                    break;
                }
                case OFF: {
                    this.maker.setValue(0.0);
                    break;
                }
                case MIXED: {
                    this.maker.setValue(2.0);
                    break;
                }
                case STATELESS: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration g) {
        RendererDescription rd = rendererDescriptions.getTableColumnHeaderRendererDescription(g);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.BUTTON_LIST_HEADER);
        this.maker.set(g.isSelected() ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
        this.maker.set(g.isFocused() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        this.configureState(g.getState());
        switch (g.getSortArrowDirection()) {
            case UP: {
                this.maker.set(JRSUIConstants.Direction.UP);
                break;
            }
            case DOWN: {
                this.maker.set(JRSUIConstants.Direction.DOWN);
                break;
            }
            case NONE: {
                this.maker.set(JRSUIConstants.Direction.NONE);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getScrollColumnSizerRenderer(@NotNull ScrollColumnSizerConfiguration g) {
        RendererDescription rd = rendererDescriptions.getScrollColumnSizerRendererDescription(g);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.SCROLL_COLUMN_SIZER);
        this.configureState(g.getState());
        this.maker.set(JRSUIConstants.AlignmentVertical.CENTER);
        this.maker.set(JRSUIConstants.AlignmentHorizontal.CENTER);
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration g) {
        RendererDescription rd = rendererDescriptions.getScrollBarRendererDescription(g);
        RendererDescription trd = rendererDescriptions.getScrollBarThumbRendererDescription(g);
        AquaUIPainter.State st = g.getState();
        this.maker.reset();
        switch (g.getWidget()) {
            case LEGACY: {
                this.maker.set(JRSUIConstants.Widget.SCROLL_BAR);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.configureSize(g.getSize());
        this.configureState(st == AquaUIPainter.State.ACTIVE ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE);
        this.configureOrientation(g.getOrientation());
        Renderer trackRenderer = null;
        Renderer thumbRenderer = null;
        if (!g.isTrackSuppressed()) {
            this.maker.set(JRSUIConstants.NothingToScroll.YES);
            this.maker.set(JRSUIConstants.ScrollBarPart.NONE);
            trackRenderer = Renderer.create(this.maker.getRenderer(), rd);
        }
        if (st != AquaUIPainter.State.DISABLED && st != AquaUIPainter.State.DISABLED_INACTIVE && g.getKnobWidget() != AquaUIPainter.ScrollBarKnobWidget.NONE) {
            this.maker.set(JRSUIConstants.NothingToScroll.NO);
            this.maker.setValue(g.getThumbPosition());
            this.maker.setThumbStart(g.getThumbPosition());
            this.maker.setThumbPercent(g.getThumbExtent());
            this.maker.set(JRSUIConstants.ShowArrows.NO);
            if (st == AquaUIPainter.State.PRESSED) {
                this.maker.set(JRSUIConstants.ScrollBarPart.THUMB);
            } else {
                this.maker.set(JRSUIConstants.ScrollBarPart.NONE);
            }
            this.maker.set(g.isTrackSuppressed() ? JRSUIConstants.IndicatorOnly.YES : JRSUIConstants.IndicatorOnly.NO);
            thumbRenderer = Renderer.create(this.maker.getRenderer(), trd);
        }
        return Renderer.createCompositeRenderer(trackRenderer, thumbRenderer);
    }

    @Override
    @NotNull
    protected Renderer getToolBarItemWellRenderer(@NotNull ToolBarItemWellConfiguration g) {
        RendererDescription rd = rendererDescriptions.getToolBarItemWellRendererDescription(g);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.TOOLBAR_ITEM_WELL);
        this.configureState(g.getState());
        this.maker.set(g.isFrameOnly() ? JRSUIConstants.FrameOnly.YES : JRSUIConstants.FrameOnly.NO);
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getGroupBoxRenderer(@NotNull GroupBoxConfiguration g) {
        RendererDescription rd = rendererDescriptions.getGroupBoxRendererDescription(g);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.FRAME_GROUP_BOX);
        this.configureState(g.getState());
        this.maker.set(g.isFrameOnly() ? JRSUIConstants.FrameOnly.YES : JRSUIConstants.FrameOnly.NO);
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getListBoxRenderer(@NotNull ListBoxConfiguration g) {
        RendererDescription rd = rendererDescriptions.getListBoxRendererDescription(g);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.FRAME_LIST_BOX);
        this.configureState(g.getState());
        this.maker.set(g.isFrameOnly() ? JRSUIConstants.FrameOnly.YES : JRSUIConstants.FrameOnly.NO);
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getTextFieldRenderer(@NotNull TextFieldConfiguration g) {
        RendererDescription rd = rendererDescriptions.getTextFieldRendererDescription(g);
        AquaUIPainter.TextFieldWidget tw = g.getWidget();
        JRSUIConstants.Widget widget = this.getWidget(tw);
        if (widget != null) {
            this.maker.reset();
            this.maker.set(widget);
            this.configureSize(g.getSize());
            this.configureState(g.getState());
            return Renderer.create(this.maker.getRenderer(), rd);
        }
        if (tw.isSearch()) {
            Insetter searchButtonInsets = this.uiLayout.getSearchButtonPaintingInsets(g);
            Insetter cancelButtonInsets = tw.hasCancel() ? this.uiLayout.getCancelButtonPaintingInsets(g) : null;
            return new SearchFieldRenderer(g, searchButtonInsets, cancelButtonInsets);
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    private JRSUIConstants.Widget getWidget(@NotNull AquaUIPainter.TextFieldWidget tw) {
        switch (tw) {
            case TEXT_FIELD_ROUND: 
            case TEXT_FIELD_ROUND_TOOLBAR: {
                return JRSUIConstants.Widget.FRAME_TEXT_FIELD_ROUND;
            }
            case TEXT_FIELD: {
                return JRSUIConstants.Widget.FRAME_TEXT_FIELD;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Renderer getSearchFieldFindButtonRenderer(@NotNull TextFieldConfiguration g) {
        AquaUIPainter.TextFieldWidget widget = g.getWidget();
        boolean hasMenu = widget.hasMenu();
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.BUTTON_SEARCH_FIELD_FIND);
        if (hasMenu) {
            this.maker.set(JRSUIConstants.Variant.MENU_GLYPH);
        }
        this.configureSize(g.getSize());
        this.configureState(g.getState());
        BasicRenderer r = this.maker.getRenderer();
        RendererDescription rd = this.getSearchFieldFindButtonRendererDescription(g);
        return Renderer.create(r, rd);
    }

    @NotNull
    protected RendererDescription getSearchFieldFindButtonRendererDescription(@NotNull TextFieldConfiguration g) {
        return this.getSearchButtonRendererDescription(g);
    }

    @Override
    @NotNull
    public Renderer getSearchFieldCancelButtonRenderer(@NotNull TextFieldConfiguration g) {
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.BUTTON_SEARCH_FIELD_CANCEL);
        this.configureSize(g.getSize());
        this.configureState(g.getState());
        BasicRenderer r = this.maker.getRenderer();
        RendererDescription rd = this.getSearchFieldCancelButtonRendererDescription(g);
        return Renderer.create(r, rd);
    }

    @NotNull
    protected RendererDescription getSearchFieldCancelButtonRendererDescription(@NotNull TextFieldConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    protected Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration g) {
        RendererDescription rd = rendererDescriptions.getComboBoxRendererDescription(g);
        this.maker.reset();
        switch (g.getWidget()) {
            case BUTTON_COMBO_BOX: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_COMBO_BOX);
                this.maker.set(JRSUIConstants.IndicatorOnly.NO);
                this.maker.set(JRSUIConstants.ArrowsOnly.NO);
                this.maker.set(JRSUIConstants.AlignmentHorizontal.RIGHT);
                this.maker.set(JRSUIConstants.AlignmentVertical.CENTER);
                break;
            }
            case BUTTON_COMBO_BOX_CELL: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        AquaUIPainter.State st = g.getState();
        if (st == AquaUIPainter.State.ROLLOVER) {
            st = AquaUIPainter.State.ACTIVE;
        }
        this.configureSize(g.getSize());
        this.configureState(st);
        this.configureLayoutDirection(g.getLayoutDirection());
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration g) {
        RendererDescription rd = rendererDescriptions.getSegmentedButtonRendererDescription(g);
        AquaUIPainter.Position pos = g.getPosition();
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.State st = g.getState();
        this.maker.reset();
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                this.maker.set(JRSUIConstants.Widget.TAB);
                break;
            }
            case BUTTON_SEGMENTED: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED);
                break;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                pos = AquaUIPainter.Position.ONLY;
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED_INSET);
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED_SCURVE);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED_TEXTURED);
                break;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED_TOOLBAR);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL_INSET);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                pos = AquaUIPainter.Position.ONLY;
                this.maker.set(JRSUIConstants.Widget.BUTTON_SEGMENTED_TEXTURED);
            }
        }
        switch (pos) {
            case FIRST: {
                this.maker.set(JRSUIConstants.SegmentPosition.FIRST);
                break;
            }
            case MIDDLE: {
                this.maker.set(JRSUIConstants.SegmentPosition.MIDDLE);
                break;
            }
            case LAST: {
                this.maker.set(JRSUIConstants.SegmentPosition.LAST);
                break;
            }
            case ONLY: {
                this.maker.set(JRSUIConstants.SegmentPosition.ONLY);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.configureSize(g.getSize());
        this.configureState(st);
        this.configureDirection(g.getDirection());
        this.maker.set(JRSUIConstants.SegmentLeadingSeparator.NO);
        this.maker.set(JRSUIConstants.SegmentTrailingSeparator.YES);
        this.maker.set(g.isSelected() ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
        this.maker.set(g.isFocused() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getPopupButtonRenderer(@NotNull PopupButtonConfiguration g) {
        Renderer basicRenderer = this.getBasicPopupButtonRenderer(g);
        Renderer arrowsRenderer = this.getPopupArrowRenderer(g);
        if (arrowsRenderer != null) {
            Insetter arrowsInsetter = this.uiLayout.getPopUpArrowInsets(g);
            return new PopupRenderer(g, basicRenderer, arrowsRenderer, arrowsInsetter);
        }
        if (basicRenderer != null) {
            return basicRenderer;
        }
        return NULL_RENDERER;
    }

    @Nullable
    protected Renderer getBasicPopupButtonRenderer(@NotNull PopupButtonConfiguration g) {
        if (g.isCell()) {
            return null;
        }
        AquaUIPainter.State st = g.getState();
        RendererDescription rd = rendererDescriptions.getPopupButtonRendererDescription(g);
        this.maker.reset();
        boolean hasRolloverEffect = false;
        switch (g.getPopupButtonWidget()) {
            case BUTTON_POP_DOWN: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_POP_DOWN);
                break;
            }
            case BUTTON_POP_UP: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_POP_UP);
                break;
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL_ROUND);
                break;
            }
            case BUTTON_POP_DOWN_ROUND_RECT: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_POP_DOWN_INSET);
                break;
            }
            case BUTTON_POP_UP_ROUND_RECT: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_POP_UP_INSET);
                break;
            }
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_UP_RECESSED: {
                if (st != AquaUIPainter.State.ROLLOVER && st != AquaUIPainter.State.PRESSED) {
                    return null;
                }
                hasRolloverEffect = true;
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_SCOPE);
                break;
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_PUSH_TEXTURED);
                break;
            }
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_UP_GRADIENT: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL_INSET);
                break;
            }
            case BUTTON_POP_DOWN_SQUARE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL);
                break;
            }
            case BUTTON_POP_UP_SQUARE: {
                this.maker.set(JRSUIConstants.Widget.BUTTON_BEVEL);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (st == AquaUIPainter.State.ROLLOVER && !hasRolloverEffect) {
            st = AquaUIPainter.State.ACTIVE;
        }
        this.maker.set(JRSUIConstants.IndicatorOnly.NO);
        this.maker.set(JRSUIConstants.ArrowsOnly.NO);
        this.maker.set(JRSUIConstants.AlignmentHorizontal.CENTER);
        this.configureSize(g.getSize());
        this.configureState(st);
        this.configureLayoutDirection(g.getLayoutDirection());
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration g) {
        AquaUIPainter.PopupButtonWidget w = g.getPopupButtonWidget();
        AquaUIPainter.State state = g.getState();
        switch (w) {
            case BUTTON_POP_DOWN: 
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                return null;
            }
            case BUTTON_POP_UP_BEVEL: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_UP_SQUARE: 
            case BUTTON_POP_UP_CELL: {
                if (state != AquaUIPainter.State.ROLLOVER) break;
                state = AquaUIPainter.State.ACTIVE;
            }
        }
        if (!g.isPopUp()) {
            return null;
        }
        this.maker.reset();
        this.maker.set(g.isPopUp() ? JRSUIConstants.Widget.BUTTON_POP_UP_SQUARE : JRSUIConstants.Widget.BUTTON_POP_DOWN_SQUARE);
        this.maker.set(JRSUIConstants.IndicatorOnly.YES);
        this.maker.set(JRSUIConstants.ArrowsOnly.YES);
        this.maker.set(JRSUIConstants.AlignmentHorizontal.RIGHT);
        this.configureSize(g.getSize());
        this.configureState(state);
        this.configureLayoutDirection(g.getLayoutDirection());
        BasicRenderer r = this.maker.getRenderer();
        JRSRendererDescriptions rds = rendererDescriptions;
        AquaUIPainter.Size arrowSize = g.getSize();
        RendererDescription rd = rds.getPopUpArrowRendererDescription(g, arrowSize);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getTitleBarRenderer(@NotNull TitleBarConfiguration g) {
        RendererDescription rd = rendererDescriptions.getTitleBarRendererDescription(g);
        Insetter closeButtonInsets = this.uiLayout.getTitleBarButtonInsets(g, AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX);
        Insetter minimizeButtonInsets = this.uiLayout.getTitleBarButtonInsets(g, AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX);
        Insetter resizeButtonInsets = this.uiLayout.getTitleBarButtonInsets(g, AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX);
        return new TitleBarRenderer(g, rd, closeButtonInsets, minimizeButtonInsets, resizeButtonInsets);
    }

    @NotNull
    public Renderer getTitleBarButtonRenderer(@NotNull TitleBarConfiguration g, @NotNull AquaUIPainter.TitleBarButtonWidget bw) {
        AquaUIPainter.State st;
        JRSUIConstants.Widget widget;
        switch (bw) {
            case CLOSE_BOX: {
                widget = JRSUIConstants.Widget.TITLE_BAR_CLOSE_BOX;
                st = g.getCloseButtonState();
                break;
            }
            case MINIMIZE_BOX: {
                widget = JRSUIConstants.Widget.TITLE_BAR_COLLAPSE_BOX;
                st = g.getMinimizeButtonState();
                break;
            }
            case RESIZE_BOX: {
                widget = JRSUIConstants.Widget.TITLE_BAR_ZOOM_BOX;
                st = g.getResizeButtonState();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        AquaUIPainter.TitleBarWidget tw = g.getWidget();
        int offset = tw == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? -1 : 1;
        this.maker.reset();
        this.maker.set(widget);
        this.maker.set(this.toWindowType(g));
        this.maker.set(JRSUIConstants.AlignmentVertical.CENTER);
        this.configureState(st);
        if (bw == AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX) {
            this.maker.set(g.isDirty() ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
        }
        BasicRenderer r = this.maker.getRenderer();
        BasicRendererDescription rd = new BasicRendererDescription(offset, 0.0f, 0.0f, 0.0f);
        return Renderer.create(r, rd);
    }

    @NotNull
    protected JRSUIConstants.WindowType toWindowType(@NotNull TitleBarConfiguration g) {
        switch (g.getWidget()) {
            case DOCUMENT_WINDOW: {
                return JRSUIConstants.WindowType.DOCUMENT;
            }
            case UTILITY_WINDOW: {
                return JRSUIConstants.WindowType.UTILITY;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected Renderer getIndeterminateProgressIndicatorRenderer(@NotNull IndeterminateProgressIndicatorConfiguration g) {
        RendererDescription rd = rendererDescriptions.getIndeterminateProgressIndicatorRendererDescription(g);
        AquaUIPainter.Size sz = g.getSize();
        this.maker.reset();
        switch (g.getWidget()) {
            case INDETERMINATE_SPINNER: {
                this.maker.set(JRSUIConstants.Widget.PROGRESS_SPINNER);
                if (sz == AquaUIPainter.Size.SMALL) break;
                sz = AquaUIPainter.Size.LARGE;
                break;
            }
            case INDETERMINATE_BAR: {
                JRSUIConstants.Orientation orientation = g.getOrientation() == AquaUIPainter.Orientation.VERTICAL ? JRSUIConstants.Orientation.VERTICAL : JRSUIConstants.Orientation.HORIZONTAL;
                this.maker.set(JRSUIConstants.Widget.PROGRESS_INDETERMINATE_BAR);
                this.maker.set(orientation);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.configureSize(sz);
        this.configureState(g.getState());
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getProgressIndicatorRenderer(@NotNull ProgressIndicatorConfiguration g) {
        if (g.getWidget() == AquaUIPainter.ProgressWidget.SPINNER) {
            throw new UnsupportedOperationException();
        }
        RendererDescription rd = rendererDescriptions.getProgressIndicatorRendererDescription(g);
        JRSUIConstants.Orientation orientation = g.getOrientation() == AquaUIPainter.Orientation.VERTICAL ? JRSUIConstants.Orientation.VERTICAL : JRSUIConstants.Orientation.HORIZONTAL;
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.PROGRESS_BAR);
        this.maker.set(orientation);
        this.configureSize(g.getSize());
        this.configureState(g.getState());
        this.maker.setValue(g.getValue());
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration g) {
        RendererDescription rd = rendererDescriptions.getSliderRendererDescription(g);
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.SliderWidget sw = g.getWidget();
        double value = g.getValue();
        this.maker.reset();
        AquaUIPainter.State st = g.getState();
        if (st == AquaUIPainter.State.ROLLOVER) {
            st = AquaUIPainter.State.ACTIVE;
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            if (st == AquaUIPainter.State.PRESSED) {
                st = AquaUIPainter.State.ACTIVE;
            }
            int degrees = (int)Math.round(value * 360.0);
            this.maker.reset();
            this.maker.set(JRSUIConstants.Widget.DIAL);
            this.maker.set(JRSUIConstants.Focused.NO);
            this.maker.set(JRSUIConstants.NoIndicator.YES);
            this.configureSize(sz);
            this.configureState(st);
            this.maker.setValue(degrees);
            return Renderer.create(this.maker.getRenderer(), rd);
        }
        int style = this.getSliderRenderingVersion();
        Renderer trackRenderer = this.getSliderTrackRenderer(g);
        Renderer tickMarkRenderer = this.getSliderTickMarkRenderer(g);
        Renderer thumbRenderer = this.getSliderThumbRenderer(g);
        Insetter trackInsets = this.uiLayout.getSliderTrackPaintingInsets(g);
        Insetter thumbInsets = this.uiLayout.getSliderThumbPaintingInsets(g, g.getValue());
        Insetter tickMarkInsets = trackInsets;
        boolean isThumbTranslucent = this.appearance != null && this.appearance.isDark();
        FromMaskOperator tickOperator = null;
        if (style == 2) {
            thumbInsets = trackInsets.prepend(thumbInsets);
            tickOperator = new FromMaskOperator(this.appearance);
        }
        return new LinearSliderRenderer(g, trackRenderer, trackInsets, tickMarkRenderer, tickMarkInsets, thumbRenderer, thumbInsets, isThumbTranslucent, tickOperator);
    }

    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration g) {
        return null;
    }

    @NotNull
    protected Renderer getSliderTrackRenderer(@NotNull SliderConfiguration g) {
        AquaUIPainter.SliderWidget sw = g.getWidget();
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return NULL_RENDERER;
        }
        AquaUIPainter.Size sz = g.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : g.getSize();
        AquaUIPainter.State st = g.getState();
        if (st == AquaUIPainter.State.ROLLOVER) {
            st = AquaUIPainter.State.ACTIVE;
        }
        double value = g.getValue();
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            sw = AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL;
            value = 1.0 - value;
        } else if (sw == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            sw = AquaUIPainter.SliderWidget.SLIDER_VERTICAL;
            value = 1.0 - value;
        }
        boolean isVertical = g.isVertical();
        int tickCount = g.getNumberOfTickMarks();
        AquaUIPainter.TickMarkPosition tickPosition = g.getTickMarkPosition();
        JRSUIConstants.Orientation orientation = isVertical ? JRSUIConstants.Orientation.VERTICAL : JRSUIConstants.Orientation.HORIZONTAL;
        JRSUIConstants.Direction direction = tickCount > 0 ? this.toDirection(tickPosition) : JRSUIConstants.Direction.NONE;
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.SLIDER);
        this.maker.set(JRSUIConstants.NoIndicator.YES);
        this.configureSize(sz);
        this.configureState(st);
        this.maker.set(orientation);
        this.maker.set(direction);
        this.maker.set(g.isFocused() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        this.maker.setValue(value);
        BasicRenderer r = this.maker.getRenderer();
        RendererDescription rd = rendererDescriptions.getSliderTrackRendererDescription(g);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getSliderThumbRenderer(@NotNull SliderConfiguration g) {
        AquaUIPainter.SliderWidget sw = g.getWidget();
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return NULL_RENDERER;
        }
        AquaUIPainter.Size sz = g.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : g.getSize();
        AquaUIPainter.State st = g.getState();
        if (st == AquaUIPainter.State.ROLLOVER) {
            st = AquaUIPainter.State.ACTIVE;
        }
        JRSUIConstants.Orientation orientation = g.isVertical() ? JRSUIConstants.Orientation.VERTICAL : JRSUIConstants.Orientation.HORIZONTAL;
        JRSUIConstants.Direction direction = g.hasTickMarks() ? this.toDirection(g.getTickMarkPosition()) : JRSUIConstants.Direction.NONE;
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.SLIDER_THUMB);
        this.configureSize(sz);
        this.configureState(st);
        this.maker.set(orientation);
        this.maker.set(direction);
        this.maker.set(g.isFocused() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        this.maker.setValue(g.getValue());
        BasicRenderer r = this.maker.getRenderer();
        RendererDescription rd = rendererDescriptions.getSliderThumbRendererDescription(g);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getSliderTickRenderer(@NotNull SliderTickConfiguration g) {
        return NULL_RENDERER;
    }

    @NotNull
    protected JRSUIConstants.Direction toDirection(@NotNull AquaUIPainter.TickMarkPosition p) {
        switch (p) {
            case ABOVE: {
                return JRSUIConstants.Direction.UP;
            }
            case BELOW: {
                return JRSUIConstants.Direction.DOWN;
            }
            case LEFT: {
                return JRSUIConstants.Direction.LEFT;
            }
            case RIGHT: {
                return JRSUIConstants.Direction.RIGHT;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected Renderer getSpinnerArrowsRenderer(@NotNull SpinnerArrowsConfiguration g) {
        RendererDescription rd = rendererDescriptions.getSpinnerArrowsRendererDescription(g);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.BUTTON_LITTLE_ARROWS);
        this.configureSize(g.getSize());
        this.configureState(g.getState());
        if (g.getState() == AquaUIPainter.State.PRESSED) {
            this.maker.set(g.isPressedTop() ? JRSUIConstants.BooleanValue.NO : JRSUIConstants.BooleanValue.YES);
        }
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration g) {
        RendererDescription rd = rendererDescriptions.getSplitPaneDividerRendererDescription(g);
        this.maker.reset();
        switch (g.getWidget()) {
            case THIN_DIVIDER: {
                this.maker.set(JRSUIConstants.Widget.DIVIDER_SEPARATOR_BAR);
                break;
            }
            case THICK_DIVIDER: {
                throw new UnsupportedOperationException();
            }
            case PANE_SPLITTER: {
                this.maker.set(JRSUIConstants.Widget.DIVIDER_SPLITTER);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.configureState(g.getState());
        this.configureOrientation(g.getOrientation());
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @Override
    @NotNull
    protected Renderer getGradientRenderer(@NotNull GradientConfiguration g) {
        RendererDescription rd = rendererDescriptions.getGradientRendererDescription(g);
        this.maker.reset();
        this.maker.set(JRSUIConstants.Widget.GRADIENT);
        switch (g.getWidget()) {
            case GRADIENT_FIND_BAR: 
            case GRADIENT_FINDER_INFO: 
            case GRADIENT_FINDER_SIDE_BAR: 
            case GRADIENT_FREEFORM: {
                throw new UnsupportedOperationException();
            }
            case GRADIENT_LIST_BACKGROUND_EVEN: {
                this.maker.set(JRSUIConstants.Variant.GRADIENT_LIST_BACKGROUND_EVEN);
                break;
            }
            case GRADIENT_LIST_BACKGROUND_ODD: {
                this.maker.set(JRSUIConstants.Variant.GRADIENT_LIST_BACKGROUND_ODD);
                break;
            }
            case GRADIENT_SCOPE_BACKGROUND_BAR: 
            case GRADIENT_SCOPE_BACKGROUND_EVEN: 
            case GRADIENT_SCOPE_BACKGROUND_ODD: {
                throw new UnsupportedOperationException();
            }
            case GRADIENT_SIDE_BAR: {
                this.maker.set(JRSUIConstants.Variant.GRADIENT_SIDE_BAR);
                break;
            }
            case GRADIENT_SIDE_BAR_SELECTION: {
                this.maker.set(JRSUIConstants.Variant.GRADIENT_SIDE_BAR_SELECTION);
                break;
            }
            case GRADIENT_SIDE_BAR_SELECTION_MULTIPLE: {
                throw new UnsupportedOperationException();
            }
        }
        this.maker.set(g.getState() == AquaUIPainter.State.ACTIVE ? JRSUIConstants.State.ACTIVE : JRSUIConstants.State.INACTIVE);
        return Renderer.create(this.maker.getRenderer(), rd);
    }

    @NotNull
    public String toString() {
        return "JRS";
    }

    private class SearchFieldRenderer
    extends Renderer {
        @NotNull
        private final TextFieldConfiguration g;
        @Nullable
        private final Insetter searchButtonInsets;
        @Nullable
        private final Insetter cancelButtonInsets;

        public SearchFieldRenderer(@Nullable TextFieldConfiguration g, @Nullable Insetter searchButtonInsets, Insetter cancelButtonInsets) {
            this.g = g;
            this.searchButtonInsets = searchButtonInsets;
            this.cancelButtonInsets = cancelButtonInsets;
        }

        @Override
        public void composeTo(@NotNull ReusableCompositor compositor) {
            Rectangle2D bounds;
            Renderer r;
            float w = compositor.getWidth();
            float h = compositor.getHeight();
            JRSPainter.this.maker.reset();
            JRSPainter.this.maker.set(JRSUIConstants.Widget.FRAME_TEXT_FIELD_ROUND);
            JRSPainter.this.configureSize(this.g.getSize());
            JRSPainter.this.configureState(this.g.getState());
            BasicRenderer br = JRSPainter.this.maker.getRenderer();
            Renderer r2 = Renderer.create(br, new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f));
            compositor.compose(r2);
            if (this.searchButtonInsets != null) {
                r = JRSPainter.this.getSearchFieldFindButtonRenderer(this.g);
                bounds = this.searchButtonInsets.apply2D(w, h);
                compositor.compose(Renderer.createOffsetRenderer(r, bounds));
            }
            if (this.cancelButtonInsets != null) {
                r = JRSPainter.this.getSearchFieldCancelButtonRenderer(this.g);
                bounds = this.cancelButtonInsets.apply2D(w, h);
                compositor.compose(Renderer.createOffsetRenderer(r, bounds));
            }
        }
    }

    protected class TitleBarRenderer
    extends TitleBarRendererBase {
        public TitleBarRenderer(@NotNull TitleBarConfiguration g, @Nullable RendererDescription rd, @Nullable Insetter closeButtonInsets, @Nullable Insetter minimizeButtonInsets, Insetter resizeButtonInsets) {
            super(g, rd, closeButtonInsets, minimizeButtonInsets, resizeButtonInsets);
        }

        @Override
        @NotNull
        protected BasicRenderer getBasicTitleBarRenderer(float w, float h) {
            LayoutInfo layoutInfo = JRSPainter.this.uiLayout.getLayoutInfo(this.g);
            float titleBarHeight = layoutInfo.getFixedVisualHeight();
            int th = (int)Math.ceil(titleBarHeight);
            JRSPainter.this.maker.reset();
            JRSPainter.this.maker.set(JRSUIConstants.Widget.WINDOW_FRAME);
            JRSPainter.this.maker.set(JRSUIConstants.WindowClipCorners.YES);
            JRSPainter.this.maker.set(JRSPainter.this.toWindowType(this.g));
            JRSPainter.this.maker.setValue(th);
            JRSPainter.this.maker.set(JRSUIConstants.WindowTitleBarSeparator.YES);
            JRSPainter.this.configureState(this.g.getTitleBarState());
            return JRSPainter.this.maker.getRenderer();
        }

        @Override
        @NotNull
        protected Renderer getButtonRenderer(@NotNull AquaUIPainter.TitleBarButtonWidget bw) {
            return JRSPainter.this.getTitleBarButtonRenderer(this.g, bw);
        }
    }
}

