/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.impl.RendererDescriptionsBase;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class ViewRendererDescriptions
extends RendererDescriptionsBase {
    @Override
    @NotNull
    public RendererDescription getButtonRendererDescription(@NotNull ButtonConfiguration g) {
        AquaUIPainter.Size sz;
        AquaUIPainter.ButtonWidget bw;
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        if (platformVersion >= 120000) {
            bw = g.getButtonWidget();
            sz = g.getSize();
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
                if (sz == AquaUIPainter.Size.MINI) {
                    return new BasicRendererDescription(-1.0f, -1.0f, 2.0f, 1.0f);
                }
                return new BasicRendererDescription(-2.0f, -2.0f, 4.0f, 4.0f);
            }
        }
        if (platformVersion >= 101600) {
            bw = g.getButtonWidget();
            sz = g.getSize();
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
                switch (sz) {
                    case LARGE: {
                        return new BasicRendererDescription(-1.49f, 0.0f, 0.0f, 0.0f);
                    }
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, -0.49f, 0.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.0f, -1.49f, 0.0f, 1.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
                switch (sz) {
                    case LARGE: {
                        return new BasicRendererDescription(-1.0f, 0.0f, 1.0f, 0.0f);
                    }
                    case REGULAR: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED) {
                return new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
            }
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
                if (platformVersion >= 101600) {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_HELP && platformVersion >= 101600) {
                switch (sz) {
                    case LARGE: {
                        return new BasicRendererDescription(0.49f, 0.0f, 0.0f, 6.0f);
                    }
                    case REGULAR: {
                        return new BasicRendererDescription(-0.49f, 0.0f, 0.0f, 2.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.49f, 0.0f, 0.0f, 0.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        return super.getButtonRendererDescription(g);
    }

    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration g) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getPopupButtonRendererDescription(@NotNull PopupButtonConfiguration g) {
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        if (platformVersion >= 101600) {
            AquaUIPainter.PopupButtonWidget w = g.getPopupButtonWidget();
            AquaUIPainter.Size sz = g.getSize();
            if (w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN || w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP) {
                switch (sz) {
                    case LARGE: {
                        return new BasicRendererDescription(-4.0f, -1.0f, 8.0f, 1.0f);
                    }
                    case REGULAR: {
                        return new BasicRendererDescription(-2.0f, -1.0f, 5.0f, 4.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(-3.0f, 0.51f, 5.51f, 1.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(-1.0f, 0.0f, 3.0f, 0.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            if (w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED || w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED) {
                switch (sz) {
                    case LARGE: 
                    case REGULAR: {
                        return new BasicRendererDescription(-2.0f, 0.0f, 5.0f, 2.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(-2.51f, 0.0f, 5.51f, 2.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(-1.0f, -1.0f, 3.0f, 2.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        return super.getPopupButtonRendererDescription(g);
    }

    @Override
    @NotNull
    public RendererDescription getComboBoxRendererDescription(@NotNull ComboBoxConfiguration g) {
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, -3.0f, 3.0f, 3.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, -1.0f, 3.0f, 1.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 2.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 2.0f, 2.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        switch (sz) {
            case LARGE: 
            case REGULAR: {
                return new BasicRendererDescription(-0.5f, 0.0f, 3.0f, 1.0f);
            }
            case SMALL: {
                return new BasicRendererDescription(-0.5f, 0.0f, 3.0f, 2.0f);
            }
            case MINI: {
                return new BasicRendererDescription(-0.5f, 0.0f, 2.0f, 2.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getSplitPaneDividerRendererDescription(@NotNull SplitPaneDividerConfiguration g) {
        AquaUIPainter.Orientation o = g.getOrientation();
        switch (g.getWidget()) {
            case THIN_DIVIDER: {
                return o == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 9.0f) : new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
            }
            case THICK_DIVIDER: {
                return o == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f) : new MultiResolutionRendererDescription(new BasicRendererDescription(-4.0f, 0.0f, 6.0f, 0.0f), new BasicRendererDescription(-3.0f, 0.0f, 6.0f, 0.0f));
            }
            case PANE_SPLITTER: {
                return o == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f) : new BasicRendererDescription(-5.0f, 0.0f, 10.0f, 0.0f);
            }
        }
        return null;
    }
}

