/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class SliderHorizontalTickPainter {
    @NotNull
    protected final Color color;
    protected final double w;
    protected final double h;
    protected final double x0;
    protected final double x1;
    protected final double y;
    protected final int tickCount;

    public SliderHorizontalTickPainter(@NotNull Color color, double w, double h, double x0, double x1, double y, int tickCount) {
        this.color = color;
        this.w = w;
        this.h = h;
        this.x0 = x0;
        this.x1 = x1;
        this.y = y;
        this.tickCount = tickCount;
    }

    public void paint(@NotNull Graphics2D g) {
        g.setColor(this.color);
        if (this.tickCount == 1) {
            this.drawTick(g, this.x0);
        } else {
            double spacing = (this.x1 - this.x0) / (double)(this.tickCount - 1);
            double x = this.x0;
            for (int i = 0; i < this.tickCount; ++i) {
                this.drawTick(g, x);
                x += spacing;
            }
        }
    }

    protected void drawTick(@NotNull Graphics2D g, double x) {
        Rectangle2D.Double s = new Rectangle2D.Double(x - this.w / 2.0, this.y, this.w, this.h);
        g.fill(s);
    }
}

