/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeSupport {
    private static final String libraryName = "VAquaRendering";
    private static boolean isAvailable;
    private static boolean isInitialized;

    public static synchronized boolean load() {
        if (!isInitialized) {
            isInitialized = true;
            NativeSupport.loadNativeSupport();
        }
        return isAvailable;
    }

    private static void loadNativeSupport() {
        try {
            String fn = NativeSupport.findNativeLibrary(NativeSupport.class, libraryName);
            if (fn == null) {
                NativeSupport.reportNativeLibraryError("Library not found");
                return;
            }
            System.load(fn);
            String jrsv = NativeSupport.getJavaRuntimeSupportVersion();
            int version = NativeSupport.getJavaRuntimeSupportMajorVersion();
            if (version > 0 && version < 15 || "15.0.0".equals(jrsv)) {
                NativeSupport.log("Found obsolete version of Java Runtime Support framework");
                NativeSupport.log("To upgrade, install Java for OS X 2017-001 from https://support.apple.com/kb/DL1572");
            }
            isAvailable = true;
        }
        catch (UnsatisfiedLinkError e) {
            NativeSupport.reportNativeLibraryError(e.getMessage());
        }
        catch (AccessControlException e) {
            NativeSupport.reportNativeLibraryError("permission denied: " + e.getMessage());
        }
        catch (Throwable e) {
            NativeSupport.reportNativeLibraryError(e.toString());
            e.printStackTrace();
        }
    }

    public static void log(@NotNull String msg) {
        System.err.println(msg);
        try {
            NativeSupport.syslog(msg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void reportNativeLibraryError(@NotNull String msg) {
        String p = System.mapLibraryName(libraryName);
        String s = "NativeSupport: Unable to load library " + p + ": " + msg;
        System.err.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String findNativeLibrary(@NotNull Class<?> root, @NotNull String name) throws IllegalArgumentException {
        InputStream s;
        File lf = NativeSupport.findNativeLibraryOnPath(name);
        if (lf != null) {
            return lf.getPath();
        }
        String prefix = "lib" + name;
        String suffix = ".dylib";
        String libfn = prefix + suffix;
        try {
            s = root.getClassLoader().getResourceAsStream(libfn);
        }
        catch (SecurityException ex) {
            return null;
        }
        if (s == null) {
            return null;
        }
        try {
            File f = File.createTempFile(prefix, suffix).getAbsoluteFile();
            try (FileOutputStream fs = new FileOutputStream(f);){
                NativeSupport.internalInitializeFile(s, fs);
            }
            String string = f.getPath();
            return string;
        }
        catch (IOException ex) {
            System.err.println("Unable to extract native library resource: " + ex.getMessage());
            String string = null;
            return string;
        }
        finally {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Nullable
    private static File findNativeLibraryOnPath(@NotNull String name) throws IllegalArgumentException {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Invalid library name: name is empty");
        }
        if (name.indexOf(32) >= 0 || name.indexOf(46) >= 0 || name.indexOf(File.pathSeparatorChar) >= 0) {
            throw new IllegalArgumentException("Invalid library name");
        }
        String libfn = "lib" + name + ".dylib";
        String lp = System.getProperty("java.library.path");
        if (lp != null) {
            StringTokenizer st = new StringTokenizer(lp, ":");
            while (st.hasMoreTokens()) {
                String prefix = st.nextToken();
                File f = new File(prefix + File.separator + libfn).getAbsoluteFile();
                if (!f.isFile()) continue;
                return f;
            }
        }
        return null;
    }

    private static void internalInitializeFile(@NotNull InputStream sin, @NotNull OutputStream sout) throws IOException {
        int count;
        byte[] buf = new byte[1024];
        while ((count = sin.read(buf)) > 0) {
            sout.write(buf, 0, count);
        }
    }

    public static int getJavaRuntimeSupportMajorVersion() {
        String s = NativeSupport.getJavaRuntimeSupportVersion();
        if (s != null) {
            int n;
            int pos = s.indexOf(46);
            if (pos > 0) {
                s = s.substring(0, pos);
            }
            if ((n = Integer.parseInt(s)) > 0) {
                return n;
            }
        }
        return 0;
    }

    @Nullable
    public static native String getJavaRuntimeSupportVersion();

    public static native void syslog(@NotNull String var0);
}

