/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.vappearances.VAppearance;

public class HybridAquaUIPainter
implements AquaUIPainter {
    @NotNull
    protected final AquaUIPainter viewPainter;
    @NotNull
    protected final AquaUIPainter coreUIPainter;
    @Nullable
    protected final AquaUIPainter jrsPainter;
    @NotNull
    private final AquaUILayoutInfo layout;
    private int w;
    private int h;
    @Nullable
    private VAppearance appearance;

    public HybridAquaUIPainter(@NotNull AquaUIPainter viewPainter, @NotNull AquaUIPainter coreUIPainter, @Nullable AquaUIPainter jrsPainter) {
        this.viewPainter = viewPainter;
        this.coreUIPainter = coreUIPainter;
        this.jrsPainter = jrsPainter;
        this.layout = viewPainter.getLayoutInfo();
    }

    @Override
    @NotNull
    public HybridAquaUIPainter copy() {
        return new HybridAquaUIPainter(this.viewPainter, this.coreUIPainter, this.jrsPainter);
    }

    @Override
    @NotNull
    public Map<String, Color> getColors(@NotNull VAppearance appearance) {
        Colors colors = Colors.getColors(appearance);
        return colors.getColors();
    }

    @Override
    public void configureAppearance(@NotNull VAppearance appearance) {
        this.appearance = appearance;
    }

    @Override
    public void configure(int w, int h) {
        this.w = w;
        this.h = h;
    }

    @Override
    @NotNull
    public Painter getPainter(@NotNull Configuration g) throws UnsupportedOperationException {
        AquaUIPainter p = this.select(g);
        if (this.appearance != null) {
            p.configureAppearance(this.appearance);
        }
        p.configure(this.w, this.h);
        return p.getPainter(g);
    }

    @NotNull
    protected AquaUIPainter select(@NotNull Configuration g) {
        int platformVersion;
        LayoutConfiguration bg;
        if (g instanceof ButtonConfiguration) {
            ButtonConfiguration bg2 = (ButtonConfiguration)g;
            AquaUIPainter.ButtonWidget bw = bg2.getButtonWidget();
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
                return this.viewPainter;
            }
            return this.coreUIPainter;
        }
        if (g instanceof SegmentedButtonConfiguration) {
            SegmentedButtonConfiguration sg = (SegmentedButtonConfiguration)g;
            AquaUIPainter.SegmentedButtonWidget w = sg.getWidget();
            int platformVersion2 = JNRPlatformUtils.getPlatformVersion();
            if (w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE && platformVersion2 < 101600) {
                return this.viewPainter;
            }
            if (platformVersion2 < 101300) {
                if (w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED || w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED || w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE) {
                    return this.viewPainter;
                }
            } else if (platformVersion2 < 101400) {
                if (w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    return this.viewPainter;
                }
            } else if (platformVersion2 >= 101600 && (w.isSlider() && w.isToolbar() || w.isTextured() || w == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED || sg.getState() == AquaUIPainter.State.PRESSED)) {
                return this.coreUIPainter;
            }
            return this.viewPainter;
        }
        if (g instanceof GradientConfiguration) {
            return this.coreUIPainter;
        }
        if (g instanceof ComboBoxConfiguration) {
            int platformVersion3;
            bg = (ComboBoxConfiguration)g;
            AquaUIPainter.ComboBoxWidget w = ((ComboBoxLayoutConfiguration)bg).getWidget();
            AquaUIPainter.State st = ((ComboBoxConfiguration)bg).getState();
            AquaUIPainter.Size sz = ((ComboBoxLayoutConfiguration)bg).getSize();
            if (w == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL ? (platformVersion3 = JNRPlatformUtils.getPlatformVersion()) >= 101200 || sz == AquaUIPainter.Size.MINI : st == AquaUIPainter.State.DISABLED || st == AquaUIPainter.State.DISABLED_INACTIVE || ((ComboBoxLayoutConfiguration)bg).getLayoutDirection() == AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT || w == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || w == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
                return this.coreUIPainter;
            }
        } else if (g instanceof PopupButtonConfiguration) {
            bg = (PopupButtonConfiguration)g;
            if (((PopupButtonLayoutConfiguration)bg).getLayoutDirection() == AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT) {
                return this.coreUIPainter;
            }
            AquaUIPainter.PopupButtonWidget widget = ((PopupButtonLayoutConfiguration)bg).getPopupButtonWidget();
            if (widget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED || widget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED || widget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR || widget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR) {
                return this.coreUIPainter;
            }
        } else {
            if (g instanceof ProgressIndicatorConfiguration) {
                ProgressIndicatorConfiguration bg3 = (ProgressIndicatorConfiguration)g;
                return this.coreUIPainter;
            }
            if (g instanceof IndeterminateProgressIndicatorConfiguration) {
                IndeterminateProgressIndicatorConfiguration bg4 = (IndeterminateProgressIndicatorConfiguration)g;
                int platformVersion4 = JNRPlatformUtils.getPlatformVersion();
                if (platformVersion4 >= 101600 && bg4.getWidget() == AquaUIPainter.ProgressWidget.INDETERMINATE_BAR) {
                    return this.viewPainter;
                }
                return this.coreUIPainter;
            }
            if (g instanceof TextFieldConfiguration) {
                bg = (TextFieldConfiguration)g;
                AquaUIPainter.TextFieldWidget w = ((TextFieldLayoutConfiguration)bg).getWidget();
                if (w != AquaUIPainter.TextFieldWidget.TEXT_FIELD && w != AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND) {
                    return this.coreUIPainter;
                }
            } else {
                if (g instanceof SliderConfiguration) {
                    int platformVersion5;
                    SliderConfiguration bg5 = (SliderConfiguration)g;
                    if (bg5.getSize() == AquaUIPainter.Size.MINI && (platformVersion5 = JNRPlatformUtils.getPlatformVersion()) < 101500) {
                        return this.viewPainter;
                    }
                    return this.coreUIPainter;
                }
                if (g instanceof TitleBarConfiguration) {
                    return this.coreUIPainter;
                }
                if (g instanceof ScrollBarConfiguration) {
                    return this.coreUIPainter;
                }
            }
        }
        if ((platformVersion = JNRPlatformUtils.getPlatformVersion()) >= 101400) {
            return this.coreUIPainter;
        }
        return this.jrsPainter != null ? this.jrsPainter : this.coreUIPainter;
    }

    @Override
    @NotNull
    public AquaUILayoutInfo getLayoutInfo() {
        return this.layout;
    }

    @Override
    @Nullable
    public Shape getOutline(@NotNull LayoutConfiguration g) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getOutline(g);
    }

    @Override
    @NotNull
    public Rectangle2D getComboBoxEditorBounds(@NotNull ComboBoxLayoutConfiguration g) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getComboBoxEditorBounds(g);
    }

    @Override
    @NotNull
    public Rectangle2D getComboBoxIndicatorBounds(@NotNull ComboBoxLayoutConfiguration g) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getComboBoxIndicatorBounds(g);
    }

    @Override
    @NotNull
    public Rectangle2D getPopupButtonContentBounds(@NotNull PopupButtonLayoutConfiguration g) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getPopupButtonContentBounds(g);
    }

    @Override
    @NotNull
    public Rectangle2D getSliderThumbBounds(@NotNull SliderLayoutConfiguration g, double thumbPosition) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getSliderThumbBounds(g, thumbPosition);
    }

    @Override
    public double getSliderThumbPosition(@NotNull SliderLayoutConfiguration g, int x, int y) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getSliderThumbPosition(g, x, y);
    }

    @Override
    public float getScrollBarThumbPosition(@NotNull ScrollBarThumbLayoutConfiguration g, boolean useExtent) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getScrollBarThumbPosition(g, useExtent);
    }

    @Override
    public int getScrollBarThumbHit(@NotNull ScrollBarThumbConfiguration g) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getScrollBarThumbHit(g);
    }

    @Override
    @NotNull
    public Rectangle2D getSliderLabelBounds(@NotNull SliderLayoutConfiguration g, double thumbPosition, @NotNull Dimension size) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getSliderLabelBounds(g, thumbPosition, size);
    }

    @NotNull
    public String toString() {
        String s = "Hybrid " + this.viewPainter + "+" + this.coreUIPainter;
        if (this.jrsPainter != null) {
            s = s + "+" + this.jrsPainter;
        }
        return s;
    }
}

