/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class ColorWellRenderer
extends Renderer {
    @NotNull
    private final ButtonConfiguration bg;
    @NotNull
    private final Renderer basic;

    public ColorWellRenderer(@NotNull ButtonConfiguration bg, @NotNull Renderer basic) {
        this.bg = bg;
        this.basic = basic;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor compositor) {
        int scaleFactor;
        int rw = compositor.getRasterWidth();
        int rh = compositor.getRasterHeight();
        int lt = scaleFactor = compositor.getScaleFactor();
        int gt = 4 * scaleFactor;
        int bt = lt * 2 + gt;
        this.basic.composeTo(compositor);
        BorderPainter bp = new BorderPainter(scaleFactor);
        compositor.renderFrom(bp);
        int dx = bt;
        int dy = bt;
        int dw = rw - 2 * bt;
        int dh = rh - 2 * bt;
        compositor.erase(dx, dy, dw, dh);
    }

    protected class BorderPainter
    implements PainterExtension,
    BasicRenderer {
        private final Color outer;
        private final Color inner;
        private final int scaleFactor;

        public BorderPainter(int scaleFactor) {
            this.scaleFactor = scaleFactor;
            switch (ColorWellRenderer.this.bg.getState()) {
                case DISABLED: 
                case DISABLED_INACTIVE: {
                    this.outer = new Color(170, 170, 170, 127);
                    this.inner = new Color(168, 168, 168);
                    break;
                }
                case PRESSED: {
                    this.outer = new Color(175, 175, 175);
                    this.inner = new Color(86, 86, 86);
                    break;
                }
                default: {
                    this.outer = new Color(175, 175, 175);
                    this.inner = new Color(138, 138, 138);
                }
            }
        }

        @Override
        public void paint(@NotNull Graphics2D g, float width, float height) {
            int w = (int)width;
            int h = (int)height;
            g.setColor(this.outer);
            g.drawRect(0, 0, w, h);
            g.setColor(this.inner);
            g.drawRect(5, 5, w - 10, h - 10);
        }

        @Override
        public void render(@NotNull int[] data, int rw, int rh, float w, float h) {
            this.drawRect(data, rw, rh, this.outer, 0, 0, rw, rh);
            this.drawRect(data, rw, rh, this.inner, 5 * this.scaleFactor, 5 * this.scaleFactor, rw - 10 * this.scaleFactor, rh - 10 * this.scaleFactor);
        }

        protected void drawRect(int[] data, int rw, int rh, Color c, int dx, int dy, int dw, int dh) {
            if (dw > 0 && dh > 0) {
                ColorModel cm = ReusableCompositor.getColorModel();
                ColorSpace cs = cm.getColorSpace();
                float[] components = c.getComponents(cs, null);
                float alpha = components[3];
                int i = 0;
                while (i < 3) {
                    int n = i++;
                    components[n] = components[n] * alpha;
                }
                int pixel = cm.getDataElement(components, 0);
                for (int i2 = 0; i2 < this.scaleFactor; ++i2) {
                    this.drawRect1(data, rw, rh, pixel, dx + i2, dy + i2, dw - 2 * i2, dh - 2 * i2);
                }
            }
        }

        protected void drawRect1(int[] data, int rw, int rh, int pixel, int dx, int dy, int dw, int dh) {
            if (dw > 0 && dh > 0) {
                for (int x = dx; x < dx + dw; ++x) {
                    data[dy * rw + x] = pixel;
                    data[(dy + dh - 1) * rw + x] = pixel;
                }
                for (int y = dy + 1; y < dy + dh - 1; ++y) {
                    data[y * rw + dx] = pixel;
                    data[y * rw + dx + dw - 1] = pixel;
                }
            }
        }
    }
}

