/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.TableColumnHeaderLayoutConfiguration;

public class TableColumnHeaderConfiguration
extends TableColumnHeaderLayoutConfiguration
implements Configuration {
    @NotNull
    private final AquaUIPainter.State state;
    @NotNull
    private final AquaUIPainter.ColumnSortArrowDirection d;
    private final boolean isSelected;
    private final boolean isFocused;

    public TableColumnHeaderConfiguration(@NotNull AquaUIPainter.State state, @NotNull AquaUIPainter.ColumnSortArrowDirection d, boolean isSelected, boolean isFocused, @NotNull AquaUIPainter.UILayoutDirection ld) {
        super(ld, d != AquaUIPainter.ColumnSortArrowDirection.NONE);
        this.state = state;
        this.d = d;
        this.isSelected = isSelected;
        this.isFocused = isFocused;
    }

    public TableColumnHeaderConfiguration(@NotNull AquaUIPainter.State state, boolean isSortable, boolean isSelected, boolean isFocused, @NotNull AquaUIPainter.UILayoutDirection ld) {
        super(ld, isSortable);
        this.state = state;
        this.d = AquaUIPainter.ColumnSortArrowDirection.NONE;
        this.isSelected = isSelected;
        this.isFocused = isFocused;
    }

    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    @NotNull
    public AquaUIPainter.ColumnSortArrowDirection getSortArrowDirection() {
        return this.d;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TableColumnHeaderConfiguration that = (TableColumnHeaderConfiguration)o;
        return this.state == that.state && this.d == that.d && this.isSelected == that.isSelected && this.isFocused == that.isFocused;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.state, this.d, this.isSelected, this.isFocused});
    }

    @Override
    @NotNull
    public String toString() {
        String lds = this.getLayoutDirection() == AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT ? " RTL" : "";
        String ss = this.d == AquaUIPainter.ColumnSortArrowDirection.NONE && this.isSortable() ? " - Sortable" : "";
        String fs = this.isFocused ? " focused" : "";
        String sls = this.isSelected ? " selected" : "";
        return "Table Column Header" + ss + lds + " " + (Object)((Object)this.state) + " " + (Object)((Object)this.d) + sls + fs;
    }
}

