/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.fc.AquaFileSystemView;
import org.violetlib.aqua.fc.BrowserPreviewRenderer;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.FilePreviewView;
import org.violetlib.aqua.fc.JBrowser;
import org.violetlib.aqua.fc.NameView;
import org.violetlib.aqua.fc.OSXFile;

public class FilePreview
extends JComponent
implements BrowserPreviewRenderer {
    private JFileChooser fileChooser;
    private FileInfo info;
    private NameView nameView;
    private JLabel typeSizeView;
    private JTable attributeView;
    private Font labelFont;
    private Font valueFont;
    private Font typeSizeFont;
    private String labelDelimiter;
    private TableColumn nameColumn;
    private TableColumn valueColumn;
    private SimpleTableCellRenderer nameRenderer;
    private SimpleTableCellRenderer valueRenderer;
    private FilePreviewView view;
    private JPanel viewHolder;

    public FilePreview(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
        int n = OSXSystemProperties.OSVersion;
        int n2 = 210;
        int n3 = n >= 1014 ? 240 : n2;
        int n4 = 335;
        this.setMinimumSize(new Dimension(n2, n4));
        this.setPreferredSize(new Dimension(n3, n4));
        this.viewHolder = new JPanel();
        this.viewHolder.setMinimumSize(new Dimension(128, 128));
        this.viewHolder.setPreferredSize(new Dimension(128, 128));
        this.view = new FilePreviewView();
        this.view.track(this.viewHolder);
        this.setBorder(BorderFactory.createEmptyBorder(3, 4, 4, 4));
        this.setLayout(new BorderLayout());
        this.labelFont = UIManager.getFont("FileChooser.previewLabelFont");
        this.valueFont = UIManager.getFont("FileChooser.previewValueFont");
        this.typeSizeFont = UIManager.getFont("FileChooser.previewTypeSizeFont");
        this.labelDelimiter = UIManager.getString("FileChooser.previewLabelDelimiter");
        if (this.labelDelimiter == null) {
            this.labelDelimiter = "";
        }
        int n5 = 5;
        Serializable serializable = new DefaultTableColumnModel();
        this.nameColumn = new TableColumn();
        this.nameRenderer = new SimpleTableCellRenderer(this.labelFont);
        this.nameRenderer.setHorizontalAlignment(4);
        Object object = new Insets(0, 0, 0, 0);
        this.nameRenderer.putClientProperty("Quaqua.Component.visualMargin", object);
        this.nameColumn.setCellRenderer(this.nameRenderer);
        this.nameColumn.setModelIndex(0);
        serializable.addColumn(this.nameColumn);
        this.valueColumn = new TableColumn();
        this.valueRenderer = new SimpleTableCellRenderer(this.valueFont);
        this.valueRenderer.setHorizontalAlignment(2);
        this.valueColumn.setCellRenderer(this.valueRenderer);
        this.valueColumn.setModelIndex(1);
        serializable.addColumn(this.valueColumn);
        this.attributeView = new JTable(null, (TableColumnModel)((Object)serializable));
        this.attributeView.setIntercellSpacing(new Dimension(n5, 0));
        this.attributeView.setAutoResizeMode(0);
        this.attributeView.setRowSelectionAllowed(false);
        this.attributeView.setFocusable(false);
        this.attributeView.setOpaque(false);
        this.attributeView.setAlignmentX(0.5f);
        this.setOpaque(false);
        this.add(this.viewHolder);
        serializable = new Box(1);
        this.add((Component)serializable, "South");
        if (OSXSystemProperties.OSVersion < 1010) {
            object = new GrayLine();
            ((JComponent)object).setBorder(new EmptyBorder(5, 25, 5, 25));
            ((Container)serializable).add((Component)object);
        } else {
            this.nameView = new NameView();
            this.nameView.setAlignmentX(0.5f);
            if (OSXSystemProperties.OSVersion >= 1014) {
                this.typeSizeView = new JLabel();
                this.typeSizeView.setFont(this.typeSizeFont);
                this.typeSizeView.setAlignmentX(0.5f);
            } else {
                this.valueRenderer.setRowZeroFont(this.typeSizeFont);
            }
            ((Container)serializable).add(Box.createVerticalStrut(5));
            ((Container)serializable).add(this.nameView);
            if (OSXSystemProperties.OSVersion < 1014) {
                ((Container)serializable).add(Box.createVerticalStrut(20));
            }
            if (this.typeSizeView != null) {
                ((Container)serializable).add(this.typeSizeView);
            }
            if (OSXSystemProperties.OSVersion >= 1014) {
                ((Container)serializable).add(Box.createVerticalStrut(20));
            }
        }
        ((Container)serializable).add(this.attributeView);
        ((Container)serializable).add(Box.createVerticalStrut(40));
        object = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    FilePreview.this.fileChooser.approveSelection();
                }
            }
        };
        this.addMouseListener((MouseListener)object);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].addMouseListener((MouseListener)object);
        }
    }

    public void dispose() {
        if (this.view != null) {
            this.view.dispose();
            this.view = null;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        AppearanceManager.ensureAppearance(this);
        Color color = AquaColors.getBackground(this, "controlBackground");
        Color color2 = AquaColors.getSystemColor(this, "secondaryLabel");
        Color color3 = AquaColors.getSystemColor(this, "label");
        this.nameRenderer.setColor(AquaColors.getOrdinaryColor(color2));
        this.valueRenderer.setColor(AquaColors.getOrdinaryColor(color3));
        if (this.typeSizeView != null) {
            this.typeSizeView.setForeground(AquaColors.getOrdinaryColor(color2));
        } else if (OSXSystemProperties.OSVersion >= 1010) {
            this.valueRenderer.setRowZeroColor(AquaColors.getOrdinaryColor(color2));
        }
        if (this.isOpaque()) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected JProgressBar createImageLoadingIndicator() {
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jProgressBar.putClientProperty("JProgressBar.style", "circular");
        return jProgressBar;
    }

    private String toOSXPath(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        AquaFileSystemView aquaFileSystemView = AquaFileSystemView.getAquaFileSystemView();
        if (file != null && file.isDirectory()) {
            stringBuffer.append(':');
        }
        while (file != null) {
            stringBuffer.insert(0, this.fileChooser.getName(file));
            if ((file = ((FileSystemView)aquaFileSystemView).getParentDirectory(file)) == null) continue;
            stringBuffer.insert(0, ':');
        }
        return stringBuffer.toString();
    }

    @Override
    public Component getPreviewRendererComponent(JBrowser jBrowser, TreePath[] treePathArray) {
        Object object;
        if (treePathArray.length != 1) {
            this.setVisible(false);
            return this;
        }
        Locale locale = Locale.getDefault();
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMaximumFractionDigits(1);
        this.info = (FileInfo)treePathArray[0].getLastPathComponent();
        if (!this.info.isAcceptable()) {
            this.setVisible(false);
            return this;
        }
        this.setVisible(true);
        File file = this.info.getFile();
        String string = this.info.getUserName();
        String string2 = OSXFile.getKindString(file);
        String string3 = this.getLengthString(this.info.getFileLength());
        String string4 = this.getModifiedString(file);
        if (this.nameView != null) {
            this.nameView.setText(string);
        }
        AttributeTableModel attributeTableModel = new AttributeTableModel();
        if (OSXSystemProperties.OSVersion < 1010) {
            attributeTableModel.add("name", string);
            attributeTableModel.add("kind", string2);
            if (string3 != null) {
                attributeTableModel.add("size", string3);
            }
            attributeTableModel.add("modified", string4);
            object = OSXFile.getLastUsedDate(file);
            if (object != null) {
                attributeTableModel.add("lastUsed", this.getLastUsedString((Date)object));
            }
        } else {
            Date date;
            object = string2;
            if (string3 != null) {
                object = (String)object + " - " + string3;
            }
            if (this.typeSizeView != null) {
                this.typeSizeView.setText((String)object);
            } else {
                attributeTableModel.add("", (String)object);
            }
            attributeTableModel.add("modified", string4);
            if (OSXSystemProperties.OSVersion < 1014 && (date = OSXFile.getLastUsedDate(file)) != null) {
                attributeTableModel.add("lastUsed", this.getLastUsedString(date));
            }
        }
        if (this.info.isAlias() && (object = this.info.lazyGetResolvedFile()) != null) {
            attributeTableModel.add("original", this.toOSXPath((File)object));
        }
        this.attributeView.setModel(attributeTableModel);
        attributeTableModel.updatePreferredWidths();
        this.attributeView.revalidate();
        this.attributeView.repaint();
        this.updatePreviewImage();
        return this;
    }

    protected String getLengthString(long l) {
        float f;
        String string;
        if (l < 0L) {
            return null;
        }
        if (l >= 1000000000L) {
            string = "FileChooser.sizeGBytesOnly";
            f = (float)l / 1.0E9f;
        } else if (l >= 1000000L) {
            string = "FileChooser.sizeMBytesOnly";
            f = (float)l / 1000000.0f;
        } else if (l >= 1024L) {
            string = "FileChooser.sizeKBytesOnly";
            f = (float)l / 1000.0f;
        } else {
            string = "FileChooser.sizeBytesOnly";
            f = l;
        }
        String string2 = UIManager.getString(string);
        if (string2 != null) {
            return MessageFormat.format(string2, Float.valueOf(f), l);
        }
        return "" + l;
    }

    protected String getModifiedString(File file) {
        if (file != null) {
            return DateFormat.getInstance().format(new Date(file.lastModified()));
        }
        return null;
    }

    protected String getLastUsedString(Date date) {
        return DateFormat.getInstance().format(date);
    }

    private void updatePreviewImage() {
        File file;
        if (this.view != null && this.info != null && (file = this.info.lazyGetResolvedFile()) != null) {
            this.view.configure(file);
        }
    }

    public static int getTextWidth(String string, Font font, JComponent jComponent) {
        Dimension dimension = FilePreview.getTextSize(string, font, jComponent);
        return dimension != null ? dimension.width : 0;
    }

    public static Dimension getTextSize(String string, Font font, JComponent jComponent) {
        if (font == null && (font = jComponent.getFont()) == null) {
            return null;
        }
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = jComponent.getFontMetrics(font);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (fontMetrics == null) {
            return null;
        }
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        return new Dimension(n, n2);
    }

    private static class SimpleTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private Font f;
        private Color fg;
        private Font rowZeroFont;
        private Color rowZeroColor;

        public SimpleTableCellRenderer(Font font) {
            this.f = font;
            this.fg = Color.BLACK;
            this.setOpaque(false);
        }

        public void setRowZeroFont(Font font) {
            this.rowZeroFont = font;
        }

        public void setRowZeroColor(Color color) {
            this.rowZeroColor = color;
        }

        public void setColor(Color color) {
            this.fg = color;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object == null ? "" : object.toString());
            this.setFont(n == 0 && this.rowZeroFont != null ? this.rowZeroFont : this.f);
            this.setForeground(n == 0 && this.rowZeroColor != null ? this.rowZeroColor : this.fg);
            return this;
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        public void repaint(Rectangle rectangle) {
        }

        @Override
        public void repaint() {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
            if (string == "text" || string == "labelFor" || string == "displayedMnemonic" || (string == "font" || string == "foreground") && object != object2 && this.getClientProperty("html") != null) {
                super.firePropertyChange(string, object, object2);
            }
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    private static class GrayLine
    extends JComponent {
        private GrayLine() {
        }

        @Override
        public Dimension getMinimumSize() {
            Insets insets = this.getInsets();
            return new Dimension(0, insets.top + insets.bottom + 1);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            Insets insets = this.getInsets();
            return new Dimension(100000, insets.top + insets.bottom + 1);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Insets insets = this.getInsets();
            graphics.setColor(new Color(217, 217, 217));
            graphics.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, 1);
        }
    }

    private class AttributeTableModel
    extends AbstractTableModel {
        private List<String> names = new ArrayList<String>();
        private List<String> values = new ArrayList<String>();
        private int nameWidth;
        private int valueWidth;

        private AttributeTableModel() {
        }

        public void add(String string, String string2) {
            if (string2 != null && !string2.isEmpty()) {
                String string3 = UIManager.getString("FileChooser." + string);
                String string4 = (string3 != null ? string3 : string) + FilePreview.this.labelDelimiter;
                this.names.add(string4);
                this.values.add(string2);
                this.nameWidth = Math.max(this.nameWidth, FilePreview.getTextWidth(string4, FilePreview.this.labelFont, FilePreview.this.attributeView));
                this.valueWidth = Math.max(this.valueWidth, FilePreview.getTextWidth(string2, FilePreview.this.valueFont, FilePreview.this.attributeView));
            }
        }

        public void updatePreferredWidths() {
            int n = 15;
            FilePreview.this.attributeView.getColumnModel().getColumn(0).setPreferredWidth(this.nameWidth + n);
            FilePreview.this.attributeView.getColumnModel().getColumn(1).setPreferredWidth(this.valueWidth + n);
        }

        @Override
        public int getRowCount() {
            return this.names.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Attribute";
            }
            if (n == 1) {
                return "Value";
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.names.get(n);
            }
            if (n2 == 1) {
                return this.values.get(n);
            }
            return null;
        }
    }

    private static class ScaledImageView
    extends JComponent {
        private Image im;

        private ScaledImageView() {
        }

        public void setImage(Image image) {
            this.im = image;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.im != null) {
                Insets insets = this.getInsets();
                int n = insets.left;
                int n2 = insets.top;
                int n3 = this.getWidth() - insets.left - insets.right;
                int n4 = this.getHeight() - insets.top - insets.bottom;
                float f = this.im.getWidth(null);
                float f2 = this.im.getHeight(null);
                if (f > 0.0f && f2 > 0.0f) {
                    int n5 = Math.min(n3, n4);
                    float f3 = Math.min((float)n3 / f, (float)n4 / f2);
                    int n6 = (int)Math.max(0.0f, ((float)n3 - f * f3) / 2.0f);
                    int n7 = (int)Math.max(0.0f, ((float)n4 - f2 * f3) / 2.0f);
                    graphics.drawImage(this.im, n + n6, n2 + n7, n5, n5, null);
                }
            }
        }
    }
}

