/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.ContextualColor;

public class UniformContainerContextualColors
implements ContainerContextualColors {
    @NotNull
    protected ContextualColor background;
    @NotNull
    protected ContextualColor foreground;
    @NotNull
    protected ContextualColor grid;
    protected boolean isRowSelected;

    public UniformContainerContextualColors(@NotNull ContextualColor contextualColor, @NotNull ContextualColor contextualColor2, @NotNull ContextualColor contextualColor3) {
        this.background = contextualColor;
        this.foreground = contextualColor2;
        this.grid = contextualColor3;
    }

    @Override
    public void configureForContainer() {
        this.isRowSelected = false;
    }

    @Override
    public void configureForRow(int n, boolean bl) {
        this.isRowSelected = bl;
    }

    @Override
    public void configureForRow(boolean bl) {
        this.isRowSelected = bl;
    }

    @Override
    public boolean isStriped() {
        return false;
    }

    @Override
    @NotNull
    public Color getBackground(@NotNull AppearanceContext appearanceContext) {
        appearanceContext = appearanceContext.withSelected(this.isRowSelected || appearanceContext.isSelected());
        return this.background.get(appearanceContext);
    }

    @Override
    @NotNull
    public Color getForeground(@NotNull AppearanceContext appearanceContext) {
        appearanceContext = appearanceContext.withSelected(this.isRowSelected || appearanceContext.isSelected());
        return this.foreground.get(appearanceContext);
    }

    @Override
    @NotNull
    public Color getGrid(@NotNull AppearanceContext appearanceContext) {
        appearanceContext = appearanceContext.withSelected(this.isRowSelected || appearanceContext.isSelected());
        return this.grid.get(appearanceContext);
    }
}

