/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaPopupFactory;
import org.violetlib.aqua.Utils;

public class JavaSupport {
    private static final JavaSupportImpl impl = JavaSupport.findImpl();

    public static int getScaleFactor(Graphics graphics) {
        return impl.getScaleFactor(graphics);
    }

    public static boolean hasOpaqueBeenExplicitlySet(JComponent jComponent) {
        return impl.hasOpaqueBeenExplicitlySet(jComponent);
    }

    public static Image getDockIconImage() {
        return impl.getDockIconImage();
    }

    public static void drawString(JComponent jComponent, Graphics2D graphics2D, String string, float f, float f2) {
        impl.drawString(jComponent, graphics2D, string, f, f2);
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics2D graphics2D, String string, int n, float f, float f2) {
        impl.drawStringUnderlineCharAt(jComponent, graphics2D, string, n, f, f2);
    }

    public static String getClippedString(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        return impl.getClippedString(jComponent, fontMetrics, string, n);
    }

    public static float getStringWidth(JComponent jComponent, FontMetrics fontMetrics, String string) {
        return impl.getStringWidth(jComponent, fontMetrics, string);
    }

    public static void installAATextInfo(UIDefaults uIDefaults) {
        impl.installAATextInfo(uIDefaults);
    }

    public static AquaMultiResolutionImage createMultiResolutionImage(BufferedImage bufferedImage) {
        return impl.createMultiResolutionImage(bufferedImage);
    }

    public static AquaMultiResolutionImage createMultiResolutionImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return impl.createMultiResolutionImage(bufferedImage, bufferedImage2);
    }

    @NotNull
    public static AquaMultiResolutionImage createImage(int n, int n2, int[] nArray, float f) {
        return impl.createImage(n, n2, nArray, f);
    }

    public static Image applyFilter(Image image, ImageFilter imageFilter) {
        return impl.applyFilter(image, imageFilter);
    }

    public static Image applyMapper(Image image, Function<Image, Image> function) {
        return impl.applyMapper(image, function);
    }

    public static Image applyMapper(Image image, AquaMultiResolutionImage.Mapper mapper) {
        return impl.applyMapper(image, mapper);
    }

    @NotNull
    public static Image getResolutionVariant(@NotNull Image image, double d, double d2) {
        return impl.getResolutionVariant(image, d, d2);
    }

    @NotNull
    public static BufferedImage createImage(int n, int n2, int[] nArray) {
        return impl.createImage(n, n2, nArray);
    }

    public static void preload(Image image, int n) {
        impl.preload(image, n);
    }

    public static void lockRenderQueue() {
        impl.lockRenderQueue();
    }

    public static void unlockRenderQueue() {
        impl.unlockRenderQueue();
    }

    public static AquaPopupFactory createPopupFactory() {
        return impl.createPopupFactory();
    }

    public static int getFocusEventCause(@NotNull FocusEvent focusEvent) {
        return impl.getFocusEventCause(focusEvent);
    }

    private static JavaSupportImpl findImpl() {
        int n = Utils.getJavaVersion();
        String string = n >= 900000 ? "Java9Support" : "Java8Support";
        try {
            Class<?> clazz = Class.forName("org.violetlib.aqua." + string);
            return (JavaSupportImpl)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Unsupported Java version: " + n, exception);
        }
    }

    public static interface JavaSupportImpl {
        public int getScaleFactor(Graphics var1);

        public boolean hasOpaqueBeenExplicitlySet(JComponent var1);

        public Image getDockIconImage();

        public void drawString(JComponent var1, Graphics2D var2, String var3, float var4, float var5);

        public void drawStringUnderlineCharAt(JComponent var1, Graphics2D var2, String var3, int var4, float var5, float var6);

        public String getClippedString(JComponent var1, FontMetrics var2, String var3, int var4);

        public float getStringWidth(JComponent var1, FontMetrics var2, String var3);

        public void installAATextInfo(UIDefaults var1);

        public AquaMultiResolutionImage createMultiResolutionImage(BufferedImage var1);

        public AquaMultiResolutionImage createMultiResolutionImage(BufferedImage var1, BufferedImage var2);

        @NotNull
        public AquaMultiResolutionImage createImage(int var1, int var2, int[] var3, float var4);

        public Image applyFilter(Image var1, ImageFilter var2);

        public Image applyMapper(Image var1, Function<Image, Image> var2);

        public Image applyMapper(Image var1, AquaMultiResolutionImage.Mapper var2);

        @NotNull
        public Image getResolutionVariant(@NotNull Image var1, double var2, double var4);

        @NotNull
        public BufferedImage createImage(int var1, int var2, int[] var3);

        public void preload(Image var1, int var2);

        public void lockRenderQueue();

        public void unlockRenderQueue();

        public AquaPopupFactory createPopupFactory();

        public int getFocusEventCause(@NotNull FocusEvent var1);
    }

    public static interface FocusEventCause {
        public static final int UNKNOWN = 0;
        public static final int MOUSE_EVENT = 1;
        public static final int TRAVERSAL = 2;
        public static final int TRAVERSAL_UP = 3;
        public static final int TRAVERSAL_DOWN = 4;
        public static final int TRAVERSAL_FORWARD = 5;
        public static final int TRAVERSAL_BACKWARD = 6;
        public static final int ROLLBACK = 7;
        public static final int UNEXPECTED = 8;
        public static final int ACTIVATION = 9;
        public static final int CLEAR_GLOBAL_FOCUS_OWNER = 10;
    }
}

