/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaSeparatorUI
extends SeparatorUI
implements AquaComponentUI {
    private static int thickness;
    @NotNull
    protected BasicContextualColors colors = AquaColors.SEPARATOR_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaSeparatorUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (thickness == 0) {
            thickness = UIManager.getInt("Separator.width");
        }
        this.installDefaults((JSeparator)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JSeparator)jComponent);
    }

    protected void installDefaults(JSeparator jSeparator) {
        LookAndFeel.installProperty(jSeparator, "opaque", false);
        this.installListeners(jSeparator);
        this.configureAppearanceContext(null, jSeparator);
    }

    protected void uninstallDefaults(JSeparator jSeparator) {
        this.uninstallListeners(jSeparator);
    }

    protected void installListeners(JSeparator jSeparator) {
        AppearanceManager.installListeners(jSeparator);
    }

    protected void uninstallListeners(JSeparator jSeparator) {
        AppearanceManager.uninstallListeners(jSeparator);
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance, (JSeparator)jComponent);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance, @NotNull JSeparator jSeparator) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(jSeparator);
        }
        AquaUIPainter.State state = AquaUIPainter.State.ACTIVE;
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        AquaColors.installColors(jSeparator, this.appearanceContext, this.colors);
        jSeparator.repaint();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        Insets insets = jComponent.getInsets();
        graphics.setColor(jComponent.getForeground());
        int n = insets.left;
        int n2 = insets.top;
        int n3 = Math.max(0, dimension.width - insets.left - insets.right);
        int n4 = Math.max(0, dimension.height - insets.top - insets.bottom);
        if (((JSeparator)jComponent).getOrientation() == 1) {
            int n5 = Math.min(n3, thickness);
            n3 = n5 + (n3 - n5) / 2;
        } else {
            int n6 = Math.min(n4, thickness);
            n4 = n6 + (n4 - n6) / 2;
        }
        graphics.fillRect(n, n2, n3, n4);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        if (((JSeparator)jComponent).getOrientation() == 1) {
            return new Dimension(thickness + insets.left + insets.right, insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, thickness + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (((JSeparator)jComponent).getOrientation() == 1) {
            dimension.height = Integer.MAX_VALUE;
        } else {
            dimension.width = Integer.MAX_VALUE;
        }
        return dimension;
    }
}

