/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.RasterDescription;
import org.violetlib.jnr.impl.RendererDescription;

public final class BasicRendererDescription
implements RendererDescription {
    private final float xOffset;
    private final float yOffset;
    private final float widthAdjustment;
    private final float heightAdjustment;

    public BasicRendererDescription(float f, float f2, float f3, float f4) {
        this.xOffset = f;
        this.yOffset = f2;
        this.widthAdjustment = f3;
        this.heightAdjustment = f4;
    }

    @Override
    public boolean isTrivial() {
        return this.xOffset == 0.0f && this.yOffset == 0.0f && this.widthAdjustment == 0.0f && this.heightAdjustment == 0.0f;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public float getWidthAdjustment() {
        return this.widthAdjustment;
    }

    public float getHeightAdjustment() {
        return this.heightAdjustment;
    }

    @Override
    @NotNull
    public RasterDescription getRasterBounds(@NotNull Rectangle2D rectangle2D, int n) {
        float f = (float)(rectangle2D.getX() + (double)this.xOffset);
        float f2 = (float)(rectangle2D.getY() + (double)this.yOffset);
        float f3 = (float)(rectangle2D.getWidth() + (double)this.widthAdjustment);
        float f4 = (float)(rectangle2D.getHeight() + (double)this.heightAdjustment);
        return new RasterDescription(f, f2, f3, f4);
    }

    @NotNull
    public BasicRendererDescription withAdjustments(float f, float f2, float f3, float f4) {
        return new BasicRendererDescription(this.xOffset + f, this.yOffset + f2, this.widthAdjustment + f3, this.heightAdjustment + f4);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicRendererDescription basicRendererDescription = (BasicRendererDescription)object;
        return Objects.equals(Float.valueOf(this.xOffset), Float.valueOf(basicRendererDescription.xOffset)) && Objects.equals(Float.valueOf(this.yOffset), Float.valueOf(basicRendererDescription.yOffset)) && Objects.equals(Float.valueOf(this.widthAdjustment), Float.valueOf(basicRendererDescription.widthAdjustment)) && Objects.equals(Float.valueOf(this.heightAdjustment), Float.valueOf(basicRendererDescription.heightAdjustment));
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.xOffset), Float.valueOf(this.yOffset), Float.valueOf(this.widthAdjustment), Float.valueOf(this.heightAdjustment));
    }
}

