/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.aqua.fc.SequentialDispatcher;
import org.violetlib.aqua.fc.SidebarTreeFileNode;
import org.violetlib.aqua.fc.Worker;

public class SidebarTreeModel
extends DefaultTreeModel
implements TreeModelListener {
    private TreePath volumesPath;
    private FileSystemTreeModel model;
    private DefaultMutableTreeNode devicesNode;
    private DefaultMutableTreeNode favoritesNode;
    private FileSystemTreeModel.Node computerNode;
    private JFileChooser fileChooser;
    private SequentialDispatcher dispatcher = new SequentialDispatcher();
    private static final File[] defaultUserItems = new File[]{new File(AquaUtils.getProperty("user.home"), "Desktop"), new File(AquaUtils.getProperty("user.home"), "Documents"), new File(AquaUtils.getProperty("user.home"))};

    public SidebarTreeModel(JFileChooser jFileChooser, TreePath treePath, FileSystemTreeModel fileSystemTreeModel) {
        super(new DefaultMutableTreeNode(), true);
        this.fileChooser = jFileChooser;
        this.volumesPath = treePath;
        this.model = fileSystemTreeModel;
        this.computerNode = fileSystemTreeModel.getRoot();
        this.devicesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.devices"));
        this.devicesNode.setAllowsChildren(true);
        this.favoritesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.favorites"));
        this.favoritesNode.setAllowsChildren(true);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        defaultMutableTreeNode.add(this.favoritesNode);
        defaultMutableTreeNode.add(this.devicesNode);
        this.updateUserNode();
        this.updateDevicesNode();
        fileSystemTreeModel.addTreeModelListener(this);
    }

    public void lazyValidate() {
    }

    public void invokeWhenValid(Runnable runnable) {
        runnable.run();
    }

    private void updateUserNode() {
        List<Node> list = this.getUserFavorites();
        this.replaceNodes(this.favoritesNode, list);
    }

    private void updateDevicesNode() {
        Map<String, OSXFile.SystemItemInfo> map = this.readVolumes();
        ArrayList<SidebarViewToModelNode> arrayList = new ArrayList<SidebarViewToModelNode>();
        FileSystemTreeModel.Node node = this.computerNode;
        OSXFile.SystemItemInfo systemItemInfo = map.get("Computer");
        if (systemItemInfo != null && systemItemInfo.isVisible) {
            arrayList.add(this.createDeviceNode(node, -2, systemItemInfo.icon));
        }
        for (OSXFile.SystemItemInfo systemItemInfo2 : map.values()) {
            String string;
            if (systemItemInfo2 == systemItemInfo || (string = systemItemInfo2.path) == null) continue;
            File file = new File(string);
            arrayList.add(this.createDeviceNode(file, systemItemInfo2.sequenceNumber, systemItemInfo2.icon));
        }
        Collections.sort(arrayList, new SideBarViewToModelNodeComparator());
        this.replaceNodes(this.devicesNode, arrayList);
    }

    private SidebarViewToModelNode createDeviceNode(FileSystemTreeModel.Node node, int n, Icon icon) {
        return new SidebarViewToModelNode(node, n, icon);
    }

    private SidebarViewToModelNode createDeviceNode(File file, int n, Icon icon) {
        TreePath treePath = this.model.toPath(file, null);
        FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)treePath.getLastPathComponent();
        return new SidebarViewToModelNode(node, n, icon);
    }

    private void replaceNodes(DefaultMutableTreeNode defaultMutableTreeNode, List<? extends DefaultMutableTreeNode> list) {
        int n;
        Object[] objectArray;
        int[] nArray;
        int n2 = defaultMutableTreeNode.getChildCount();
        if (n2 > 0) {
            nArray = new int[n2];
            objectArray = new Object[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = n;
                objectArray[n] = defaultMutableTreeNode.getChildAt(n);
            }
            defaultMutableTreeNode.removeAllChildren();
            this.fireTreeNodesRemoved(this, defaultMutableTreeNode.getPath(), nArray, objectArray);
        }
        if (list.size() > 0) {
            nArray = new int[list.size()];
            objectArray = new Object[list.size()];
            for (n = 0; n < list.size(); ++n) {
                nArray[n] = n;
                objectArray[n] = list.get(n);
                if (list.get(n) == null) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode("null?"));
                    continue;
                }
                defaultMutableTreeNode.add(list.get(n));
            }
            this.fireTreeNodesInserted(this, defaultMutableTreeNode.getPath(), nArray, objectArray);
        }
    }

    private List<Node> getUserFavorites() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        List<OSXFile.SystemItemInfo> list = OSXFile.getSidebarFiles(0);
        if (list != null) {
            for (OSXFile.SystemItemInfo systemItemInfo : list) {
                Serializable serializable;
                boolean bl;
                String string = systemItemInfo.name;
                String string2 = systemItemInfo.path;
                boolean bl2 = bl = string2 != null && !string2.isEmpty();
                if (!bl && (string.equals("AirDrop") || string.endsWith("-AirDrop")) || string.equals("iCloud") || string.equals("All My Files")) continue;
                if (systemItemInfo.path != null) {
                    serializable = new File(string2);
                    FileNode fileNode = new FileNode((File)serializable);
                    Icon icon = systemItemInfo.icon;
                    if (icon != null) {
                        fileNode.icon = icon;
                    }
                    arrayList.add(fileNode);
                    continue;
                }
                serializable = new AliasNode(string);
                arrayList.add((Node)serializable);
            }
        }
        return arrayList;
    }

    private Map<String, OSXFile.SystemItemInfo> readVolumes() {
        HashMap<String, OSXFile.SystemItemInfo> hashMap = new HashMap<String, OSXFile.SystemItemInfo>();
        List<OSXFile.SystemItemInfo> list = OSXFile.getSidebarFiles(1);
        if (list != null) {
            for (OSXFile.SystemItemInfo systemItemInfo : list) {
                String string = systemItemInfo.name;
                if (systemItemInfo.id == 1) {
                    string = "Computer";
                }
                hashMap.put(string, systemItemInfo);
            }
        }
        return hashMap;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    private class SideBarViewToModelNodeComparator
    implements Comparator<SidebarViewToModelNode> {
        private SideBarViewToModelNodeComparator() {
        }

        @Override
        public int compare(SidebarViewToModelNode sidebarViewToModelNode, SidebarViewToModelNode sidebarViewToModelNode2) {
            return sidebarViewToModelNode.getSequenceNumber() - sidebarViewToModelNode2.getSequenceNumber();
        }
    }

    private class SidebarViewToModelNode
    extends Node {
        private FileSystemTreeModel.Node target;
        private int sequenceNumber;
        private Icon icon;

        public SidebarViewToModelNode(FileSystemTreeModel.Node node, int n, Icon icon) {
            this.target = node;
            this.sequenceNumber = n;
            this.icon = icon;
        }

        @Override
        public File getResolvedFile() {
            return this.target.getResolvedFile();
        }

        @Override
        public String getUserName() {
            return this.target.getUserName();
        }

        @Override
        public Icon getIcon() {
            if (this.icon != null) {
                return this.icon;
            }
            return this.target.getIcon();
        }

        public FileSystemTreeModel.Node getTarget() {
            return this.target;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public String toString() {
            return this.target.toString();
        }
    }

    private class AliasNode
    extends Node {
        private File file;
        private Icon icon;
        private String userName;
        private String aliasName;
        private boolean isTraversable;
        protected int fileLabel;

        public AliasNode(String string) {
            this.fileLabel = -1;
            this.file = null;
            this.aliasName = string;
            this.isTraversable = true;
        }

        @Override
        public File getResolvedFile() {
            if (this.file == null) {
                this.icon = null;
                this.file = OSXFile.resolveAlias(new File(this.aliasName), false);
            }
            return this.file;
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                Icon icon = this.icon = this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                if (this.file != null && !UIManager.getBoolean("FileChooser.speed")) {
                    SidebarTreeModel.this.dispatcher.dispatch(new Worker<Icon>(){

                        @Override
                        public Icon construct() {
                            return SidebarTreeModel.this.fileChooser.getIcon(AliasNode.this.file);
                        }

                        @Override
                        public void done(Icon icon) {
                            AliasNode.this.icon = icon;
                            int[] nArray = new int[]{AliasNode.this.getParent().getIndex(AliasNode.this)};
                            Object[] objectArray = new Object[]{AliasNode.this};
                            SidebarTreeModel.this.fireTreeNodesChanged(SidebarTreeModel.this, ((DefaultMutableTreeNode)AliasNode.this.getParent()).getPath(), nArray, objectArray);
                        }
                    });
                }
            }
            return this.icon;
        }

        @Override
        public String getUserName() {
            if (this.userName == null && this.file != null) {
                this.userName = SidebarTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName == null ? this.aliasName : this.userName;
        }

        public boolean isTraversable() {
            return this.isTraversable;
        }

        @Override
        public String toString() {
            return this.getUserName();
        }
    }

    private abstract class Node
    extends DefaultMutableTreeNode
    implements SidebarTreeFileNode {
        private Node() {
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }
    }

    private class FileNode
    extends Node {
        private File file;
        private Icon icon;
        private String userName;
        private boolean isTraversable;
        protected int fileLabel = -1;

        public FileNode(File file) {
            this.file = file;
            this.isTraversable = file.isDirectory();
        }

        @Override
        public File getResolvedFile() {
            return this.file;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                Icon icon = this.icon = this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                if (!UIManager.getBoolean("FileChooser.speed")) {
                    SidebarTreeModel.this.dispatcher.dispatch(new Worker<Icon>(){

                        @Override
                        public Icon construct() {
                            return SidebarTreeModel.this.fileChooser.getIcon(FileNode.this.file);
                        }

                        @Override
                        public void done(Icon icon) {
                            FileNode.this.icon = icon;
                            int[] nArray = new int[]{FileNode.this.getParent().getIndex(FileNode.this)};
                            Object[] objectArray = new Object[]{FileNode.this};
                            SidebarTreeModel.this.fireTreeNodesChanged(SidebarTreeModel.this, SidebarTreeModel.this.favoritesNode.getPath(), nArray, objectArray);
                        }
                    });
                }
            }
            return this.icon;
        }

        @Override
        public String getUserName() {
            if (this.userName == null) {
                this.userName = SidebarTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName;
        }

        public boolean isTraversable() {
            return this.isTraversable;
        }

        @Override
        public String toString() {
            return this.getUserName();
        }
    }
}

