/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JFileChooser;
import org.violetlib.aqua.AquaListMouseBehavior;
import org.violetlib.aqua.GenericList;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.JBrowser;

public class AquaFileChooserListMouseBehavior
extends AquaListMouseBehavior {
    protected final JFileChooser fc;
    protected FileSelectionHandler fileSelectionHandler;
    protected final int OP_INSTALL_NAME = 1000;
    protected boolean isAcceptableTarget;
    protected boolean isTraversableDirectory;

    public AquaFileChooserListMouseBehavior(JFileChooser jFileChooser, GenericList genericList) {
        super(genericList);
        this.fc = jFileChooser;
    }

    public void setFileSelectionHandler(FileSelectionHandler fileSelectionHandler) {
        this.fileSelectionHandler = fileSelectionHandler;
    }

    @Override
    protected void interpretLocation(MouseEvent mouseEvent) {
        this.targetIndex = this.getIndex(mouseEvent);
        this.dragWouldTransfer = this.list.isDragEnabled();
        this.isAcceptableTarget = this.isAcceptableTarget(this.targetIndex);
        this.isTraversableDirectory = this.isTraversable(this.targetIndex);
    }

    @Override
    protected int getSelectionOperation(MouseEvent mouseEvent) {
        int n = super.getSelectionOperation(mouseEvent);
        if (this.fc.getDialogType() == 1) {
            if (n == 1) {
                return this.isTraversableDirectory ? 1 : 1000;
            }
            return 0;
        }
        if (n == 3 && !this.isAcceptableTarget && this.isTraversableDirectory) {
            return this.list.isSelectionEmpty() || this.list.isRowSelected(this.targetIndex) ? n : 0;
        }
        if (n == 3 && this.isAcceptableTarget && !this.isTraversableDirectory && this.shouldDeselectDirectory()) {
            return 1;
        }
        return n;
    }

    private boolean shouldDeselectDirectory() {
        if (!this.fc.isMultiSelectionEnabled()) {
            return false;
        }
        if (this.fc.isDirectorySelectionEnabled()) {
            return false;
        }
        if (this.list.isRowSelected(this.targetIndex)) {
            return false;
        }
        if (this.list.isSelectionEmpty()) {
            return false;
        }
        int n = this.list.getMinSelectionIndex();
        int n2 = this.list.getMaxSelectionIndex();
        for (int i = n; i <= n2; ++i) {
            if (!this.list.isRowSelected(i) || !this.isTraversable(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void performSelectionOperation(int n) {
        if (n == 1000) {
            File file = this.getFile(this.targetIndex);
            if (file != null && this.fileSelectionHandler != null) {
                this.fileSelectionHandler.fileSelected(file);
            }
        } else {
            super.performSelectionOperation(n);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (this.mouseReleaseOp == 1 && !this.isAcceptableTarget && !this.isTraversableDirectory) {
            this.mouseReleaseOp = 0;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        JBrowser jBrowser;
        super.mouseReleased(mouseEvent);
        if (this.list.isSelectionEmpty() && (jBrowser = this.findBrowser(this.list.getComponent())) != null) {
            jBrowser.requestFocus();
        }
    }

    private JBrowser findBrowser(Component component) {
        while (component != null) {
            if (component instanceof JBrowser) {
                return (JBrowser)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private boolean isAcceptableTarget(int n) {
        Object object;
        if (n >= 0 && (object = this.list.getRow(n)) instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)object;
            return fileInfo.isAcceptable();
        }
        return false;
    }

    private boolean isTraversable(int n) {
        Object object;
        if (n >= 0 && (object = this.list.getRow(n)) instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)object;
            return fileInfo.isTraversable();
        }
        return false;
    }

    @Override
    protected void trimSelectedInterval(int n, int n2) {
        block4: {
            block5: {
                if (n2 <= 0) break block5;
                int n3 = this.list.getRowCount();
                while (++n < n3) {
                    if (this.list.isRowSelected(n)) {
                        this.list.removeSelectionInterval(n, n);
                        continue;
                    }
                    if (!this.isAcceptableTarget(n)) continue;
                    break block4;
                }
                break block4;
            }
            if (n2 >= 0) break block4;
            while (--n >= 0) {
                if (this.list.isRowSelected(n)) {
                    this.list.removeSelectionInterval(n, n);
                    continue;
                }
                if (!this.isAcceptableTarget(n)) continue;
                break;
            }
        }
    }

    @Override
    protected void setSelectionInterval(int n, int n2) {
        if (n == n2) {
            if (this.isAcceptableTarget(n) || this.isTraversable(n)) {
                this.list.setSelectionInterval(n, n);
            }
            return;
        }
        boolean bl = this.list.isValueAdjusting();
        this.list.setValueIsAdjusting(true);
        this.list.clearSelection();
        int n3 = n2 > n ? -1 : 1;
        int n4 = n2;
        while (true) {
            if (this.isAcceptableTarget(n4)) {
                this.list.addSelectionInterval(n4, n4);
            }
            if (n4 == n) break;
            n4 += n3;
        }
        this.list.setValueIsAdjusting(bl);
    }

    @Override
    protected void addSelectionInterval(int n, int n2) {
        int n3 = n > n2 ? -1 : 1;
        int n4 = n;
        while (true) {
            if (this.isAcceptableTarget(n4)) {
                this.list.addSelectionInterval(n4, n4);
            } else {
                this.list.removeSelectionInterval(n4, n4);
            }
            if (n4 == n2) {
                return;
            }
            n4 += n3;
        }
    }

    @Override
    protected void toggleSelectionInterval(int n, int n2) {
        int n3 = n > n2 ? -1 : 1;
        int n4 = n;
        while (true) {
            if (this.isAcceptableTarget(n4) && !this.list.isRowSelected(n4)) {
                this.list.addSelectionInterval(n4, n4);
            } else {
                this.list.removeSelectionInterval(n4, n4);
            }
            if (n4 == n2) {
                return;
            }
            n4 += n3;
        }
    }

    private File getFile(int n) {
        Object object;
        if (n >= 0 && (object = this.list.getRow(n)) instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)object;
            return fileInfo.getFile();
        }
        return null;
    }

    public static interface FileSelectionHandler {
        public void fileSelected(File var1);
    }
}

