/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public abstract class OverlayPainterComponent
extends JComponent {
    protected final Insets margins;
    private final Integer layer;
    private final HierarchyListener baseHierarchyListener;
    private final HierarchyBoundsListener baseHierarchyBoundsListener;
    private final ComponentListener baseComponentListener;
    private Component base;
    private Rectangle baseBounds;
    private Rectangle visibleBounds;

    public OverlayPainterComponent(Insets insets, int n) {
        this.margins = insets;
        this.layer = n;
        this.baseHierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                long l = hierarchyEvent.getChangeFlags();
                boolean bl = OverlayPainterComponent.this.updateHierarchy();
                if (bl || (l & 4L) != 0L) {
                    OverlayPainterComponent.this.updateBounds();
                }
            }
        };
        this.baseHierarchyBoundsListener = new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                OverlayPainterComponent.this.updateBounds();
            }

            @Override
            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                OverlayPainterComponent.this.updateBounds();
            }
        };
        this.baseComponentListener = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                OverlayPainterComponent.this.updateBounds();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                OverlayPainterComponent.this.updateBounds();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                OverlayPainterComponent.this.updateBounds();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                OverlayPainterComponent.this.updateBounds();
            }
        };
        super.setOpaque(false);
    }

    public void attach(JComponent jComponent) {
        if (this.base != jComponent) {
            if (this.base != null) {
                this.base.removeHierarchyListener(this.baseHierarchyListener);
                this.base.removeHierarchyBoundsListener(this.baseHierarchyBoundsListener);
                this.base.removeComponentListener(this.baseComponentListener);
                this.base = null;
            }
            if (jComponent != null) {
                this.base = jComponent;
                this.base.addHierarchyListener(this.baseHierarchyListener);
                this.base.addHierarchyBoundsListener(this.baseHierarchyBoundsListener);
                this.base.addComponentListener(this.baseComponentListener);
            }
        }
        if (this.base != null) {
            this.updateHierarchy();
        }
        this.updateBounds();
        this.repaint();
    }

    @Override
    public final void setOpaque(boolean bl) {
    }

    @Override
    public boolean contains(int n, int n2) {
        return false;
    }

    private boolean updateHierarchy() {
        Container container;
        JRootPane jRootPane;
        JRootPane jRootPane2 = this.getOurRootPane();
        if (jRootPane2 == (jRootPane = this.getDesiredRootPane())) {
            return false;
        }
        if (jRootPane2 != null) {
            container = this.getParent();
            container.remove(this);
        }
        if (jRootPane != null) {
            container = jRootPane.getLayeredPane();
            container.add((Component)this, this.layer);
        }
        return true;
    }

    private void updateBounds() {
        JRootPane jRootPane = this.getOurRootPane();
        if (jRootPane == null || this.base == null) {
            this.baseBounds = null;
            this.visibleBounds = null;
            return;
        }
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        Point point = SwingUtilities.convertPoint(this.base.getParent(), this.base.getLocation(), jLayeredPane);
        Dimension dimension = this.base.getSize();
        int n = point.x - this.margins.left;
        int n2 = point.y - this.margins.top;
        int n3 = dimension.width + this.margins.left + this.margins.right;
        int n4 = dimension.height + this.margins.top + this.margins.bottom;
        if (n != this.getX() || n2 != this.getY() || n3 != this.getWidth() || n4 != this.getHeight()) {
            super.setBounds(n, n2, n3, n4);
            this.repaint();
        }
        this.baseBounds = new Rectangle(this.margins.left, this.margins.top, dimension.width, dimension.height);
        this.visibleBounds = OverlayPainterComponent.getVisibleBounds(this.base);
        if (this.visibleBounds != null) {
            this.visibleBounds = new Rectangle(this.visibleBounds.x + this.margins.left, this.visibleBounds.y + this.margins.top, this.visibleBounds.width, this.visibleBounds.height);
        }
    }

    private JRootPane getDesiredRootPane() {
        if (this.base == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(this.base);
        if (window instanceof RootPaneContainer) {
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            return rootPaneContainer.getRootPane();
        }
        return null;
    }

    private JRootPane getOurRootPane() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof RootPaneContainer) {
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            return rootPaneContainer.getRootPane();
        }
        return null;
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        if (this.visibleBounds != null) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setClip(-1000, -1000, 1000000, 1000000);
            graphics2D.clip(this.visibleBounds);
            graphics2D.translate(this.baseBounds.x, this.baseBounds.y);
            this.internalPaint(graphics2D);
        }
    }

    protected abstract void internalPaint(Graphics2D var1);

    protected static Rectangle getVisibleBounds(Component component) {
        int n = 0;
        int n2 = 0;
        Serializable serializable = component;
        while (serializable.isVisible()) {
            Serializable serializable2;
            if (serializable instanceof JRootPane) {
                serializable2 = serializable.getSize();
                return new Rectangle(n, n2, ((Dimension)serializable2).width, ((Dimension)serializable2).height);
            }
            if (serializable instanceof JViewport) {
                serializable2 = (JViewport)serializable;
                Rectangle rectangle = ((JComponent)serializable2).getVisibleRect();
                return new Rectangle(n + rectangle.x, n2 + rectangle.y, rectangle.width, rectangle.height);
            }
            serializable2 = serializable.getParent();
            if (serializable2 == null) {
                return null;
            }
            n -= serializable.getX();
            n2 -= serializable.getY();
            serializable = serializable2;
        }
        return null;
    }
}

