/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicTableUIPainter;
import org.violetlib.aqua.SelectionRepaintable;

public class AquaTableUI
extends BasicTableUI
implements SelectionRepaintable {
    public static final String TABLE_STYLE_KEY = "JTable.style";
    public static final String QUAQUA_TABLE_STYLE_KEY = "Quaqua.Table.style";
    protected final PropertyChangeListener propertyChangeListener = new TablePropertyChangeListener();
    protected final ListSelectionListener selectionListener = new SelectionListener();
    protected TableCellRenderer originalBooleanRenderer;
    protected AquaTablePainter painter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTableUI();
    }

    public static boolean isStriped(JTable jTable) {
        String string = AquaTableUI.getStyleProperty(jTable);
        return string != null && string.equals("striped");
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, TABLE_STYLE_KEY, QUAQUA_TABLE_STYLE_KEY);
    }

    protected static String getStyleProperty(JTable jTable) {
        return AquaUtils.getProperty(jTable, TABLE_STYLE_KEY, QUAQUA_TABLE_STYLE_KEY);
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.painter = new AquaTablePainter(this.table, this.rendererPane);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.painter = null;
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.table.putClientProperty("terminateEditOnFocusLost", true);
        this.table.putClientProperty("JComponent.isCellContainer", true);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        LookAndFeel.installProperty(this.table, "rowHeight", 19);
        this.originalBooleanRenderer = this.installRendererIfPossible(Boolean.class, new AquaBooleanRenderer());
    }

    @Override
    protected void uninstallDefaults() {
        TableCellRenderer tableCellRenderer = this.table.getDefaultRenderer(Boolean.class);
        if (tableCellRenderer instanceof AquaBooleanRenderer) {
            this.table.setDefaultRenderer(Boolean.class, this.originalBooleanRenderer);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.table.addPropertyChangeListener(this.propertyChangeListener);
        this.updateSelectionListener(null);
    }

    @Override
    protected void uninstallListeners() {
        this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        super.uninstallListeners();
    }

    @Override
    protected KeyListener createKeyListener() {
        KeyListener keyListener = super.createKeyListener();
        return new AquaTableKeyHandler(keyListener);
    }

    protected void updateSelectionListener(ListSelectionModel listSelectionModel) {
        if (listSelectionModel != null) {
            listSelectionModel.removeListSelectionListener(this.selectionListener);
        }
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
    }

    @Override
    public void repaintSelection() {
        AquaFocusHandler.swapSelectionColors("Table", this.table, (Object)this.tableHasFocus());
        this.table.repaint();
    }

    protected boolean tableHasFocus() {
        if (this.table.isEditing()) {
            return AquaFocusHandler.isActive(this.table);
        }
        return AquaFocusHandler.hasFocus(this.table);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.painter != null) {
            this.painter.paint(graphics, jComponent);
        }
    }

    protected TableCellRenderer installRendererIfPossible(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.table.getDefaultRenderer(clazz);
        if (tableCellRenderer2 instanceof UIResource) {
            this.table.setDefaultRenderer(clazz, tableCellRenderer);
        }
        return tableCellRenderer2;
    }

    protected class AquaBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        public AquaBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(false);
            this.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setForeground(jTable.getForeground());
            }
            this.setBackground(new Color(0, 0, 0, 0));
            this.setSelected(object != null && (Boolean)object != false);
            return this;
        }
    }

    protected class AquaTablePainter
    extends BasicTableUIPainter {
        protected final Color[] stripes;
        protected boolean tableHasFocus;
        protected boolean isStriped;
        protected Color selectedBackground;
        protected Color selectedForeground;

        public AquaTablePainter(JTable jTable, CellRendererPane cellRendererPane) {
            super(jTable, cellRendererPane);
            this.stripes = new Color[]{UIManager.getColor("Table.evenRowBackground"), UIManager.getColor("Table.oddRowBackground")};
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            this.tableHasFocus = AquaTableUI.this.tableHasFocus();
            this.selectedBackground = this.table.getSelectionBackground();
            this.selectedForeground = this.table.getSelectionForeground();
            this.isStriped = AquaTableUI.isStriped(this.table);
            boolean bl = this.table.getSelectedRowCount() > 0 && this.table.getRowSelectionAllowed() || this.table.getSelectedColumnCount() > 0 && this.table.getColumnSelectionAllowed();
            Rectangle rectangle = graphics.getClipBounds();
            Rectangle rectangle2 = this.table.getBounds();
            rectangle2.y = 0;
            rectangle2.x = 0;
            if (!rectangle2.intersects(rectangle)) {
                return;
            }
            boolean bl2 = this.table.getComponentOrientation().isLeftToRight();
            Point point = rectangle.getLocation();
            Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            int n = this.table.rowAtPoint(point);
            int n2 = this.table.rowAtPoint(point2);
            if (n == -1) {
                n = 0;
            }
            if (n2 == -1) {
                n2 = this.table.getRowCount() - 1;
            }
            int n3 = this.table.columnAtPoint(bl2 ? point : point2);
            int n4 = this.table.columnAtPoint(bl2 ? point2 : point);
            if (n3 == -1) {
                n3 = 0;
            }
            if (n4 == -1) {
                n4 = this.table.getColumnCount() - 1;
            }
            if (this.isStriped || bl) {
                this.paintBackground(graphics, n, n2, n3, n4);
            }
            this.paintGrid(graphics, n, n2, n3, n4);
            this.paintCells(graphics, n, n2, n3, n4);
        }

        protected void paintBackground(Graphics graphics, int n, int n2, int n3, int n4) {
            int n5;
            Color color;
            int n6;
            int n7;
            Rectangle rectangle = graphics.getClipBounds();
            boolean bl = this.table.getSelectedRowCount() > 0 && this.table.getRowSelectionAllowed() && !this.table.getColumnSelectionAllowed();
            boolean bl2 = this.table.getSelectedColumnCount() > 0 && this.table.getColumnSelectionAllowed() && !this.table.getRowSelectionAllowed();
            int n8 = 0;
            for (n7 = n; n7 <= n2; ++n7) {
                Rectangle rectangle2 = this.table.getCellRect(n7, n3, true);
                int n9 = n6 = bl && this.table.isRowSelected(n7) ? 1 : 0;
                Color color2 = n6 != 0 ? this.selectedBackground : (color = this.isStriped ? this.stripes[n7 % 2] : null);
                if (color == null) {
                    color = this.table.getBackground();
                }
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle2.y, rectangle.width, rectangle2.height);
                n8 = rectangle2.y + rectangle2.height;
            }
            if (this.isStriped && n8 < (n7 = rectangle.y + rectangle.height) && (n5 = this.table.getRowHeight()) > 0) {
                n6 = n2 + 1;
                while (n8 < n7) {
                    color = this.stripes[n6 % 2];
                    graphics.setColor(color);
                    graphics.fillRect(rectangle.x, n8, rectangle.width, n5);
                    ++n6;
                    n8 += n5;
                }
            }
        }

        @Override
        protected void paintGrid(Graphics graphics, int n, int n2, int n3, int n4) {
            block9: {
                int n5;
                int n6;
                Object object;
                graphics.setColor(this.table.getGridColor());
                Rectangle rectangle = this.table.getCellRect(n, n3, true);
                Rectangle rectangle2 = this.table.getCellRect(n2, n4, true);
                Rectangle rectangle3 = rectangle.union(rectangle2);
                if (this.table.getShowHorizontalLines()) {
                    if (this.isStriped) {
                        object = graphics.getClipBounds();
                        n6 = rectangle3.y;
                        for (n5 = n; n5 <= n2; ++n5) {
                            graphics.fillRect(((Rectangle)object).x, (n6 += this.table.getRowHeight(n5)) - 1, ((Rectangle)object).width, 1);
                        }
                    } else {
                        int n7 = rectangle3.x + rectangle3.width;
                        n6 = rectangle3.y;
                        for (n5 = n; n5 <= n2; ++n5) {
                            graphics.fillRect(rectangle3.x, (n6 += this.table.getRowHeight(n5)) - 1, n7, 1);
                        }
                    }
                }
                if (!this.table.getShowVerticalLines()) break block9;
                object = this.table.getColumnModel();
                n6 = rectangle3.y + rectangle3.height;
                if (this.table.getComponentOrientation().isLeftToRight()) {
                    n5 = rectangle3.x;
                    for (int i = n3; i <= n4; ++i) {
                        int n8 = object.getColumn(i).getWidth();
                        graphics.fillRect((n5 += n8) - 1, 0, 1, n6);
                    }
                } else {
                    n5 = rectangle3.x;
                    for (int i = n4; i >= n3; --i) {
                        int n9 = object.getColumn(i).getWidth();
                        graphics.fillRect((n5 += n9) - 1, 0, 1, n6);
                    }
                }
            }
        }

        @Override
        protected void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
            if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
                Component component = this.table.getEditorComponent();
                component.setBounds(rectangle);
                component.validate();
            } else {
                TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
                Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
                Color color = this.getOverrideCellBackground(n, n2);
                if (color != null) {
                    component.setBackground(color);
                }
                this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                color = component.getBackground();
                if (color instanceof UIResource) {
                    component.setBackground(null);
                }
            }
        }

        protected Color getOverrideCellBackground(int n, int n2) {
            if (!this.isStriped) {
                return null;
            }
            if (this.table.isCellSelected(n, n2)) {
                return null;
            }
            JTable.DropLocation dropLocation = this.table.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == n && dropLocation.getColumn() == n2) {
                return null;
            }
            return this.stripes[n % 2];
        }

        @Override
        protected void paintDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
            int n4;
            int n5;
            int n6 = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle = this.table.getCellRect(n, n6, true);
            Rectangle rectangle2 = this.table.getCellRect(n2, n6, true);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            graphics.setColor(this.table.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += n3;
            this.paintDraggedAreaBackground(graphics, rectangle3, n, n2);
            if (this.table.getShowVerticalLines()) {
                graphics.setColor(this.table.getGridColor());
                n5 = rectangle3.x;
                int n7 = rectangle3.y;
                int n8 = n5 + rectangle3.width - 1;
                n4 = n7 + rectangle3.height - 1;
                graphics.drawLine(n5 - 1, n7, n5 - 1, n4);
                graphics.drawLine(n8, n7, n8, n4);
            }
            for (n5 = n; n5 <= n2; ++n5) {
                Rectangle rectangle4 = this.table.getCellRect(n5, n6, false);
                rectangle4.x += n3;
                this.paintCell(graphics, rectangle4, n5, n6);
                if (!this.table.getShowHorizontalLines()) continue;
                graphics.setColor(this.table.getGridColor());
                Rectangle rectangle5 = this.table.getCellRect(n5, n6, true);
                rectangle5.x += n3;
                n4 = rectangle5.x;
                int n9 = rectangle5.y;
                int n10 = n4 + rectangle5.width - 1;
                int n11 = n9 + rectangle5.height - 1;
                graphics.drawLine(n4, n11, n10, n11);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintDraggedAreaBackground(Graphics graphics, Rectangle rectangle, int n, int n2) {
            if (this.isStriped) {
                Graphics graphics2 = graphics.create();
                try {
                    graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.paintBackground(graphics2, n, n2, 0, this.table.getColumnCount() - 1);
                }
                finally {
                    graphics2.dispose();
                }
            } else {
                graphics.setColor(this.table.getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (AquaTableUI.this.table.getRowCount() <= 0 || AquaTableUI.this.table.getColumnCount() <= 0) {
                return;
            }
            int n = this.limit(listSelectionEvent.getFirstIndex(), 0, AquaTableUI.this.table.getRowCount() - 1);
            int n2 = this.limit(listSelectionEvent.getLastIndex(), 0, AquaTableUI.this.table.getRowCount() - 1);
            Rectangle rectangle = AquaTableUI.this.table.getCellRect(n, 0, true);
            Rectangle rectangle2 = AquaTableUI.this.table.getCellRect(n2, 0, true);
            Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, AquaTableUI.this.table.getWidth(), rectangle2.y + rectangle2.height);
            AquaTableUI.this.table.repaint(rectangle3);
        }

        protected int limit(int n, int n2, int n3) {
            return Math.min(n3, Math.max(n, n2));
        }
    }

    protected class AquaTableKeyHandler
    implements KeyListener {
        protected KeyListener base;

        public AquaTableKeyHandler(KeyListener keyListener) {
            this.base = keyListener;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 157) {
                keyEvent.consume();
            } else if (this.base != null) {
                this.base.keyPressed(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.base != null) {
                this.base.keyReleased(keyEvent);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.base != null) {
                this.base.keyTyped(keyEvent);
            }
        }
    }

    public class MouseInputHandler
    extends BasicTableUI.MouseInputHandler {
        public MouseInputHandler() {
            super(AquaTableUI.this);
        }
    }

    protected class TablePropertyChangeListener
    implements PropertyChangeListener {
        protected TablePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string != null) {
                if (string.equals("Frame.active") || string.equals("enabled")) {
                    AquaTableUI.this.repaintSelection();
                    return;
                }
                if (string.equals("selectionModel")) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                    AquaTableUI.this.updateSelectionListener(listSelectionModel);
                }
                if (AquaTableUI.this.isStyleProperty(string)) {
                    AquaTableUI.this.table.repaint();
                }
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            AquaTableUI.this.repaintSelection();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            AquaTableUI.this.repaintSelection();
        }
    }
}

