/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;
import org.violetlib.aqua.AquaCustomStyledWindow;
import org.violetlib.aqua.AquaUtils;

public class AquaRootPaneUI
extends BasicRootPaneUI
implements AncestorListener,
WindowListener,
ContainerListener {
    public static final String AQUA_WINDOW_STYLE_KEY = "Aqua.windowStyle";
    protected JRootPane rootPane;
    protected WindowHierarchyListener hierarchyListener;
    protected boolean isInitialized;
    protected AquaCustomStyledWindow customStyledWindow;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaRootPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        JFrame jFrame;
        Color color;
        Container container;
        this.rootPane = (JRootPane)jComponent;
        super.installUI(jComponent);
        jComponent.addAncestorListener(this);
        if (jComponent.isShowing() && jComponent.isEnabled()) {
            this.updateDefaultButton(this.rootPane);
        }
        if ((container = jComponent.getParent()) != null && container instanceof JFrame && ((color = (jFrame = (JFrame)container).getBackground()) == null || color instanceof UIResource)) {
            jFrame.setBackground(UIManager.getColor("Panel.background"));
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removeAncestorListener(this);
        if (this.customStyledWindow != null) {
            this.customStyledWindow.dispose();
            this.customStyledWindow = null;
        }
        this.isInitialized = false;
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installListeners(JRootPane jRootPane) {
        super.installListeners(jRootPane);
        this.hierarchyListener = new WindowHierarchyListener();
        jRootPane.addHierarchyListener(this.hierarchyListener);
    }

    @Override
    protected void uninstallListeners(JRootPane jRootPane) {
        jRootPane.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        super.uninstallListeners(jRootPane);
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getContainer() instanceof JRootPane) {
            JRootPane jRootPane = (JRootPane)containerEvent.getContainer();
            if (containerEvent.getChild() == jRootPane.getLayeredPane()) {
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                jLayeredPane.addContainerListener(this);
            }
        }
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getContainer() instanceof JRootPane) {
            JRootPane jRootPane = (JRootPane)containerEvent.getContainer();
            if (containerEvent.getChild() == jRootPane.getLayeredPane()) {
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                jLayeredPane.removeContainerListener(this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JRootPane jRootPane;
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if ("defaultButton".equals(string) || "temporaryDefaultButton".equals(string)) {
            JRootPane jRootPane2 = (JRootPane)propertyChangeEvent.getSource();
            if (jRootPane2.isShowing() && jRootPane2.isEnabled()) {
                this.updateDefaultButton(jRootPane2);
            }
        } else if (("enabled".equals(string) || "Frame.active".equals(string)) && (jRootPane = (JRootPane)propertyChangeEvent.getSource()).isShowing() && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
            this.updateDefaultButton((JRootPane)propertyChangeEvent.getSource());
        }
    }

    synchronized void updateDefaultButton(JRootPane jRootPane) {
        JButton jButton = jRootPane.getDefaultButton();
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        JRootPane jRootPane;
        JComponent jComponent;
        JComponent jComponent2 = ancestorEvent.getComponent();
        Window window = SwingUtilities.getWindowAncestor(jComponent2);
        if (window != null) {
            window.removeWindowListener(this);
            window.addWindowListener(this);
        }
        if ((jComponent = ancestorEvent.getComponent()) instanceof JRootPane && (jRootPane = (JRootPane)jComponent).isEnabled() && jRootPane.getDefaultButton() != null) {
            this.updateDefaultButton((JRootPane)jComponent);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        AquaRootPaneUI.updateComponentTreeUIActivation((Component)windowEvent.getSource(), Boolean.TRUE);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        AquaRootPaneUI.updateComponentTreeUIActivation((Component)windowEvent.getSource(), Boolean.FALSE);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        window.removeWindowListener(this);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowStateChanged(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    private static void updateComponentTreeUIActivation(Component component, Object object) {
        if (component instanceof JInternalFrame) {
            Object object2 = object = ((JInternalFrame)component).isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("Frame.active", object);
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray == null) {
            return;
        }
        for (Component component2 : componentArray) {
            AquaRootPaneUI.updateComponentTreeUIActivation(component2, object);
        }
    }

    @Override
    public final void update(Graphics graphics, JComponent jComponent) {
        if (this.customStyledWindow != null) {
            this.customStyledWindow.paintBackground(graphics);
        } else if (jComponent.isOpaque()) {
            AquaUtils.fillRect(graphics, jComponent);
        }
        this.paint(graphics, jComponent);
    }

    protected void installCustomWindowStyle() {
        Window window;
        int n;
        if (this.customStyledWindow == null && (n = this.getCustomWindowStyle()) >= 0 && (window = SwingUtilities.getWindowAncestor(this.rootPane)) != null) {
            try {
                this.customStyledWindow = new AquaCustomStyledWindow(window, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AquaUtils.syslog("Unable to install custom window style: " + illegalArgumentException.getMessage());
            }
        }
    }

    protected int getCustomWindowStyle() {
        Object object = this.rootPane.getClientProperty(AQUA_WINDOW_STYLE_KEY);
        if (object instanceof String) {
            if ("unifiedToolBar".equals(object)) {
                return 3;
            }
            if ("texturedToolBar".equals(object)) {
                return 4;
            }
            if ("combinedToolBar".equals(object)) {
                return 5;
            }
            if ("overlayTitleBar".equals(object)) {
                return 0;
            }
            if ("transparentTitleBar".equals(object)) {
                return 1;
            }
            if ("noTitleBar".equals(object)) {
                return 2;
            }
        }
        return -1;
    }

    protected class WindowHierarchyListener
    implements HierarchyListener {
        protected WindowHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (hierarchyEvent.getChangeFlags() == 2L && AquaRootPaneUI.this.rootPane.isDisplayable() && !AquaRootPaneUI.this.isInitialized) {
                AquaRootPaneUI.this.isInitialized = true;
                AquaRootPaneUI.this.installCustomWindowStyle();
            }
        }
    }
}

