/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.violetlib.aqua.AquaComboBoxUI;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;

public class AquaComboBoxRendererInternal<E>
extends JLabel
implements ListCellRenderer<E> {
    final JComboBox<?> fComboBox;
    boolean fSelected;
    boolean fChecked;
    boolean fInList;
    boolean fEditable;
    boolean fDrawCheckedItem = true;

    public AquaComboBoxRendererInternal(JComboBox<?> jComboBox) {
        this.fComboBox = jComboBox;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension;
        String string = this.getText();
        if (string == null || "".equals(string)) {
            this.setText(" ");
            dimension = super.getPreferredSize();
            this.setText("");
        } else {
            dimension = super.getPreferredSize();
        }
        return dimension;
    }

    @Override
    protected void paintBorder(Graphics graphics) {
    }

    @Override
    public int getBaseline(int n, int n2) {
        return super.getBaseline(n, n2) - 1;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> jList, E e, int n, boolean bl, boolean bl2) {
        this.fInList = n >= 0;
        this.fSelected = bl;
        if (n < 0) {
            n = this.fComboBox.getSelectedIndex();
        }
        if (n >= 0) {
            Object obj = this.fComboBox.getItemAt(n);
            this.fChecked = this.fInList && obj != null && obj.equals(this.fComboBox.getSelectedItem()) && !this.isPullDown(this.fComboBox);
        } else {
            this.fChecked = false;
        }
        this.fEditable = this.fComboBox.isEditable();
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        this.setFont(jList.getFont());
        if (e instanceof Icon) {
            this.setIcon((Icon)e);
        } else {
            this.setText(e == null ? " " : e.toString());
        }
        return this;
    }

    @Override
    public Insets getInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = 1;
        insets.bottom = 1;
        insets.right = 5;
        insets.left = this.fInList && !this.fEditable ? 23 : 5;
        return insets;
    }

    protected void setDrawCheckedItem(boolean bl) {
        this.fDrawCheckedItem = bl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.fInList) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.fChecked && !this.fEditable && this.fDrawCheckedItem) {
                int n = this.getHeight() - 4;
                graphics.setColor(this.getForeground());
                Icon icon = AquaImageFactory.getMenuItemCheckIcon();
                if (this.fSelected && icon instanceof AquaImageFactory.InvertableImageIcon) {
                    AquaImageFactory.InvertableImageIcon invertableImageIcon = (AquaImageFactory.InvertableImageIcon)icon;
                    icon = invertableImageIcon.getInvertedIcon();
                }
                icon.paintIcon(this.fComboBox, graphics, 6, 2);
            }
        }
        super.paintComponent(graphics);
    }

    protected boolean isPullDown(JComboBox jComboBox) {
        AquaComboBoxUI aquaComboBoxUI;
        if (!jComboBox.isEditable() && (aquaComboBoxUI = AquaUtils.getUI(jComboBox, AquaComboBoxUI.class)) != null) {
            PopupButtonLayoutConfiguration popupButtonLayoutConfiguration = (PopupButtonLayoutConfiguration)aquaComboBoxUI.getLayoutConfiguration();
            return popupButtonLayoutConfiguration != null && !popupButtonLayoutConfiguration.isPopUp();
        }
        return false;
    }
}

