/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaComboBoxButton;
import org.violetlib.aqua.AquaFullKeyboardFocusableHandler;
import org.violetlib.aqua.AquaMnemonicHandler;
import org.violetlib.aqua.AquaPushButtonBorder;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaSegmentedButtonBorder;
import org.violetlib.aqua.AquaSharedColorChooser;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.SharedColorChooserOwner;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public class AquaButtonUI
extends BasicButtonUI
implements AquaUtilControlSize.Sizeable,
FocusRingOutlineProvider {
    public static final String BUTTON_TYPE = "JButton.buttonType";
    public static final String SEGMENTED_BUTTON_POSITION = "JButton.segmentPosition";
    public static final String SELECTED_STATE_KEY = "JButton.selectedState";
    public static final float OUTLINE_OFFSET = 0.0f;
    public static final float OUTLINE_CORNER = 9.0f;
    public static final String LAYOUT_CONFIGURATION_PROPERTY = "Aqua.Button.LayoutConfiguration";
    public static final String DEFAULT_FONT_PROPERTY = "Aqua.Button.DefaultFont";
    protected static final String COLOR_CHOOSER_OWNER_PROPERTY = "Aqua.Button.ColorChooserOwner";
    protected static final AquaUtils.RecyclableSingleton<AquaButtonUI> buttonUI = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaButtonUI>(AquaButtonUI.class);
    private AquaButtonExtendedTypes.ColorDefaults colorDefaults;
    static final AquaUtils.RecyclableSingleton<AquaHierarchyButtonListener> fHierListener = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaHierarchyButtonListener>(AquaHierarchyButtonListener.class);

    public static ComponentUI createUI(JComponent jComponent) {
        return buttonUI.get();
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        String string = this.getPropertyPrefix();
        if (this.colorDefaults == null) {
            this.colorDefaults = new AquaButtonExtendedTypes.ColorDefaults();
            this.colorDefaults.enabledTextColor = UIManager.getColor(string + "foreground");
            this.colorDefaults.selectedTextColor = UIManager.getColor(string + "selectedText");
            this.colorDefaults.disabledTextColor = UIManager.getColor(string + "disabledText");
        }
        this.setButtonMarginIfNeeded(abstractButton, UIManager.getInsets(string + "margin"));
        LookAndFeel.installColorsAndFont(abstractButton, string + "background", string + "foreground", string + "font");
        LookAndFeel.installProperty(abstractButton, "opaque", UIManager.getBoolean(string + "opaque"));
        abstractButton.putClientProperty(DEFAULT_FONT_PROPERTY, abstractButton.getFont());
        this.configure(abstractButton);
    }

    public void configure(AbstractButton abstractButton) {
        Object object;
        AquaButtonExtendedTypes.TypeSpecifier typeSpecifier = AquaButtonExtendedTypes.getTypeSpecifier(abstractButton);
        this.installBorder(abstractButton, typeSpecifier);
        LayoutConfiguration layoutConfiguration = null;
        Border border = abstractButton.getBorder();
        if (border instanceof AquaButtonBorder) {
            object = (AquaButtonBorder)border;
            layoutConfiguration = ((AquaButtonBorder)object).getLayoutConfiguration(abstractButton);
            if (((AquaButtonBorder)object).isRolloverEnabled(abstractButton)) {
                LookAndFeel.installProperty(abstractButton, "rolloverEnabled", true);
            }
            int n = ((AquaButtonBorder)object).getIconTextGap(abstractButton);
            LookAndFeel.installProperty(abstractButton, "iconTextGap", n);
        }
        abstractButton.putClientProperty(LAYOUT_CONFIGURATION_PROPERTY, layoutConfiguration);
        object = AquaUtilControlSize.getUserSizeFrom(abstractButton);
        if (AquaUtilControlSize.isOKToInstallDefaultFont(abstractButton)) {
            Font font = this.getDefaultFont(abstractButton, (AquaUIPainter.Size)((Object)object));
            font = this.getCustomDefaultFont(abstractButton, (AquaUIPainter.Size)((Object)object), font);
            AquaUtilControlSize.installDefaultFont(abstractButton, font);
        }
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.revalidate();
        abstractButton.repaint();
    }

    protected void installBorder(AbstractButton abstractButton, AquaButtonExtendedTypes.TypeSpecifier typeSpecifier) {
        Border border;
        Border border2 = border = typeSpecifier != null ? typeSpecifier.getBorder() : null;
        if (border != null) {
            abstractButton.setBorder(border);
        } else {
            Border border3 = abstractButton.getBorder();
            if (border3 == null || border3 instanceof UIResource) {
                Border border4 = this.getDefaultBorder(abstractButton);
                if (border4 == null) {
                    border4 = new AquaPushButtonBorder();
                }
                abstractButton.setBorder(border4);
            }
        }
    }

    protected Border getDefaultBorder(AbstractButton abstractButton) {
        if (AquaButtonUI.isOnToolbar(abstractButton)) {
            if (abstractButton instanceof JToggleButton) {
                return AquaButtonBorder.getToolBarToggleButtonBorder();
            }
            return AquaButtonBorder.getToolBarPushButtonBorder();
        }
        if (abstractButton instanceof JToggleButton) {
            return AquaButtonBorder.getToggleButtonBorder();
        }
        return AquaButtonBorder.getPushButtonBorder();
    }

    @Override
    public Shape getFocusRingOutline(JComponent jComponent) {
        Border border = jComponent.getBorder();
        if (border instanceof FocusRingOutlineProvider) {
            FocusRingOutlineProvider focusRingOutlineProvider = (FocusRingOutlineProvider)((Object)border);
            return focusRingOutlineProvider.getFocusRingOutline(jComponent);
        }
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        return new RoundRectangle2D.Double(0.0, 0.0, (float)n - 0.0f, (float)n2 - 0.0f, 9.0, 9.0);
    }

    @Override
    public void applySizeFor(JComponent jComponent, AquaUIPainter.Size size, boolean bl) {
        this.configure((AbstractButton)jComponent);
    }

    public static Font getGenericDefaultFont(AbstractButton abstractButton) {
        Font font = (Font)abstractButton.getClientProperty(DEFAULT_FONT_PROPERTY);
        if (font != null) {
            return font;
        }
        return abstractButton.getFont();
    }

    protected Font getDefaultFont(AbstractButton abstractButton, AquaUIPainter.Size size) {
        if (AquaButtonUI.shouldUseIconFont(abstractButton)) {
            return size == AquaUIPainter.Size.SMALL || size == AquaUIPainter.Size.MINI ? UIManager.getFont("IconButton.smallFont") : UIManager.getFont("IconButton.font");
        }
        return abstractButton.getFont();
    }

    protected static boolean shouldUseIconFont(AbstractButton abstractButton) {
        return abstractButton.getIcon() != null || abstractButton.getComponentCount() > 0 || AquaButtonUI.isOnToolbar(abstractButton);
    }

    protected Font getCustomDefaultFont(AbstractButton abstractButton, AquaUIPainter.Size size, Font font) {
        Border border = abstractButton.getBorder();
        if (border instanceof AquaButtonBorder) {
            AquaButtonBorder aquaButtonBorder = (AquaButtonBorder)border;
            return aquaButtonBorder.getCustomDefaultFont(abstractButton, size, font);
        }
        return AquaUtilControlSize.getFontForSize(font, size);
    }

    protected Color getForegroundColor(AbstractButton abstractButton) {
        Color color = abstractButton.getForeground();
        if (color == null || color instanceof UIResource) {
            Border border = abstractButton.getBorder();
            if (border instanceof AquaButtonBorder) {
                AquaButtonBorder aquaButtonBorder = (AquaButtonBorder)border;
                return aquaButtonBorder.getTextColor(abstractButton, this.colorDefaults);
            }
            boolean bl = abstractButton.getModel().isEnabled();
            boolean bl2 = abstractButton.isSelected();
            return this.colorDefaults.getTextColor(bl, bl2);
        }
        return color;
    }

    public static boolean isOnToolbar(AbstractButton abstractButton) {
        for (Container container = abstractButton.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JToolBar)) continue;
            return true;
        }
        return false;
    }

    protected void setButtonMarginIfNeeded(AbstractButton abstractButton, Insets insets) {
        Insets insets2 = abstractButton.getMargin();
        if (insets2 == null || insets2 instanceof UIResource) {
            abstractButton.setMargin(insets);
        }
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        AquaButtonListener aquaButtonListener = this.createButtonListener(abstractButton);
        if (aquaButtonListener != null) {
            abstractButton.putClientProperty(this, aquaButtonListener);
            abstractButton.addMouseListener(aquaButtonListener);
            abstractButton.addMouseMotionListener(aquaButtonListener);
            abstractButton.addFocusListener(aquaButtonListener);
            abstractButton.addPropertyChangeListener(aquaButtonListener);
            abstractButton.addChangeListener(aquaButtonListener);
            abstractButton.addAncestorListener(aquaButtonListener);
            abstractButton.addActionListener(aquaButtonListener);
        }
        this.installHierListener(abstractButton);
        AquaUtilControlSize.addSizePropertyListener(abstractButton);
        AquaFullKeyboardFocusableHandler.addListener(abstractButton);
    }

    @Override
    protected void installKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.installKeyboardActions(abstractButton);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions((AbstractButton)jComponent);
        this.uninstallListeners((AbstractButton)jComponent);
        this.uninstallDefaults((AbstractButton)jComponent);
    }

    @Override
    protected void uninstallKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.uninstallKeyboardActions(abstractButton);
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        AquaButtonListener aquaButtonListener = (AquaButtonListener)abstractButton.getClientProperty(this);
        abstractButton.putClientProperty(this, null);
        if (aquaButtonListener != null) {
            abstractButton.removeMouseListener(aquaButtonListener);
            abstractButton.removeMouseMotionListener(aquaButtonListener);
            abstractButton.removeFocusListener(aquaButtonListener);
            abstractButton.removeChangeListener(aquaButtonListener);
            abstractButton.removePropertyChangeListener(aquaButtonListener);
            abstractButton.removeAncestorListener(aquaButtonListener);
            abstractButton.removeActionListener(aquaButtonListener);
        }
        this.uninstallHierListener(abstractButton);
        AquaUtilControlSize.removeSizePropertyListener(abstractButton);
        AquaFullKeyboardFocusableHandler.removeListener(abstractButton);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        LookAndFeel.uninstallBorder(abstractButton);
        AquaUtilControlSize.uninstallDefaultFont(abstractButton);
    }

    @Override
    protected AquaButtonListener createButtonListener(AbstractButton abstractButton) {
        return new AquaButtonListener(abstractButton);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Insets insets = jComponent.getInsets();
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        Rectangle rectangle = new Rectangle(n, n2);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        if (abstractButton.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        AquaButtonBorder aquaButtonBorder = null;
        if (((AbstractButton)jComponent).isBorderPainted()) {
            object = jComponent.getBorder();
            if (object instanceof AquaButtonBorder) {
                aquaButtonBorder = (AquaButtonBorder)object;
                aquaButtonBorder.paintBackground(jComponent, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else if (abstractButton.isOpaque()) {
            rectangle.x = insets.left - 2;
            rectangle.y = insets.top - 2;
            rectangle.width = n - (insets.right + rectangle.x) + 4;
            rectangle.height = n2 - (insets.bottom + rectangle.y) + 4;
            if (abstractButton.isContentAreaFilled() || buttonModel.isSelected()) {
                if (buttonModel.isSelected()) {
                    graphics.setColor(jComponent.getBackground().darker());
                } else {
                    graphics.setColor(jComponent.getBackground());
                }
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (aquaButtonBorder != null && !aquaButtonBorder.allowsContent()) {
            return;
        }
        object = null;
        if (aquaButtonBorder != null) {
            object = aquaButtonBorder.getSizingIcon(abstractButton);
        }
        String string = this.layoutAndGetText(graphics, abstractButton, aquaButtonBorder, insets, rectangle, rectangle2, rectangle3, (Icon)object);
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, abstractButton, rectangle2);
        }
        if (rectangle3.width == 0) {
            rectangle3.width = 50;
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle3);
            } else {
                this.paintText(graphics, abstractButton, rectangle3, string);
            }
        }
    }

    protected String layoutAndGetText(Graphics graphics, AbstractButton abstractButton, AquaButtonBorder aquaButtonBorder, Insets insets, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Icon icon) {
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = abstractButton.getWidth() - (insets.right + rectangle.x);
        rectangle.height = abstractButton.getHeight() - (insets.bottom + rectangle.y);
        rectangle3.height = 0;
        rectangle3.width = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        rectangle2.height = 0;
        rectangle2.width = 0;
        rectangle2.y = 0;
        rectangle2.x = 0;
        graphics.setFont(abstractButton.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = abstractButton.getText();
        Icon icon2 = icon != null ? icon : abstractButton.getIcon();
        String string2 = AquaUtils.layoutCompoundLabel(abstractButton, fontMetrics, string, icon2, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, string == null ? 0 : abstractButton.getIconTextGap());
        if (string2 == string || aquaButtonBorder == null) {
            return string2;
        }
        Insets insets2 = aquaButtonBorder.getContentInsets(abstractButton, abstractButton.getWidth(), abstractButton.getHeight());
        if (insets2 != null) {
            return this.layoutAndGetText(graphics, abstractButton, null, insets2, rectangle, rectangle2, rectangle3, icon);
        }
        return string2;
    }

    protected void paintIcon(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        Icon icon = abstractButton.getIcon();
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon2 = null;
        if (!buttonModel.isEnabled()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = abstractButton.getPressedIcon();
            if (icon2 == null) {
                icon = this.getDarkenedIcon(icon);
            }
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon();
        } else if (buttonModel.isSelected()) {
            icon2 = abstractButton.getSelectedIcon();
        }
        Graphics2D graphics2D = null;
        if (icon2 != null) {
            icon = icon2;
        } else if (icon.getIconWidth() != rectangle.width || icon.getIconHeight() != rectangle.height) {
            graphics2D = (Graphics2D)graphics.create();
            graphics = graphics2D;
            graphics2D.translate(rectangle.x, rectangle.y);
            graphics2D.scale(rectangle.getWidth() / (double)icon.getIconWidth(), rectangle.getHeight() / (double)icon.getIconHeight());
            graphics2D.translate(-rectangle.x, -rectangle.y);
        }
        icon.paintIcon(abstractButton, graphics, rectangle.x, rectangle.y);
        if (graphics2D != null) {
            graphics2D.dispose();
        }
    }

    protected Icon getDarkenedIcon(Icon icon) {
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.setColor(new Color(0, 0, 0, 128));
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.fillRect(0, 0, n, n2);
        return new ImageIcon(bufferedImage);
    }

    @Override
    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        this.paintText(graphics, (JComponent)abstractButton, rectangle, string);
    }

    @Override
    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        Graphics2D graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = AquaMnemonicHandler.isMnemonicHidden() ? -1 : abstractButton.getDisplayedMnemonicIndex();
        Color color = this.getForegroundColor(abstractButton);
        graphics.setColor(color);
        AquaUtils.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.paint(graphics, abstractButton);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension;
        Object object;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Border border = abstractButton.getBorder();
        if (border instanceof AquaButtonBorder) {
            object = (AquaButtonBorder)border;
            dimension = ((AquaButtonBorder)object).getMinimumButtonSize(abstractButton);
        } else {
            dimension = this.getPreferredSize(abstractButton);
        }
        object = (View)jComponent.getClientProperty("html");
        if (object != null) {
            dimension.width = (int)((float)dimension.width - (((View)object).getPreferredSpan(0) - ((View)object).getMinimumSpan(0)));
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Border border = abstractButton.getBorder();
        if (border instanceof AquaButtonBorder) {
            AquaButtonBorder aquaButtonBorder = (AquaButtonBorder)border;
            return aquaButtonBorder.getPreferredButtonSize(abstractButton);
        }
        return AquaButtonUI.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap(), null);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    static AquaHierarchyButtonListener getAquaHierarchyButtonListener() {
        return fHierListener.get();
    }

    private boolean shouldInstallHierListener(AbstractButton abstractButton) {
        return abstractButton instanceof JButton || abstractButton instanceof JToggleButton && !(abstractButton instanceof AquaComboBoxButton) && !(abstractButton instanceof JCheckBox) && !(abstractButton instanceof JRadioButton);
    }

    protected void installHierListener(AbstractButton abstractButton) {
        if (this.shouldInstallHierListener(abstractButton)) {
            abstractButton.addHierarchyListener(AquaButtonUI.getAquaHierarchyButtonListener());
        }
    }

    protected void uninstallHierListener(AbstractButton abstractButton) {
        if (this.shouldInstallHierListener(abstractButton)) {
            abstractButton.removeHierarchyListener(AquaButtonUI.getAquaHierarchyButtonListener());
        }
    }

    protected Object willHandleButtonPress(AbstractButton abstractButton) {
        return null;
    }

    protected void didHandleButtonPress(AbstractButton abstractButton, Object object) {
    }

    protected void toggleColorChooser(final AbstractButton abstractButton) {
        Object object = abstractButton.getClientProperty(COLOR_CHOOSER_OWNER_PROPERTY);
        if (object instanceof SharedColorChooserOwner) {
            SharedColorChooserOwner sharedColorChooserOwner = (SharedColorChooserOwner)object;
            AquaSharedColorChooser.disconnect(sharedColorChooserOwner);
            abstractButton.setSelected(false);
            abstractButton.putClientProperty(COLOR_CHOOSER_OWNER_PROPERTY, null);
            return;
        }
        SharedColorChooserOwner sharedColorChooserOwner = new SharedColorChooserOwner(){

            @Override
            public void applyColor(Color color) {
                abstractButton.setBackground(color);
            }

            @Override
            public void disconnected() {
                abstractButton.setSelected(false);
                abstractButton.putClientProperty(AquaButtonUI.COLOR_CHOOSER_OWNER_PROPERTY, null);
            }
        };
        if (AquaSharedColorChooser.connect(sharedColorChooserOwner)) {
            abstractButton.putClientProperty(COLOR_CHOOSER_OWNER_PROPERTY, sharedColorChooserOwner);
            abstractButton.setSelected(true);
        }
    }

    public static Dimension getPreferredButtonSize(AbstractButton abstractButton, int n, Icon icon) {
        if (abstractButton.getComponentCount() > 0) {
            return null;
        }
        Icon icon2 = icon != null ? icon : abstractButton.getIcon();
        String string = abstractButton.getText();
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, icon2, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        return rectangle4.getSize();
    }

    public static Dimension getPreferredContentSize(AbstractButton abstractButton, Font font, int n) {
        Icon icon = abstractButton.getIcon();
        String string = abstractButton.getText();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        return rectangle4.getSize();
    }

    class AquaButtonListener
    extends BasicButtonListener
    implements ActionListener,
    AncestorListener {
        protected final AbstractButton b;

        public AquaButtonListener(AbstractButton abstractButton) {
            super(abstractButton);
            this.b = abstractButton;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionListener[] actionListenerArray;
            ButtonLayoutConfiguration buttonLayoutConfiguration;
            Object object = this.b.getClientProperty(AquaButtonUI.LAYOUT_CONFIGURATION_PROPERTY);
            if (object instanceof ButtonLayoutConfiguration && (buttonLayoutConfiguration = (ButtonLayoutConfiguration)object).getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL && (actionListenerArray = this.b.getActionListeners()).length == 1) {
                AquaButtonUI.this.toggleColorChooser(this.b);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ((Component)focusEvent.getSource()).repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ((Component)focusEvent.getSource()).repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Border border;
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if ("Frame.active".equals(string)) {
                this.b.repaint();
                return;
            }
            if ("icon".equals(string) || "text".equals(string)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if (AquaButtonUI.BUTTON_TYPE.equals(string)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if (AquaButtonUI.SEGMENTED_BUTTON_POSITION.equals(string)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if ("verticalAlignment".equals(string)) {
                AquaButtonUI.this.configure(this.b);
                return;
            }
            if ("componentOrientation".equals(string) && (border = this.b.getBorder()) instanceof AquaSegmentedButtonBorder) {
                AquaButtonUI.this.configure(this.b);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            this.updateDefaultButton();
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            this.updateDefaultButton();
        }

        protected void updateDefaultButton() {
            if (!(this.b instanceof JButton)) {
                return;
            }
            if (!((JButton)this.b).isDefaultButton()) {
                return;
            }
            JRootPane jRootPane = this.b.getRootPane();
            if (jRootPane == null) {
                return;
            }
            RootPaneUI rootPaneUI = jRootPane.getUI();
            if (!(rootPaneUI instanceof AquaRootPaneUI)) {
                return;
            }
            ((AquaRootPaneUI)rootPaneUI).updateDefaultButton(jRootPane);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && (abstractButton = (AbstractButton)mouseEvent.getSource()).contains(mouseEvent.getX(), mouseEvent.getY())) {
                Object object = AquaButtonUI.this.willHandleButtonPress(abstractButton);
                super.mousePressed(mouseEvent);
                AquaButtonUI.this.didHandleButtonPress(abstractButton, object);
            }
        }
    }

    static class AquaHierarchyButtonListener
    implements HierarchyListener {
        AquaHierarchyButtonListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 1L) == 0L) {
                return;
            }
            Object object = hierarchyEvent.getSource();
            if (!(object instanceof AbstractButton)) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)object;
            ButtonUI buttonUI = abstractButton.getUI();
            if (!(buttonUI instanceof AquaButtonUI)) {
                return;
            }
            ((AquaButtonUI)buttonUI).configure(abstractButton);
        }
    }
}

