/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.NullPainter;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.SliderPainter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.ListBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SliderThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellConfiguration;
import org.violetlib.jnr.aqua.impl.AquaNativePainter;
import org.violetlib.jnr.aqua.impl.AquaRenderedPainter;
import org.violetlib.jnr.aqua.impl.AquaUIPainterAbstractBase;
import org.violetlib.jnr.aqua.impl.PopupArrowConfiguration;
import org.violetlib.jnr.aqua.impl.RendererDescriptions;
import org.violetlib.jnr.aqua.impl.SearchFieldCancelButtonConfiguration;
import org.violetlib.jnr.aqua.impl.SearchFieldFindButtonConfiguration;
import org.violetlib.jnr.aqua.impl.SliderThumbConfiguration;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.OffsetPainter;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDebugInfo;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.vappearances.VAppearance;

public abstract class AquaUIPainterBase
extends AquaUIPainterAbstractBase
implements AquaUIPainter {
    public static final Renderer NULL_RENDERER = Renderer.createCompositeRenderer(new Renderer[0]);
    @NotNull
    protected final RendererDescriptions rendererDescriptions;
    public static final int SEGMENTED_10_10 = 0;
    public static final int SEGMENTED_10_11 = 1;
    public static final int SEGMENTED_10_13_OLD = 2;
    public static final int SEGMENTED_10_13 = 3;
    public static final int SEGMENTED_10_14_OLD = 4;
    public static final int SEGMENTED_10_14 = 5;
    private static int cachedSegmentedButtonRenderingVersion = -2;
    private static final Map<String, Integer> appearanceIDMap = new HashMap<String, Integer>();

    protected AquaUIPainterBase(@NotNull RendererDescriptions rendererDescriptions) {
        this.rendererDescriptions = rendererDescriptions;
    }

    public static int internalGetSegmentedButtonRenderingVersion() {
        if (cachedSegmentedButtonRenderingVersion >= -1) {
            return cachedSegmentedButtonRenderingVersion;
        }
        cachedSegmentedButtonRenderingVersion = AquaNativePainter.nativeDetermineSegmentedButtonRenderingVersion();
        return cachedSegmentedButtonRenderingVersion;
    }

    public int getSegmentedButtonRenderingVersion() {
        return AquaUIPainterBase.internalGetSegmentedButtonRenderingVersion();
    }

    @Override
    @Nullable
    public Shape getOutline(@NotNull LayoutConfiguration layoutConfiguration) throws UnsupportedOperationException {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(layoutConfiguration);
        Rectangle2D rectangle2D = this.getCenteredBounds(layoutInfo);
        return this.getOutline(rectangle2D, layoutConfiguration);
    }

    @Nullable
    public Shape getOutline(@NotNull Rectangle2D rectangle2D, @NotNull LayoutConfiguration layoutConfiguration) throws UnsupportedOperationException {
        return uiOutliner.getOutline(rectangle2D, layoutConfiguration);
    }

    @Override
    @NotNull
    public Painter getPainter(@NotNull Configuration configuration) throws UnsupportedOperationException {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo((LayoutConfiguration)((Object)configuration));
        Renderer renderer = this.getRenderer(configuration);
        Painter painter = this.getPainter(layoutInfo, configuration, renderer);
        return this.customizePainter(painter, configuration, layoutInfo);
    }

    @NotNull
    protected Painter customizePainter(@NotNull Painter painter, @NotNull Configuration configuration, @NotNull LayoutInfo layoutInfo) {
        if (configuration instanceof SliderConfiguration) {
            SliderConfiguration sliderConfiguration = (SliderConfiguration)configuration;
            Rectangle2D rectangle2D = this.getCenteredBounds(layoutInfo);
            return new SliderPainterImpl(sliderConfiguration, layoutInfo, rectangle2D, sliderConfiguration.getValue(), painter);
        }
        return painter;
    }

    @NotNull
    public Renderer getRenderer(@NotNull Configuration configuration) {
        LayoutConfiguration layoutConfiguration;
        Renderer renderer;
        if (configuration instanceof ButtonConfiguration) {
            ButtonConfiguration buttonConfiguration = (ButtonConfiguration)configuration;
            return this.getButtonRenderer(buttonConfiguration);
        }
        if (configuration instanceof ComboBoxConfiguration) {
            ComboBoxConfiguration comboBoxConfiguration = (ComboBoxConfiguration)configuration;
            return this.getComboBoxButtonRenderer(comboBoxConfiguration);
        }
        if (configuration instanceof PopupButtonConfiguration) {
            PopupButtonConfiguration popupButtonConfiguration = (PopupButtonConfiguration)configuration;
            return this.getPopupButtonRenderer(popupButtonConfiguration);
        }
        if (configuration instanceof TitleBarConfiguration) {
            TitleBarConfiguration titleBarConfiguration = (TitleBarConfiguration)configuration;
            return this.getTitleBarRenderer(titleBarConfiguration);
        }
        if (configuration instanceof SliderConfiguration) {
            SliderConfiguration sliderConfiguration = (SliderConfiguration)configuration;
            return this.getSliderRenderer(sliderConfiguration);
        }
        if (configuration instanceof SpinnerArrowsConfiguration) {
            SpinnerArrowsConfiguration spinnerArrowsConfiguration = (SpinnerArrowsConfiguration)configuration;
            return this.getSpinnerArrowsRenderer(spinnerArrowsConfiguration);
        }
        if (configuration instanceof SplitPaneDividerConfiguration) {
            SplitPaneDividerConfiguration splitPaneDividerConfiguration = (SplitPaneDividerConfiguration)configuration;
            return this.getSplitPaneDividerRenderer(splitPaneDividerConfiguration);
        }
        if (configuration instanceof SegmentedButtonConfiguration) {
            SegmentedButtonConfiguration segmentedButtonConfiguration = (SegmentedButtonConfiguration)configuration;
            return this.getSegmentedButtonRenderer(segmentedButtonConfiguration);
        }
        if (configuration instanceof ToolBarItemWellConfiguration) {
            ToolBarItemWellConfiguration toolBarItemWellConfiguration = (ToolBarItemWellConfiguration)configuration;
            return this.getToolBarItemWellRenderer(toolBarItemWellConfiguration);
        }
        if (configuration instanceof GroupBoxConfiguration) {
            GroupBoxConfiguration groupBoxConfiguration = (GroupBoxConfiguration)configuration;
            return this.getGroupBoxRenderer(groupBoxConfiguration);
        }
        if (configuration instanceof ListBoxConfiguration) {
            ListBoxConfiguration listBoxConfiguration = (ListBoxConfiguration)configuration;
            return this.getListBoxRenderer(listBoxConfiguration);
        }
        if (configuration instanceof TextFieldConfiguration) {
            TextFieldConfiguration textFieldConfiguration = (TextFieldConfiguration)configuration;
            return this.getTextFieldRenderer(textFieldConfiguration);
        }
        if (configuration instanceof ScrollBarConfiguration) {
            ScrollBarConfiguration scrollBarConfiguration = (ScrollBarConfiguration)configuration;
            return this.getScrollBarRenderer(scrollBarConfiguration);
        }
        if (configuration instanceof ScrollColumnSizerConfiguration) {
            ScrollColumnSizerConfiguration scrollColumnSizerConfiguration = (ScrollColumnSizerConfiguration)configuration;
            return this.getScrollColumnSizerRenderer(scrollColumnSizerConfiguration);
        }
        if (configuration instanceof IndeterminateProgressIndicatorConfiguration) {
            IndeterminateProgressIndicatorConfiguration indeterminateProgressIndicatorConfiguration = (IndeterminateProgressIndicatorConfiguration)configuration;
            return this.getIndeterminateProgressIndicatorRenderer(indeterminateProgressIndicatorConfiguration);
        }
        if (configuration instanceof ProgressIndicatorConfiguration) {
            ProgressIndicatorConfiguration progressIndicatorConfiguration = (ProgressIndicatorConfiguration)configuration;
            return this.getProgressIndicatorRenderer(progressIndicatorConfiguration);
        }
        if (configuration instanceof TableColumnHeaderConfiguration) {
            TableColumnHeaderConfiguration tableColumnHeaderConfiguration = (TableColumnHeaderConfiguration)configuration;
            return this.getTableColumnHeaderRenderer(tableColumnHeaderConfiguration);
        }
        if (configuration instanceof GradientConfiguration) {
            GradientConfiguration gradientConfiguration = (GradientConfiguration)configuration;
            return this.getGradientRenderer(gradientConfiguration);
        }
        if (configuration instanceof SliderThumbConfiguration) {
            SliderThumbConfiguration sliderThumbConfiguration = (SliderThumbConfiguration)configuration;
            return this.getSliderThumbRenderer(sliderThumbConfiguration.getSliderConfiguration());
        }
        if (configuration instanceof PopupArrowConfiguration && (renderer = this.getPopupArrowRenderer(((PopupArrowConfiguration)(layoutConfiguration = (PopupArrowConfiguration)configuration)).getPopupButtonConfiguration())) != null) {
            return renderer;
        }
        if (configuration instanceof SearchFieldFindButtonConfiguration && (renderer = this.getSearchFieldFindButtonRenderer(((SearchFieldFindButtonConfiguration)(layoutConfiguration = (SearchFieldFindButtonConfiguration)configuration)).getTextFieldConfiguration())) != null) {
            return renderer;
        }
        if (configuration instanceof SearchFieldCancelButtonConfiguration && (renderer = this.getSearchFieldCancelButtonRenderer(((SearchFieldCancelButtonConfiguration)(layoutConfiguration = (SearchFieldCancelButtonConfiguration)configuration)).getTextFieldConfiguration())) != null) {
            return renderer;
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    public RendererDebugInfo getRendererDebugInfo(@NotNull Configuration configuration, int n, int n2, int n3) {
        if (configuration instanceof SegmentedButtonConfiguration) {
            SegmentedButtonConfiguration segmentedButtonConfiguration = (SegmentedButtonConfiguration)configuration;
            return this.getSegmentedButtonRendererDebugInfo(segmentedButtonConfiguration, n, n2, n3);
        }
        return null;
    }

    @NotNull
    protected AquaUIPainter.ButtonWidget toCanonicalButtonStyle(AquaUIPainter.ButtonWidget buttonWidget) {
        return buttonWidget;
    }

    @Nullable
    protected Renderer getSearchFieldFindButtonRenderer(@NotNull TextFieldConfiguration textFieldConfiguration) {
        return null;
    }

    @Nullable
    protected Renderer getSearchFieldCancelButtonRenderer(@NotNull TextFieldConfiguration textFieldConfiguration) {
        return null;
    }

    @Nullable
    protected RendererDescription getSearchButtonRendererDescription(@NotNull TextFieldLayoutConfiguration textFieldLayoutConfiguration) {
        AquaUIPainter.TextFieldWidget textFieldWidget = textFieldLayoutConfiguration.getWidget();
        if (!textFieldWidget.isSearch()) {
            return null;
        }
        AquaUIPainter.Size size = textFieldLayoutConfiguration.getSize();
        boolean bl = textFieldWidget.hasMenu();
        if (bl) {
            float f = JNRUtils.size2D(size, -5.0f, -6.0f, -4.0f);
            float f2 = JNRUtils.size(size, -1, -1, -2);
            float f3 = JNRUtils.size2D(size, -5.5f, -6.0f, -4.5f);
            float f4 = JNRUtils.size2D(size, -1.5f, -1.5f, -2.0f);
            float f5 = JNRUtils.size(size, 6, 7, 4);
            float f6 = JNRUtils.size(size, 1, 1, 2);
            if (!textFieldLayoutConfiguration.isLeftToRight()) {
                f += 4.0f;
                f3 += 4.0f;
            }
            BasicRendererDescription basicRendererDescription = new BasicRendererDescription(f, f2, f5, f6);
            BasicRendererDescription basicRendererDescription2 = new BasicRendererDescription(f3, f4, f5, f6);
            return new MultiResolutionRendererDescription(basicRendererDescription, basicRendererDescription2);
        }
        float f = 0.0f;
        float f7 = JNRUtils.size(size, -1, -1, -2);
        float f8 = 0.0f;
        float f9 = JNRUtils.size(size, 1, 1, 1);
        float f10 = -0.5f;
        float f11 = JNRUtils.size2D(size, -1.5f, -2.0f, -2.0f);
        float f12 = 0.0f;
        float f13 = JNRUtils.size2D(size, 1.0f, 1.5f, 1.5f);
        BasicRendererDescription basicRendererDescription = new BasicRendererDescription(f, f7, f8, f9);
        BasicRendererDescription basicRendererDescription3 = new BasicRendererDescription(f10, f11, f12, f13);
        return new MultiResolutionRendererDescription(basicRendererDescription, basicRendererDescription3);
    }

    @NotNull
    protected Painter getPainter(@Nullable LayoutInfo layoutInfo, @NotNull Configuration configuration, @NotNull Renderer renderer) {
        this.configureLayout(layoutInfo);
        if (this.pWidth <= 0.0f || this.pHeight <= 0.0f) {
            return new NullPainter(layoutInfo);
        }
        if (this.appearance == null) {
            throw new IllegalStateException("Appearance must be configured");
        }
        Painter painter = this.getPainter(configuration, this.appearance, renderer, this.pWidth, this.pHeight);
        if (this.xOffset != 0.0f || this.yOffset != 0.0f) {
            painter = new OffsetPainter(painter, this.xOffset, this.yOffset);
        }
        return painter;
    }

    @NotNull
    protected Painter getPainter(@NotNull Configuration configuration, @NotNull VAppearance vAppearance, @NotNull Renderer renderer, float f, float f2) {
        return new AquaRenderedPainter(configuration, vAppearance, renderer, f, f2);
    }

    @NotNull
    protected abstract Renderer getButtonRenderer(@NotNull ButtonConfiguration var1);

    @NotNull
    protected abstract Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration var1);

    @NotNull
    protected abstract Renderer getScrollColumnSizerRenderer(@NotNull ScrollColumnSizerConfiguration var1);

    @NotNull
    protected abstract Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration var1);

    @NotNull
    protected abstract Renderer getToolBarItemWellRenderer(@NotNull ToolBarItemWellConfiguration var1);

    @NotNull
    protected abstract Renderer getGroupBoxRenderer(@NotNull GroupBoxConfiguration var1);

    @NotNull
    protected abstract Renderer getListBoxRenderer(@NotNull ListBoxConfiguration var1);

    @NotNull
    protected abstract Renderer getTextFieldRenderer(@NotNull TextFieldConfiguration var1);

    @NotNull
    protected abstract Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration var1);

    @NotNull
    protected abstract Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration var1);

    @NotNull
    protected abstract Renderer getPopupButtonRenderer(@NotNull PopupButtonConfiguration var1);

    @NotNull
    protected abstract Renderer getTitleBarRenderer(@NotNull TitleBarConfiguration var1);

    @NotNull
    protected abstract Renderer getIndeterminateProgressIndicatorRenderer(@NotNull IndeterminateProgressIndicatorConfiguration var1);

    @NotNull
    protected abstract Renderer getProgressIndicatorRenderer(@NotNull ProgressIndicatorConfiguration var1);

    @NotNull
    protected abstract Renderer getSliderRenderer(@NotNull SliderConfiguration var1);

    @NotNull
    protected abstract Renderer getSliderThumbRenderer(@NotNull SliderConfiguration var1);

    @NotNull
    protected abstract Renderer getSpinnerArrowsRenderer(@NotNull SpinnerArrowsConfiguration var1);

    @NotNull
    protected abstract Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration var1);

    @NotNull
    protected abstract Renderer getGradientRenderer(@NotNull GradientConfiguration var1);

    protected boolean shouldPaintRecessedBackground(@NotNull AquaUIPainter.State state, @NotNull AquaUIPainter.ButtonState buttonState) {
        if (state == AquaUIPainter.State.PRESSED || state == AquaUIPainter.State.ROLLOVER) {
            return true;
        }
        return buttonState == AquaUIPainter.ButtonState.ON;
    }

    protected AquaUIPainter.State adjustRecessedState(AquaUIPainter.State state) {
        if (state == AquaUIPainter.State.ACTIVE_DEFAULT || state == AquaUIPainter.State.INACTIVE || state == AquaUIPainter.State.DISABLED || state == AquaUIPainter.State.DISABLED_INACTIVE) {
            return AquaUIPainter.State.ACTIVE;
        }
        return state;
    }

    @Nullable
    protected RendererDebugInfo getSegmentedButtonRendererDebugInfo(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, int n, int n2, int n3) {
        return null;
    }

    @Nullable
    protected Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        return null;
    }

    protected static void configureNativeAppearance(@NotNull VAppearance vAppearance) {
        int n;
        String string = vAppearance.getName();
        Integer n2 = appearanceIDMap.get(string);
        if (n2 == null) {
            n = AquaUIPainterBase.nativeRegisterAppearance(string);
            appearanceIDMap.put(string, n);
        } else {
            n = n2;
        }
        AquaUIPainterBase.nativeSetAppearance(n);
    }

    private static native int nativeRegisterAppearance(String var0);

    private static native void nativeSetAppearance(int var0);

    private class SliderPainterImpl
    implements SliderPainter {
        @NotNull
        private final SliderConfiguration sg;
        @Nullable
        private final LayoutInfo layoutInfo;
        @NotNull
        private final Rectangle2D bounds;
        @NotNull
        private final Painter p;
        private final double thumbPosition;
        @Nullable
        private Rectangle2D thumbBounds;
        @Nullable
        private Shape thumbOutline;

        public SliderPainterImpl(@Nullable SliderConfiguration sliderConfiguration, @NotNull LayoutInfo layoutInfo, Rectangle2D rectangle2D, @NotNull double d, Painter painter) {
            this.sg = sliderConfiguration;
            this.layoutInfo = layoutInfo;
            this.bounds = rectangle2D;
            this.thumbPosition = d;
            this.p = painter;
        }

        @Override
        @NotNull
        public Rectangle2D getThumbBounds() {
            if (this.thumbBounds == null) {
                this.thumbBounds = AquaUIPainterAbstractBase.uiLayout.getSliderThumbBounds(this.bounds, this.sg, this.thumbPosition);
            }
            return this.thumbBounds;
        }

        @Override
        @NotNull
        public Shape getThumbOutline() {
            if (this.thumbOutline == null) {
                SliderThumbLayoutConfiguration sliderThumbLayoutConfiguration = new SliderThumbLayoutConfiguration(this.sg, this.thumbPosition);
                this.thumbOutline = AquaUIPainterBase.this.getOutline(this.bounds, sliderThumbLayoutConfiguration);
            }
            return this.thumbOutline;
        }

        @Override
        public double getThumbPosition(int n, int n2) {
            return AquaUIPainterAbstractBase.uiLayout.getSliderThumbPosition(this.bounds, this.sg, n, n2);
        }

        @Override
        @NotNull
        public Rectangle2D getLabelBounds(double d, @NotNull Dimension dimension) {
            return AquaUIPainterAbstractBase.uiLayout.getSliderLabelBounds(this.bounds, this.sg, d, dimension);
        }

        @Override
        public float getFixedWidth() {
            return this.layoutInfo != null ? this.layoutInfo.getFixedVisualWidth() : 0.0f;
        }

        @Override
        public float getFixedHeight() {
            return this.layoutInfo != null ? this.layoutInfo.getFixedVisualHeight() : 0.0f;
        }

        @Override
        public void paint(@NotNull Graphics graphics, float f, float f2) {
            this.p.paint(graphics, f, f2);
        }
    }
}

