/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class LegacyScrollBarPainterExtension
implements PainterExtension {
    @NotNull
    private final AquaUILayoutInfo uiLayout;
    @NotNull
    private final ScrollBarConfiguration g;
    private final boolean showThumb;
    private final boolean isLight;
    private final boolean isHighContrast;
    private final boolean isRollover;
    private final Color LIGHT_THUMB = new Color(255, 255, 255, 80);
    private final Color LIGHT_THUMB_BORDER = new Color(0, 0, 0, 26);
    private final Color LIGHT_TRACK = new Color(68, 68, 68, 217);
    private final Color LIGHT_TRACK_BORDER = new Color(63, 63, 63, 217);
    private final Color LIGHT_ROLLOVER_THUMB = new Color(169, 169, 169, 235);
    private final Color LIGHT_ROLLOVER_THUMB_BORDER = this.LIGHT_THUMB_BORDER;
    private final Color LIGHT_TRACK_BORDER_HIGH_CONTRAST = this.LIGHT_TRACK_BORDER;
    private final Color DARK_THUMB = new Color(0, 0, 0, 56);
    private final Color DARK_TRACK = new Color(250, 250, 250);
    private final Color DARK_TRACK_BORDER = new Color(237, 237, 237);
    private final Color DARK_ROLLOVER_THUMB = new Color(0, 0, 0, 128);
    private final Color DARK_TRACK_BORDER_HIGH_CONTRAST = new Color(200, 200, 200);

    public LegacyScrollBarPainterExtension(@NotNull AquaUILayoutInfo aquaUILayoutInfo, @NotNull ScrollBarConfiguration scrollBarConfiguration, @Nullable VAppearance vAppearance) {
        this.uiLayout = aquaUILayoutInfo;
        this.g = scrollBarConfiguration;
        this.isLight = vAppearance != null && vAppearance.isDark();
        this.isHighContrast = vAppearance != null && vAppearance.isHighContrast();
        this.showThumb = scrollBarConfiguration.getKnobWidget() != AquaUIPainter.ScrollBarKnobWidget.NONE;
        this.isRollover = scrollBarConfiguration.getState() == AquaUIPainter.State.ROLLOVER;
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
        Shape shape;
        graphics2D = (Graphics2D)graphics2D.create();
        graphics2D.clip(new Rectangle2D.Float(0.0f, 0.0f, f, f2));
        boolean bl = f2 > f;
        Shape shape2 = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        ((RectangularShape)shape2).setFrameFromCenter(((RectangularShape)shape2).getCenterX(), ((RectangularShape)shape2).getCenterY(), ((RectangularShape)shape2).getMinX(), ((RectangularShape)shape2).getMinY());
        graphics2D.setColor(this.getTrackBackgroundColor());
        graphics2D.fill(shape2);
        float f3 = this.getTrackBorderThickness();
        Color color = this.getTrackBorderColor();
        if (this.isLight) {
            shape = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
            if (bl) {
                shape.setFrameFromCenter(((RectangularShape)shape2).getCenterX(), ((RectangularShape)shape2).getCenterY(), ((RectangularShape)shape2).getMinX() + (double)f3, ((RectangularShape)shape2).getMinY());
            } else {
                shape.setFrameFromCenter(((RectangularShape)shape2).getCenterX(), ((RectangularShape)shape2).getCenterY(), ((RectangularShape)shape2).getMinX(), ((RectangularShape)shape2).getMinY() + (double)f3);
            }
            Rectangle2D rectangle2D = ((Rectangle2D)shape2).createIntersection((Rectangle2D)shape);
            graphics2D.setColor(color);
            graphics2D.fill(rectangle2D);
        } else {
            double d = f3 / 2.0f;
            Path2D.Float float_ = new Path2D.Float();
            if (bl) {
                ((Path2D)float_).moveTo(((RectangularShape)shape2).getX() + d, ((RectangularShape)shape2).getY() + d);
                ((Path2D)float_).lineTo(((RectangularShape)shape2).getX() + d, ((RectangularShape)shape2).getY() + ((RectangularShape)shape2).getHeight() - d);
                ((Path2D)float_).moveTo(((RectangularShape)shape2).getX() + ((RectangularShape)shape2).getWidth() - d, ((RectangularShape)shape2).getY() + d);
                ((Path2D)float_).lineTo(((RectangularShape)shape2).getX() + ((RectangularShape)shape2).getWidth() - d, ((RectangularShape)shape2).getY() + ((RectangularShape)shape2).getHeight() - d);
            } else {
                ((Path2D)float_).moveTo(((RectangularShape)shape2).getX() + d, ((RectangularShape)shape2).getY() + d);
                ((Path2D)float_).lineTo(((RectangularShape)shape2).getX() + ((RectangularShape)shape2).getWidth() - d, ((RectangularShape)shape2).getY() + d);
                ((Path2D)float_).moveTo(((RectangularShape)shape2).getX() + d, ((RectangularShape)shape2).getY() + ((RectangularShape)shape2).getHeight() - d);
                ((Path2D)float_).lineTo(((RectangularShape)shape2).getX() + ((RectangularShape)shape2).getWidth() - d, ((RectangularShape)shape2).getY() + ((RectangularShape)shape2).getHeight() - d);
            }
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f3));
            graphics2D.draw(float_);
        }
        if (this.showThumb) {
            shape2 = this.createThumbShape(f, f2);
            graphics2D.setColor(this.getThumbColor());
            graphics2D.fill(shape2);
            Color color2 = this.getThumbBorderColor();
            if (color2 != null) {
                float f4 = this.getThumbBorderThickness();
                graphics2D.setColor(color2);
                graphics2D.setStroke(new BasicStroke(f4 * 1.5f));
                shape = this.createThumbShape(f, f2);
                graphics2D.clip(shape2);
                graphics2D.draw(shape);
            }
        }
        graphics2D.dispose();
    }

    @NotNull
    protected Shape createThumbShape(float f, float f2) {
        boolean bl = f2 > f;
        double d = 3.5;
        double d2 = 3.5;
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        Rectangle2D rectangle2D = this.uiLayout.getScrollBarThumbBounds(float_, this.g);
        if (bl) {
            double d3 = (double)f - d - d2;
            return new RoundRectangle2D.Double(d, rectangle2D.getY(), d3, rectangle2D.getHeight(), d3, d3);
        }
        double d4 = (double)f2 - d - d2;
        return new RoundRectangle2D.Double(rectangle2D.getX(), d, rectangle2D.getWidth(), d4, d4, d4);
    }

    @NotNull
    protected Color getTrackBorderColor() {
        return this.isLight ? (this.isHighContrast ? this.LIGHT_TRACK_BORDER_HIGH_CONTRAST : this.LIGHT_TRACK_BORDER) : (this.isHighContrast ? this.DARK_TRACK_BORDER_HIGH_CONTRAST : this.DARK_TRACK_BORDER);
    }

    protected float getTrackBorderThickness() {
        return this.isLight ? 1.0f : 0.8f;
    }

    protected float getThumbBorderThickness() {
        return 1.0f;
    }

    @NotNull
    protected Color getTrackBackgroundColor() {
        return this.isLight ? this.LIGHT_TRACK : this.DARK_TRACK;
    }

    @NotNull
    protected Color getThumbColor() {
        return this.isLight ? (this.isRollover ? this.LIGHT_ROLLOVER_THUMB : this.LIGHT_THUMB) : (this.isRollover ? this.DARK_ROLLOVER_THUMB : this.DARK_THUMB);
    }

    @Nullable
    protected Color getThumbBorderColor() {
        return this.isLight ? (this.isRollover ? this.LIGHT_ROLLOVER_THUMB_BORDER : this.LIGHT_THUMB_BORDER) : null;
    }
}

