/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import java.awt.geom.Rectangle2D;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AnimatedButtonConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ListBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellConfiguration;
import org.violetlib.jnr.aqua.coreui.CoreUIRendererDescriptions;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.LinearSliderRenderer;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.aqua.impl.PopupRenderer;
import org.violetlib.jnr.aqua.impl.TitleBarRendererBase;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.FlipVerticalRenderer;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;

public class CoreUIPainter
extends AquaUIPainterBase
implements AquaUIPainter {
    protected static boolean debugFlag = false;
    @NotNull
    protected static final CoreUIRendererDescriptions rendererDescriptions;
    protected boolean useJRS;

    public CoreUIPainter() {
        this(true);
    }

    public CoreUIPainter(boolean bl) {
        super(rendererDescriptions);
        this.useJRS = bl;
    }

    @Override
    @NotNull
    public CoreUIPainter copy() {
        return new CoreUIPainter();
    }

    @Override
    @NotNull
    protected Renderer getButtonRenderer(@NotNull ButtonConfiguration buttonConfiguration) {
        Object object;
        Object object2;
        String string;
        AquaUIPainter.ButtonWidget buttonWidget = this.toCanonicalButtonStyle(buttonConfiguration.getButtonWidget());
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            if (buttonConfiguration.getButtonState() != AquaUIPainter.ButtonState.ON) {
                return NULL_RENDERER;
            }
            ToolBarItemWellConfiguration toolBarItemWellConfiguration = new ToolBarItemWellConfiguration(buttonConfiguration.getState(), true);
            return this.getToolBarItemWellRenderer(toolBarItemWellConfiguration);
        }
        RendererDescription rendererDescription = rendererDescriptions.getButtonRendererDescription(buttonConfiguration);
        AquaUIPainter.State state = buttonConfiguration.getState();
        AquaUIPainter.ButtonState buttonState = buttonConfiguration.getButtonState();
        int n = JNRPlatformUtils.getPlatformVersion();
        boolean bl = false;
        switch (buttonWidget) {
            case BUTTON_PUSH: {
                string = "pushbutton";
                break;
            }
            case BUTTON_BEVEL: {
                string = "bevelbutton";
                break;
            }
            case BUTTON_BEVEL_ROUND: {
                string = "bevelbuttonround";
                break;
            }
            case BUTTON_CHECK_BOX: {
                string = "checkbox";
                break;
            }
            case BUTTON_RADIO: {
                string = "radiobutton";
                break;
            }
            case BUTTON_DISCLOSURE: {
                string = "disclosurebutton";
                break;
            }
            case BUTTON_DISCLOSURE_TRIANGLE: {
                string = "kCUIWidgetDisclosureTriangle";
                break;
            }
            case BUTTON_GRADIENT: {
                string = "bevelbuttoninset";
                break;
            }
            case BUTTON_HELP: {
                string = "kCUIWidgetButtonRoundHelp";
                break;
            }
            case BUTTON_RECESSED: {
                if (!this.shouldPaintRecessedBackground(state, buttonState)) {
                    return NULL_RENDERER;
                }
                bl = true;
                state = this.adjustRecessedState(state);
                string = "pushbutton.scopeselector";
                break;
            }
            case BUTTON_ROUNDED_RECT: {
                string = "pushbutton.inlay";
                break;
            }
            case BUTTON_ROUND: {
                string = "roundbutton";
                break;
            }
            case BUTTON_ROUND_INSET: {
                string = "roundbutton.inset";
                break;
            }
            case BUTTON_ROUND_TEXTURED: {
                string = "kCUIWidgetButtonRoundTextured";
                break;
            }
            case BUTTON_ROUND_TOOLBAR: {
                string = n >= 101100 ? "kCUIWidgetButtonRoundToolbar" : "roundbutton";
                break;
            }
            case BUTTON_INLINE: {
                string = "kCUIWidgetButtonPushSlideshow";
                break;
            }
            case BUTTON_TEXTURED: {
                string = "kCUIWidgetButtonSegmentedTextured";
                break;
            }
            case BUTTON_TEXTURED_TOOLBAR: {
                string = n >= 101100 ? "kCUIWidgetButtonSegmentedToolbar" : "kCUIWidgetButtonSegmentedTextured";
                break;
            }
            case BUTTON_PUSH_INSET2: {
                string = "kCUIWidgetButtonPushInset2";
                break;
            }
            case BUTTON_COLOR_WELL: {
                string = "kCUIWidgetFrameColorWell";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (state == AquaUIPainter.State.ROLLOVER && !bl) {
            state = AquaUIPainter.State.ACTIVE;
        }
        String string2 = null;
        String string3 = null;
        Integer n2 = null;
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            string3 = "backgroundTypeLight";
            string2 = buttonState == AquaUIPainter.ButtonState.OFF ? (buttonConfiguration.getLayoutDirection() == AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT ? "right" : "left") : "down";
            n2 = -1;
            if (buttonConfiguration instanceof AnimatedButtonConfiguration && (object2 = ((AnimatedButtonConfiguration)(object = (AnimatedButtonConfiguration)buttonConfiguration)).getPreviousButtonState()) != buttonState) {
                n2 = 1 + Math.round(2.0f * ((AnimatedButtonConfiguration)object).getTransition());
                if (buttonState == AquaUIPainter.ButtonState.OFF) {
                    n2 = 4 - n2;
                }
                string2 = buttonConfiguration.getLayoutDirection() == AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT ? "right" : "left";
            }
        } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            string2 = buttonState == AquaUIPainter.ButtonState.OFF ? "down" : "up";
        }
        object = this.toButtonState(buttonState);
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT || n < 101400 && buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            if (buttonState == AquaUIPainter.ButtonState.ON && (state == AquaUIPainter.State.ACTIVE || state == AquaUIPainter.State.INACTIVE)) {
                state = AquaUIPainter.State.PRESSED;
            }
            object = null;
        }
        if (buttonState == AquaUIPainter.ButtonState.STATELESS && !buttonWidget.isTextured()) {
            if (state == AquaUIPainter.State.INACTIVE) {
                state = AquaUIPainter.State.ACTIVE;
            } else if (state == AquaUIPainter.State.DISABLED_INACTIVE) {
                state = AquaUIPainter.State.DISABLED;
            }
        }
        object2 = this.toSize(buttonConfiguration.getSize());
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            object2 = null;
        }
        BasicRenderer basicRenderer = this.getRenderer("widget", string, "backgroundTypeKey", string3, "size", object2, "state", this.toState(state), "kCUIPresentationStateKey", this.toPresentationState(state), "focus", this.getFocused(buttonConfiguration, buttonConfiguration.isFocused()), "value", object, "direction", string2, "animframe", n2);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getScrollColumnSizerRenderer(@NotNull ScrollColumnSizerConfiguration scrollColumnSizerConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getScrollColumnSizerRendererDescription(scrollColumnSizerConfiguration);
        String string = "widget.scrollColumnSizer";
        BasicRenderer basicRenderer = this.getRenderer("widget", string, "state", this.toState(scrollColumnSizerConfiguration.getState()), "focus", this.getFocused(scrollColumnSizerConfiguration, scrollColumnSizerConfiguration.isFocused()));
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration scrollBarConfiguration) {
        BasicRenderer basicRenderer;
        String string;
        RendererDescription rendererDescription = rendererDescriptions.getScrollBarRendererDescription(scrollBarConfiguration);
        RendererDescription rendererDescription2 = rendererDescriptions.getScrollBarThumbRendererDescription(scrollBarConfiguration);
        AquaUIPainter.ScrollBarWidget scrollBarWidget = scrollBarConfiguration.getWidget();
        AquaUIPainter.Size size = scrollBarConfiguration.getSize();
        AquaUIPainter.State state = scrollBarConfiguration.getState();
        AquaUIPainter.Orientation orientation = scrollBarConfiguration.getOrientation();
        float f = scrollBarConfiguration.getThumbPosition();
        float f2 = scrollBarConfiguration.getThumbExtent();
        boolean bl = state == AquaUIPainter.State.DISABLED || state == AquaUIPainter.State.DISABLED_INACTIVE;
        boolean bl2 = false;
        switch (scrollBarWidget) {
            case LEGACY: {
                string = "scrollbar";
                if (state == AquaUIPainter.State.ROLLOVER) {
                    state = AquaUIPainter.State.PRESSED;
                }
                if (!scrollBarConfiguration.isTrackSuppressed()) break;
                bl2 = true;
                break;
            }
            case OVERLAY: {
                if (bl) {
                    return NULL_RENDERER;
                }
                string = "kCUIWidgetOverlayScrollBar";
                bl2 = true;
                break;
            }
            case OVERLAY_ROLLOVER: {
                if (bl) {
                    return NULL_RENDERER;
                }
                string = "kCUIWidgetOverlayScrollBar";
                bl2 = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (bl) {
            BasicRenderer basicRenderer2 = this.getRenderer("widget", string, "size", this.toSize(size), "kCUIOrientationKey", this.toOrientation(orientation), "noindicator", true);
            return Renderer.create(basicRenderer2, rendererDescription);
        }
        AquaUIPainter.ScrollBarKnobWidget scrollBarKnobWidget = scrollBarConfiguration.getKnobWidget();
        String string2 = null;
        switch (scrollBarKnobWidget) {
            case LIGHT: {
                string2 = "kCUIVariantWhite";
                break;
            }
            case DARK: {
                string2 = "kCUIVariantBlack";
            }
        }
        Renderer renderer = null;
        Renderer renderer2 = null;
        if (scrollBarWidget == AquaUIPainter.ScrollBarWidget.OVERLAY_ROLLOVER || scrollBarWidget == AquaUIPainter.ScrollBarWidget.LEGACY && !scrollBarConfiguration.isTrackSuppressed()) {
            basicRenderer = this.getRenderer("widget", string, "kCUIVariantKey", string2, "size", this.toSize(size), "kCUIOrientationKey", this.toOrientation(orientation), "noindicator", true);
            renderer = Renderer.create(basicRenderer, rendererDescription);
        }
        if (scrollBarKnobWidget != AquaUIPainter.ScrollBarKnobWidget.NONE) {
            if (state == AquaUIPainter.State.PRESSED || scrollBarWidget == AquaUIPainter.ScrollBarWidget.OVERLAY_ROLLOVER) {
                basicRenderer = this.getRenderer("widget", string, "kCUIVariantKey", string2, "size", this.toSize(size), "kCUIOrientationKey", this.toOrientation(orientation), "noarrows", true, "kCUIThumbProportionKey", f2, "indiconly", bl2, "state", "rollover", "value", f);
                renderer2 = Renderer.create(basicRenderer, rendererDescription2);
            } else {
                basicRenderer = this.getRenderer("widget", string, "kCUIVariantKey", string2, "size", this.toSize(size), "kCUIOrientationKey", this.toOrientation(orientation), "noarrows", true, "kCUIThumbProportionKey", f2, "indiconly", bl2, "value", f);
                renderer2 = Renderer.create(basicRenderer, rendererDescription2);
            }
        }
        return Renderer.createCompositeRenderer(renderer, renderer2);
    }

    @Override
    @NotNull
    protected Renderer getToolBarItemWellRenderer(@NotNull ToolBarItemWellConfiguration toolBarItemWellConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getToolBarItemWellRendererDescription(toolBarItemWellConfiguration);
        String string = "kCUIWidgetToolbarItemWell";
        AquaUIPainter.State state = toolBarItemWellConfiguration.getState();
        BasicRenderer basicRenderer = this.getRenderer("widget", string, "state", this.toState(state), "kCUIPresentationStateKey", this.toPresentationState(state), "borders only", toolBarItemWellConfiguration.isFrameOnly());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getGroupBoxRenderer(@NotNull GroupBoxConfiguration groupBoxConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getGroupBoxRendererDescription(groupBoxConfiguration);
        String string = "group";
        BasicRenderer basicRenderer = this.getRenderer("widget", string, "state", this.toState(groupBoxConfiguration.getState()), "borders only", groupBoxConfiguration.isFrameOnly());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @NotNull
    protected Renderer getGroupBoxMaskRenderer(@NotNull GroupBoxConfiguration groupBoxConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getGroupBoxRendererDescription(groupBoxConfiguration);
        String string = "group";
        BasicRenderer basicRenderer = this.getRenderer("widget", string, "state", this.toState(groupBoxConfiguration.getState()), "borders only", groupBoxConfiguration.isFrameOnly(), "kCUIMaskOnlyKey", true);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getListBoxRenderer(@NotNull ListBoxConfiguration listBoxConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getListBoxRendererDescription(listBoxConfiguration);
        String string = "listbox";
        BasicRenderer basicRenderer = this.getRenderer("widget", string, "state", this.toState(listBoxConfiguration.getState()), "focus", this.getFocused(listBoxConfiguration, listBoxConfiguration.isFocused()), "borders only", listBoxConfiguration.isFrameOnly());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getTextFieldRenderer(@NotNull TextFieldConfiguration textFieldConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getTextFieldRendererDescription(textFieldConfiguration);
        AquaUIPainter.TextFieldWidget textFieldWidget = textFieldConfiguration.getWidget();
        String string = this.getWidget(textFieldWidget);
        if (string != null) {
            String string2 = this.getVariant(textFieldWidget);
            BasicRenderer basicRenderer = this.getRenderer("widget", string, "size", textFieldWidget == AquaUIPainter.TextFieldWidget.TEXT_FIELD ? this.toSize(AquaUIPainter.Size.LARGE) : this.toSize(textFieldConfiguration.getSize()), "state", this.toState(textFieldConfiguration.getState()), "kCUIVariantKey", string2, "focus", this.getFocused(textFieldConfiguration, textFieldConfiguration.isFocused()));
            return Renderer.create(basicRenderer, rendererDescription);
        }
        if (textFieldWidget.isSearch()) {
            Insetter insetter = uiLayout.getSearchButtonPaintingInsets(textFieldConfiguration);
            Insetter insetter2 = textFieldWidget.hasCancel() ? uiLayout.getCancelButtonPaintingInsets(textFieldConfiguration) : null;
            return new SearchFieldRenderer(textFieldConfiguration, rendererDescription, insetter, insetter2);
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    private String getWidget(@NotNull AquaUIPainter.TextFieldWidget textFieldWidget) {
        switch (textFieldWidget) {
            case TEXT_FIELD_ROUND: 
            case TEXT_FIELD_ROUND_TOOLBAR: {
                return "textfieldround";
            }
            case TEXT_FIELD: {
                return "textfield";
            }
        }
        return null;
    }

    @Nullable
    private String getVariant(@NotNull AquaUIPainter.TextFieldWidget textFieldWidget) {
        return textFieldWidget.isToolbar() ? "kCUIVariantTextFieldRoundToolbar" : null;
    }

    @Override
    @NotNull
    public Renderer getSearchFieldFindButtonRenderer(@NotNull TextFieldConfiguration textFieldConfiguration) {
        AquaUIPainter.TextFieldWidget textFieldWidget = textFieldConfiguration.getWidget();
        boolean bl = textFieldWidget.hasMenu();
        BasicRenderer basicRenderer = this.getRenderer("widget", "buttonsearchfieldfind", "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(textFieldConfiguration.getLayoutDirection()), "size", this.toSize(textFieldConfiguration.getSize()), "state", this.toState(textFieldConfiguration.getState()), "kCUIVariantKey", bl ? "variant.withmenuglyph" : null);
        RendererDescription rendererDescription = this.getSearchFieldFindButtonRendererDescription(textFieldConfiguration);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @NotNull
    protected RendererDescription getSearchFieldFindButtonRendererDescription(@NotNull TextFieldConfiguration textFieldConfiguration) {
        return this.getSearchButtonRendererDescription(textFieldConfiguration);
    }

    @Override
    @NotNull
    public Renderer getSearchFieldCancelButtonRenderer(@NotNull TextFieldConfiguration textFieldConfiguration) {
        BasicRenderer basicRenderer = this.getRenderer("widget", "buttonsearchfieldcancel", "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(textFieldConfiguration.getLayoutDirection()), "size", this.toSize(textFieldConfiguration.getSize()), "state", this.toState(textFieldConfiguration.getState()));
        RendererDescription rendererDescription = this.getSearchFieldCancelButtonRendererDescription(textFieldConfiguration);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @NotNull
    protected RendererDescription getSearchFieldCancelButtonRendererDescription(@NotNull TextFieldConfiguration textFieldConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    protected Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration comboBoxConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getComboBoxRendererDescription(comboBoxConfiguration);
        AquaUIPainter.ComboBoxWidget comboBoxWidget = comboBoxConfiguration.getWidget();
        AquaUIPainter.Size size = comboBoxConfiguration.getSize();
        AquaUIPainter.State state = comboBoxConfiguration.getState();
        AquaUIPainter.UILayoutDirection uILayoutDirection = comboBoxConfiguration.getLayoutDirection();
        if (state == AquaUIPainter.State.ROLLOVER) {
            state = AquaUIPainter.State.ACTIVE;
        }
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            BasicRenderer basicRenderer = this.getRenderer("widget", "combobox", "size", this.toSize(size), "state", this.toState(state), "kCUIPresentationStateKey", this.toPresentationState(state), "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(uILayoutDirection), "noframe", true);
            return Renderer.create(basicRenderer, rendererDescription);
        }
        String string = this.getWidget(comboBoxWidget);
        BasicRenderer basicRenderer = this.getRenderer("widget", string, "size", this.toSize(size), "state", this.toState(state), "kCUIPresentationStateKey", this.toPresentationState(state), "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(uILayoutDirection), "focus", this.getFocused(comboBoxConfiguration, comboBoxConfiguration.isFocused()));
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @NotNull
    private String getWidget(@NotNull AquaUIPainter.ComboBoxWidget comboBoxWidget) {
        int n = JNRPlatformUtils.getPlatformVersion();
        switch (comboBoxWidget) {
            case BUTTON_COMBO_BOX_TEXTURED: {
                return "kCUIWidgetButtonComboBoxTextured";
            }
            case BUTTON_COMBO_BOX_TEXTURED_TOOLBAR: {
                return n >= 101100 ? "kCUIWidgetButtonComboBoxToolbar" : "kCUIWidgetButtonComboBoxTextured";
            }
        }
        return "combobox";
    }

    @Override
    @NotNull
    protected Renderer getPopupButtonRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        Renderer renderer = this.getBasicPopupButtonRenderer(popupButtonConfiguration);
        Renderer renderer2 = this.getPopupArrowRenderer(popupButtonConfiguration);
        Insetter insetter = renderer2 != null ? uiLayout.getPopUpArrowInsets(popupButtonConfiguration) : null;
        return new PopupRenderer(popupButtonConfiguration, renderer, renderer2, insetter);
    }

    @Nullable
    public Renderer getBasicPopupButtonRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        BasicRenderer basicRenderer;
        String string;
        if (popupButtonConfiguration.isCell()) {
            return null;
        }
        AquaUIPainter.State state = popupButtonConfiguration.getState();
        AquaUIPainter.Size size = popupButtonConfiguration.getSize();
        AquaUIPainter.UILayoutDirection uILayoutDirection = popupButtonConfiguration.getLayoutDirection();
        Collection collection = null;
        RendererDescription rendererDescription = rendererDescriptions.getBasicPopupButtonRendererDescription(popupButtonConfiguration);
        int n = JNRPlatformUtils.getPlatformVersion();
        boolean bl = false;
        switch (popupButtonConfiguration.getPopupButtonWidget()) {
            case BUTTON_POP_DOWN: {
                string = "popdownbutton";
                break;
            }
            case BUTTON_POP_UP: {
                string = "popupbutton";
                break;
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                string = "bevelbuttonround";
                break;
            }
            case BUTTON_POP_DOWN_ROUND_RECT: {
                string = "popdownbutton.inset";
                break;
            }
            case BUTTON_POP_UP_ROUND_RECT: {
                string = "popupbutton.inset";
                break;
            }
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_UP_RECESSED: {
                if (state != AquaUIPainter.State.ROLLOVER && state != AquaUIPainter.State.PRESSED) {
                    return null;
                }
                bl = true;
                string = "pushbutton.scopeselector";
                break;
            }
            case BUTTON_POP_DOWN_TEXTURED: {
                string = "kCUIWidgetButtonPopDownTextured";
                break;
            }
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: {
                string = n >= 101100 ? "kCUIWidgetButtonPopDownToolbar" : "kCUIWidgetButtonPopDownTextured";
                break;
            }
            case BUTTON_POP_UP_TEXTURED: {
                string = "kCUIWidgetButtonPopUpTextured";
                break;
            }
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                string = n >= 101100 ? "kCUIWidgetButtonPopUpToolbar" : "kCUIWidgetButtonPopUpTextured";
                break;
            }
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_UP_GRADIENT: {
                string = "bevelbuttoninset";
                break;
            }
            case BUTTON_POP_DOWN_SQUARE: 
            case BUTTON_POP_UP_SQUARE: {
                string = "bevelbutton";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (state == AquaUIPainter.State.ROLLOVER && !bl) {
            state = AquaUIPainter.State.ACTIVE;
        }
        if (collection == null) {
            basicRenderer = this.getRenderer("widget", string, "size", this.toSize(size), "state", this.toState(state), "kCUIPresentationStateKey", this.toPresentationState(state), "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(uILayoutDirection));
        } else {
            List<Object> list = Arrays.asList("widget", string, "size", this.toSize(size), "state", this.toState(state), "kCUIPresentationStateKey", this.toPresentationState(state), "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(uILayoutDirection));
            list.addAll(collection);
            basicRenderer = this.getRenderer(list.toArray());
        }
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
        AquaUIPainter.State state = popupButtonConfiguration.getState();
        switch (popupButtonWidget) {
            case BUTTON_POP_DOWN: 
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: 
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                return null;
            }
            case BUTTON_POP_UP_BEVEL: 
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_UP_SQUARE: 
            case BUTTON_POP_UP_CELL: {
                if (state != AquaUIPainter.State.ROLLOVER) break;
                state = AquaUIPainter.State.ACTIVE;
            }
        }
        Object object = this.toLayoutDirection(popupButtonConfiguration.getLayoutDirection());
        String string = "backgroundTypeLight";
        String string2 = this.toState(state);
        if (popupButtonConfiguration.isPopUp()) {
            AquaUIPainter.Size size = popupButtonConfiguration.getSize();
            BasicRenderer basicRenderer = this.getRenderer("widget", "popupbutton", "arrowsonly", true, "backgroundTypeKey", string, "kCUIUserInterfaceLayoutDirectionKey", object, "size", this.toSize(size), "state", string2);
            CoreUIRendererDescriptions coreUIRendererDescriptions = rendererDescriptions;
            RendererDescription rendererDescription = coreUIRendererDescriptions.getPopUpArrowRendererDescription(popupButtonConfiguration, size);
            return Renderer.create(basicRenderer, rendererDescription);
        }
        int n = JNRPlatformUtils.getPlatformVersion();
        String string3 = n >= 101100 ? "DropDownIndicator" : "image.DropDownIndicator";
        BasicRenderer basicRenderer = this.getRenderer("widget", "image", "imageIsGrayscaleKey", true, "imageNameKey", string3, "backgroundTypeKey", string, "kCUIUserInterfaceLayoutDirectionKey", object, "state", string2);
        CoreUIRendererDescriptions coreUIRendererDescriptions = rendererDescriptions;
        RendererDescription rendererDescription = coreUIRendererDescriptions.getPullDownArrowRendererDescription(popupButtonConfiguration);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getTitleBarRenderer(@NotNull TitleBarConfiguration titleBarConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getTitleBarRendererDescription(titleBarConfiguration);
        Insetter insetter = uiLayout.getTitleBarButtonInsets(titleBarConfiguration, AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX);
        Insetter insetter2 = uiLayout.getTitleBarButtonInsets(titleBarConfiguration, AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX);
        Insetter insetter3 = uiLayout.getTitleBarButtonInsets(titleBarConfiguration, AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX);
        return new TitleBarRenderer(titleBarConfiguration, rendererDescription, insetter, insetter2, insetter3);
    }

    @Override
    @NotNull
    protected Renderer getIndeterminateProgressIndicatorRenderer(@NotNull IndeterminateProgressIndicatorConfiguration indeterminateProgressIndicatorConfiguration) {
        String string;
        RendererDescription rendererDescription = rendererDescriptions.getIndeterminateProgressIndicatorRendererDescription(indeterminateProgressIndicatorConfiguration);
        AquaUIPainter.Size size = indeterminateProgressIndicatorConfiguration.getSize();
        AquaUIPainter.ProgressWidget progressWidget = indeterminateProgressIndicatorConfiguration.getWidget();
        switch (progressWidget) {
            case INDETERMINATE_SPINNER: {
                string = "widget.progressSpinner";
                if (size == AquaUIPainter.Size.SMALL) break;
                size = AquaUIPainter.Size.LARGE;
                break;
            }
            case INDETERMINATE_BAR: {
                if (size == AquaUIPainter.Size.MINI) {
                    throw new UnsupportedOperationException();
                }
                string = "kCUIWidgetIndeterminateBar";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        String string2 = progressWidget == AquaUIPainter.ProgressWidget.INDETERMINATE_BAR ? this.toOrientation(indeterminateProgressIndicatorConfiguration.getOrientation()) : null;
        BasicRenderer basicRenderer = this.getRenderer("widget", string, "size", this.toSize(size), "state", this.toState(indeterminateProgressIndicatorConfiguration.getState()), "kCUIOrientationKey", string2, "animframe", indeterminateProgressIndicatorConfiguration.getAnimationFrame());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getProgressIndicatorRenderer(@NotNull ProgressIndicatorConfiguration progressIndicatorConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getProgressIndicatorRendererDescription(progressIndicatorConfiguration);
        AquaUIPainter.Size size = progressIndicatorConfiguration.getSize();
        AquaUIPainter.ProgressWidget progressWidget = progressIndicatorConfiguration.getWidget();
        String string = "kCUIWidgetProgressBar";
        if (progressWidget == AquaUIPainter.ProgressWidget.SPINNER) {
            string = "kCUIWidgetProgressSpinnerDeterminate";
            if (size != AquaUIPainter.Size.SMALL) {
                size = AquaUIPainter.Size.LARGE;
            }
        }
        if (progressIndicatorConfiguration.getSize() == AquaUIPainter.Size.MINI) {
            throw new UnsupportedOperationException();
        }
        String string2 = progressWidget == AquaUIPainter.ProgressWidget.BAR ? this.toOrientation(progressIndicatorConfiguration.getOrientation()) : null;
        Object object = progressWidget == AquaUIPainter.ProgressWidget.BAR ? this.toLayoutDirection(progressIndicatorConfiguration.getLayoutDirection()) : null;
        BasicRenderer basicRenderer = this.getRenderer("widget", string, "size", this.toSize(size), "state", this.toActiveStateCode(progressIndicatorConfiguration.getState()), "kCUIPresentationStateKey", this.toPresentationState(progressIndicatorConfiguration.getState()), "kCUIOrientationKey", string2, "kCUIUserInterfaceLayoutDirectionKey", object, "value", progressIndicatorConfiguration.getValue());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        AquaUIPainter.Size size;
        RendererDescription rendererDescription = rendererDescriptions.getSliderRendererDescription(sliderConfiguration);
        AquaUIPainter.SliderWidget sliderWidget = sliderConfiguration.getWidget();
        AquaUIPainter.Size size2 = size = sliderConfiguration.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : sliderConfiguration.getSize();
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            int n = (int)Math.round(sliderConfiguration.getValue() * 360.0);
            BasicRenderer basicRenderer = this.getRenderer("widget", "dial", "size", this.toSize(size), "state", this.toState(sliderConfiguration.getState()), "focus", false, "noindicator", true, "value", n);
            return Renderer.create(basicRenderer, rendererDescription);
        }
        Renderer renderer = this.getSliderTrackRenderer(sliderConfiguration);
        Renderer renderer2 = this.getSliderTickMarkRenderer(sliderConfiguration);
        Renderer renderer3 = this.getSliderThumbRenderer(sliderConfiguration);
        Insetter insetter = uiLayout.getSliderTrackPaintingInsets(sliderConfiguration);
        Insetter insetter2 = uiLayout.getSliderThumbPaintingInsets(sliderConfiguration, sliderConfiguration.getValue());
        boolean bl = this.appearance != null && this.appearance.isDark();
        return new LinearSliderRenderer(sliderConfiguration, renderer, insetter, renderer2, renderer3, insetter2, bl);
    }

    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        return null;
    }

    @NotNull
    protected Renderer getSliderTrackRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        AquaUIPainter.SliderWidget sliderWidget = sliderConfiguration.getWidget();
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return NULL_RENDERER;
        }
        AquaUIPainter.Size size = sliderConfiguration.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : sliderConfiguration.getSize();
        String string = "kCUIUserInterfaceLayoutDirectionLeftToRight";
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            sliderWidget = AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL;
            string = "kCUIUserInterfaceLayoutDirectionRightToLeft";
        } else if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            sliderWidget = AquaUIPainter.SliderWidget.SLIDER_VERTICAL;
        }
        AquaUIPainter.State state = sliderConfiguration.getState();
        boolean bl = state != AquaUIPainter.State.DISABLED && state != AquaUIPainter.State.DISABLED_INACTIVE && !sliderConfiguration.hasTickMarks();
        String string2 = sliderWidget == AquaUIPainter.SliderWidget.SLIDER_VERTICAL ? "kCUIOrientVertical" : "kCUIOrientHorizontal";
        String string3 = sliderConfiguration.hasTickMarks() ? this.toDirection(sliderConfiguration.getTickMarkPosition()) : "none";
        BasicRenderer basicRenderer = this.getRenderer("widget", "slider", "noindicator", true, "size", this.toSize(size), "state", this.toState(sliderConfiguration.getState()), "kCUIOrientationKey", string2, "direction", string3, "kCUIUserInterfaceLayoutDirectionKey", string, "kCUISliderTrackDrawTintedKey", bl, "value", sliderConfiguration.getValue());
        if (sliderConfiguration.getWidget() == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN && bl) {
            basicRenderer = new FlipVerticalRenderer(basicRenderer);
        }
        RendererDescription rendererDescription = rendererDescriptions.getSliderTrackRendererDescription(sliderConfiguration);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @NotNull
    protected Renderer getSliderThumbRenderer(@NotNull SliderConfiguration sliderConfiguration, boolean bl) {
        AquaUIPainter.SliderWidget sliderWidget = sliderConfiguration.getWidget();
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return NULL_RENDERER;
        }
        AquaUIPainter.Size size = sliderConfiguration.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : sliderConfiguration.getSize();
        String string = sliderWidget == AquaUIPainter.SliderWidget.SLIDER_VERTICAL ? "kCUIOrientVertical" : "kCUIOrientHorizontal";
        String string2 = sliderConfiguration.hasTickMarks() ? this.toDirection(sliderConfiguration.getTickMarkPosition()) : "none";
        BasicRenderer basicRenderer = this.getRenderer("widget", "kCUIWidgetSliderThumb", "size", this.toSize(size), "state", this.toState(sliderConfiguration.getState()), "kCUIOrientationKey", string, "direction", string2, "focus", this.getFocused(sliderConfiguration, sliderConfiguration.isFocused()), "value", sliderConfiguration.getValue(), "kCUIMaskOnlyKey", bl);
        RendererDescription rendererDescription = rendererDescriptions.getSliderThumbRendererDescription(sliderConfiguration);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getSliderThumbRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        return this.getSliderThumbRenderer(sliderConfiguration, false);
    }

    @NotNull
    protected Renderer getSliderThumbMaskRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        return this.getSliderThumbRenderer(sliderConfiguration, true);
    }

    @Override
    @NotNull
    protected Renderer getSpinnerArrowsRenderer(@NotNull SpinnerArrowsConfiguration spinnerArrowsConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getSpinnerArrowsRendererDescription(spinnerArrowsConfiguration);
        AquaUIPainter.State state = spinnerArrowsConfiguration.getState();
        if (state == AquaUIPainter.State.PRESSED && !spinnerArrowsConfiguration.isPressedTop()) {
            BasicRenderer basicRenderer = this.getRenderer("widget", "littlearrows", "size", this.toSize(spinnerArrowsConfiguration.getSize()), "state", this.toState(state), "value", 1);
            return Renderer.create(basicRenderer, rendererDescription);
        }
        BasicRenderer basicRenderer = this.getRenderer("widget", "littlearrows", "size", this.toSize(spinnerArrowsConfiguration.getSize()), "state", this.toState(state));
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration splitPaneDividerConfiguration) {
        String string;
        RendererDescription rendererDescription = rendererDescriptions.getSplitPaneDividerRendererDescription(splitPaneDividerConfiguration);
        String string2 = "splitter";
        String string3 = this.toOrientation(splitPaneDividerConfiguration.getOrientation());
        switch (splitPaneDividerConfiguration.getWidget()) {
            case THIN_DIVIDER: {
                return NULL_RENDERER;
            }
            case THICK_DIVIDER: {
                string = "kCUIVariantDividerSplitterDimple";
                break;
            }
            default: {
                string = "kCUIVariantDividerSplitterRodMail";
            }
        }
        BasicRenderer basicRenderer = this.getRenderer("widget", string2, "state", this.toState(splitPaneDividerConfiguration.getState()), "kCUIVariantKey", string, "kCUIOrientationKey", string3);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getSegmentedButtonRendererDescription(segmentedButtonConfiguration);
        BasicRenderer basicRenderer = this.getSegmentedButtonBasicRenderer(segmentedButtonConfiguration, false);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @NotNull
    protected Renderer getSegmentedButtonMaskRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getSegmentedButtonRendererDescription(segmentedButtonConfiguration);
        BasicRenderer basicRenderer = this.getSegmentedButtonBasicRenderer(segmentedButtonConfiguration, true);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @NotNull
    protected BasicRenderer getSegmentedButtonBasicRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, boolean bl) {
        boolean bl2 = segmentedButtonConfiguration.isSelected();
        boolean bl3 = segmentedButtonConfiguration.getLeftDividerState() == SegmentedButtonConfiguration.DividerState.SELECTED;
        boolean bl4 = segmentedButtonConfiguration.getRightDividerState() == SegmentedButtonConfiguration.DividerState.SELECTED;
        String string = "kCUISegmentSeparatorTypeNoneSelected";
        if (bl2) {
            string = bl3 ? "kCUISegmentSeparatorTypeBothSelected" : "kCUISegmentSeparatorTypeRightSelected";
        } else if (bl3) {
            string = "kCUISegmentSeparatorTypeLeftSelected";
        }
        String string2 = "kCUISegmentSeparatorTypeNoneSelected";
        if (bl2) {
            string2 = bl4 ? "kCUISegmentSeparatorTypeBothSelected" : "kCUISegmentSeparatorTypeLeftSelected";
        } else if (bl4) {
            string2 = "kCUISegmentSeparatorTypeRightSelected";
        }
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        AquaUIPainter.State state = segmentedButtonConfiguration.getState();
        String string3 = "segmentedbutton";
        String string4 = this.toState(state);
        int n = JNRPlatformUtils.getPlatformVersion();
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: {
                string3 = "tab";
                break;
            }
            case BUTTON_SEGMENTED: {
                string3 = "segmentedbutton";
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                string3 = "kCUIWidgetButtonSegmentedInset";
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                string3 = "kCUIWidgetButtonSegmentedSCurve";
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: {
                string3 = "kCUIWidgetButtonSegmentedTextured";
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: {
                string3 = n >= 101100 ? "kCUIWidgetButtonSegmentedToolbar" : "kCUIWidgetButtonSegmentedTextured";
                break;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                string3 = "kCUIWidgetButtonSegmentedToolbar";
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                string3 = "bevelbuttoninset";
                break;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                string3 = "kCUIWidgetButtonSegmentedSeparated";
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                string3 = n >= 101100 ? "kCUIWidgetButtonSegmentedSeparatedTextured" : "kCUIWidgetButtonSegmentedSeparatedToolbar";
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: {
                string3 = n >= 101100 ? "kCUIWidgetButtonSegmentedSeparatedToolbar" : "kCUIWidgetButtonSegmentedSeparatedToolbar";
            }
        }
        return this.getRenderer("widget", string3, "size", this.toSize(segmentedButtonConfiguration.getSize()), "state", string4, "kCUIPresentationStateKey", this.toPresentationState(segmentedButtonConfiguration.getState()), "focus", this.getFocused(segmentedButtonConfiguration, segmentedButtonConfiguration.isFocused()), "kCUIUserInterfaceLayoutDirectionKey", "kCUIUserInterfaceLayoutDirectionLeftToRight", "direction", this.toDirection(segmentedButtonConfiguration.getDirection()), "kCUIPositionKey", this.toSegmentPosition(segmentedButtonConfiguration.getPosition()), "kCUISegmentLeadingSeparatorKey", segmentedButtonConfiguration.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE, "kCUISegmentTrailingSeparatorKey", segmentedButtonConfiguration.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE, "kCUISegmentLeadingSeparatorTypeKey", string, "kCUISegmentTrailingSeparatorTypeKey", string2, "value", bl2 ? 1 : 0, "kCUIMaskOnlyKey", bl);
    }

    @Override
    @NotNull
    protected Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration tableColumnHeaderConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getTableColumnHeaderRendererDescription(tableColumnHeaderConfiguration);
        Boolean bl = tableColumnHeaderConfiguration.getSortArrowDirection() != AquaUIPainter.ColumnSortArrowDirection.NONE;
        BasicRenderer basicRenderer = this.getRenderer("widget", "listheader", "state", this.toState(tableColumnHeaderConfiguration.getState()), "focus", this.getFocused(tableColumnHeaderConfiguration, tableColumnHeaderConfiguration.isFocused()), "direction", this.toDirection(tableColumnHeaderConfiguration.getSortArrowDirection()), "value", bl);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getGradientRenderer(@NotNull GradientConfiguration gradientConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getGradientRendererDescription(gradientConfiguration);
        String string = this.toVariant(gradientConfiguration.getWidget());
        Integer n = this.toActiveStateCode(gradientConfiguration.getState());
        BasicRenderer basicRenderer = this.getRenderer("widget", "gradient", "kCUIVariantKey", string, "state", n);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    protected boolean getFocused(@NotNull Configuration configuration, boolean bl) {
        return false;
    }

    @NotNull
    protected Object toSize(@NotNull AquaUIPainter.Size size) {
        switch (size) {
            case MINI: {
                return "mini";
            }
            case SMALL: {
                return "small";
            }
            case REGULAR: {
                return "regular";
            }
            case LARGE: {
                return "large";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected String toState(@NotNull AquaUIPainter.State state) {
        switch (state) {
            case ACTIVE: {
                return "normal";
            }
            case INACTIVE: {
                return "inactive";
            }
            case DISABLED: {
                return "disabled";
            }
            case DISABLED_INACTIVE: {
                return "disabled";
            }
            case PRESSED: {
                return "pressed";
            }
            case ACTIVE_DEFAULT: {
                return "pulsed";
            }
            case ROLLOVER: {
                return "rollover";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected String toActiveState(@NotNull AquaUIPainter.State state) {
        switch (state) {
            case INACTIVE: 
            case DISABLED: 
            case DISABLED_INACTIVE: {
                return "inactive";
            }
        }
        return "normal";
    }

    @NotNull
    protected String toActiveDisabledState(@NotNull AquaUIPainter.State state) {
        switch (state) {
            case INACTIVE: 
            case DISABLED: 
            case DISABLED_INACTIVE: {
                return "disabled";
            }
        }
        return "normal";
    }

    protected int toActiveStateCode(@NotNull AquaUIPainter.State state) {
        switch (state) {
            case INACTIVE: 
            case DISABLED: 
            case DISABLED_INACTIVE: {
                return 1;
            }
        }
        return 0;
    }

    @NotNull
    protected Object toPresentationState(@NotNull AquaUIPainter.State state) {
        switch (state) {
            case ACTIVE: {
                return "kCUIPresentationStateActiveKey";
            }
            case INACTIVE: {
                return "kCUIPresentationStateInactive";
            }
            case DISABLED: {
                return "kCUIPresentationStateActiveKey";
            }
            case DISABLED_INACTIVE: {
                return "kCUIPresentationStateInactive";
            }
            case PRESSED: {
                return "kCUIPresentationStateActiveKey";
            }
            case ACTIVE_DEFAULT: {
                return "kCUIPresentationStateActiveKey";
            }
            case ROLLOVER: {
                return "kCUIPresentationStateActiveKey";
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toButtonState(@NotNull AquaUIPainter.ButtonState buttonState) {
        switch (buttonState) {
            case OFF: 
            case STATELESS: {
                return 0;
            }
            case ON: {
                return 1;
            }
            case MIXED: {
                return 2;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toHorizontalAlignment(@NotNull AquaUIPainter.HorizontalAlignment horizontalAlignment) {
        switch (horizontalAlignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toVerticalAlignment(@NotNull AquaUIPainter.VerticalAlignment verticalAlignment) {
        switch (verticalAlignment) {
            case TOP: {
                return "top";
            }
            case CENTER: {
                return "center";
            }
            case BOTTOM: {
                return "bottom";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected String toOrientation(@NotNull AquaUIPainter.Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return "kCUIOrientHorizontal";
            }
            case VERTICAL: {
                return "kCUIOrientVertical";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toDirection(@NotNull AquaUIPainter.ColumnSortArrowDirection columnSortArrowDirection) {
        switch (columnSortArrowDirection) {
            case NONE: {
                return "none";
            }
            case UP: {
                return "up";
            }
            case DOWN: {
                return "down";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toDirection(@NotNull AquaUIPainter.Direction direction) {
        switch (direction) {
            case NONE: {
                return "none";
            }
            case UP: {
                return "up";
            }
            case DOWN: {
                return "down";
            }
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toDirection(@NotNull AquaUIPainter.TickMarkPosition tickMarkPosition) {
        switch (tickMarkPosition) {
            case ABOVE: {
                return "up";
            }
            case BELOW: {
                return "down";
            }
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toLayoutDirection(@NotNull AquaUIPainter.UILayoutDirection uILayoutDirection) {
        switch (uILayoutDirection) {
            case LEFT_TO_RIGHT: {
                return "kCUIUserInterfaceLayoutDirectionLeftToRight";
            }
            case RIGHT_TO_LEFT: {
                return "kCUIUserInterfaceLayoutDirectionRightToLeft";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toSegmentPosition(@NotNull AquaUIPainter.Position position) {
        switch (position) {
            case FIRST: {
                return "kCUISegmentPositionFirst";
            }
            case MIDDLE: {
                return "kCUISegmentPositionMiddle";
            }
            case LAST: {
                return "kCUISegmentPositionLast";
            }
            case ONLY: {
                return "kCUISegmentPositionOnly";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected String toVariant(@NotNull AquaUIPainter.GradientWidget gradientWidget) {
        switch (gradientWidget) {
            case GRADIENT_FIND_BAR: {
                return "kCUIVariantGradientFindBar";
            }
            case GRADIENT_FINDER_INFO: {
                return "variant.gradient.FinderInfo";
            }
            case GRADIENT_FINDER_SIDE_BAR: {
                return "variant.gradient.FinderSideBar";
            }
            case GRADIENT_FREEFORM: {
                return "kCUIVariantGradientFreeform";
            }
            case GRADIENT_LIST_BACKGROUND_EVEN: {
                return "kCUIVariantGradientListBackgroundEven";
            }
            case GRADIENT_LIST_BACKGROUND_ODD: {
                return "kCUIVariantGradientListBackgroundOdd";
            }
            case GRADIENT_SCOPE_BACKGROUND_BAR: {
                return "kCUIVariantGradientScopeBackgroundBar";
            }
            case GRADIENT_SCOPE_BACKGROUND_EVEN: {
                return "kCUIVariantGradientScopeBackgroundEven";
            }
            case GRADIENT_SCOPE_BACKGROUND_ODD: {
                return "kCUIVariantGradientScopeBackgroundOdd";
            }
            case GRADIENT_SIDE_BAR: {
                return "kCUIVariantGradientSideBar";
            }
            case GRADIENT_SIDE_BAR_SELECTION: {
                return "kCUIVariantGradientSideBarSelection";
            }
            case GRADIENT_SIDE_BAR_SELECTION_MULTIPLE: {
                return "kCUIVariantGradientSideBarSelectionMultiple";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected BasicRenderer getRenderer(Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            throw new IllegalArgumentException("getRenderer requires an even number of parameters");
        }
        return (nArray, n, n2, f, f2) -> {
            float f3 = (float)n / f;
            float f4 = (float)n2 / f2;
            if (debugFlag) {
                String string = "Rendering";
                for (Object object : objectArray) {
                    string = string + " " + object;
                }
                System.err.println(string);
                System.err.flush();
            }
            if (this.appearance != null) {
                CoreUIPainter.configureNativeAppearance(this.appearance);
            }
            if (this.useJRS) {
                CoreUIPainter.nativeJRSPaint(nArray, n, n2, f3, f4, objectArray);
            } else {
                CoreUIPainter.nativePaint(nArray, n, n2, f3, f4, objectArray, null);
            }
        };
    }

    @NotNull
    public String toString() {
        return this.useJRS ? "Core UI via JRS" : "Core UI";
    }

    private static native void nativePaint(int[] var0, int var1, int var2, float var3, float var4, Object[] var5, @Nullable long[] var6);

    private static native void nativeJRSPaint(int[] var0, int var1, int var2, float var3, float var4, Object[] var5);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NativeSupport.load();
                return null;
            }
        });
        rendererDescriptions = new CoreUIRendererDescriptions();
    }

    protected class TitleBarRenderer
    extends TitleBarRendererBase {
        @NotNull
        private final Object windowType;

        public TitleBarRenderer(@NotNull TitleBarConfiguration titleBarConfiguration, @Nullable RendererDescription rendererDescription, @Nullable Insetter insetter, @Nullable Insetter insetter2, Insetter insetter3) {
            super(titleBarConfiguration, rendererDescription, insetter, insetter2, insetter3);
            switch (titleBarConfiguration.getWidget()) {
                case DOCUMENT_WINDOW: {
                    this.windowType = "regularwin";
                    break;
                }
                case UTILITY_WINDOW: {
                    this.windowType = "utilwin.variant2";
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        @Override
        @NotNull
        protected BasicRenderer getBasicTitleBarRenderer(float f, float f2) {
            String string = "kCUIWidgetWindowFrame";
            String string2 = CoreUIPainter.this.toActiveState(this.g.getTitleBarState());
            return CoreUIPainter.this.getRenderer("widget", string, "windowtype", this.windowType, "kCUIWindowFrameDrawClippedKey", 1, "kCUIWindowFrameDrawTitleSeparatorKey", 1, "kCUIWindowFrameUnifiedTitleBarHeightKey", f2, "state", string2, "value", f2);
        }

        @Override
        @NotNull
        protected Renderer getButtonRenderer(@NotNull AquaUIPainter.TitleBarButtonWidget titleBarButtonWidget) {
            String string;
            AquaUIPainter.State state;
            String string2;
            switch (titleBarButtonWidget) {
                case CLOSE_BOX: {
                    string2 = "titlebarclose";
                    state = this.g.getCloseButtonState();
                    break;
                }
                case MINIMIZE_BOX: {
                    string2 = "titlebarcollapse";
                    state = this.g.getMinimizeButtonState();
                    break;
                }
                case RESIZE_BOX: {
                    switch (this.g.getResizeAction()) {
                        case ZOOM_ENTER: 
                        case ZOOM_EXIT: {
                            string2 = "titlebarzoom";
                            break;
                        }
                        case FULL_SCREEN_ENTER: {
                            string2 = "kCUIWidgetTitleBarFullScreenEnter";
                            break;
                        }
                        case FULL_SCREEN_EXIT: {
                            string2 = "kCUIWidgetTitleBarFullScreenExit";
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    state = this.g.getResizeButtonState();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            String string3 = string = this.g.getTitleBarState() == AquaUIPainter.State.ACTIVE ? "kCUIPresentationStateActiveKey" : "kCUIPresentationStateInactive";
            if (this.g.isDirty() && titleBarButtonWidget == AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX) {
                BasicRenderer basicRenderer = CoreUIPainter.this.getRenderer("widget", string2, "windowtype", this.windowType, "kCUIPresentationStateKey", string, "state", CoreUIPainter.this.toState(state), "value", 1);
                return Renderer.create(basicRenderer, null);
            }
            BasicRenderer basicRenderer = CoreUIPainter.this.getRenderer("widget", string2, "windowtype", this.windowType, "kCUIPresentationStateKey", string, "state", CoreUIPainter.this.toState(state));
            return Renderer.create(basicRenderer, null);
        }
    }

    private class SearchFieldRenderer
    extends Renderer {
        @NotNull
        private final TextFieldConfiguration g;
        @NotNull
        private final RendererDescription rd;
        @Nullable
        private final Insetter searchButtonInsets;
        @Nullable
        private final Insetter cancelButtonInsets;

        public SearchFieldRenderer(@NotNull TextFieldConfiguration textFieldConfiguration, @Nullable RendererDescription rendererDescription, @Nullable Insetter insetter, Insetter insetter2) {
            this.g = textFieldConfiguration;
            this.rd = rendererDescription;
            this.searchButtonInsets = insetter;
            this.cancelButtonInsets = insetter2;
        }

        @Override
        public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
            float f = reusableCompositor.getWidth();
            float f2 = reusableCompositor.getHeight();
            Object object = CoreUIPainter.this.getVariant(this.g.getWidget());
            Object object2 = CoreUIPainter.this.getRenderer("widget", "textfieldround", "size", CoreUIPainter.this.toSize(this.g.getSize()), "state", CoreUIPainter.this.toState(this.g.getState()), "kCUIVariantKey", object, "focus", CoreUIPainter.this.getFocused(this.g, this.g.isFocused()));
            Renderer renderer = Renderer.create((BasicRenderer)object2, this.rd);
            renderer.composeTo(reusableCompositor);
            if (this.searchButtonInsets != null) {
                object = CoreUIPainter.this.getSearchFieldFindButtonRenderer(this.g);
                object2 = this.searchButtonInsets.apply2D(f, f2);
                renderer = Renderer.createOffsetRenderer((Renderer)object, (Rectangle2D)object2);
                renderer.composeTo(reusableCompositor);
            }
            if (this.cancelButtonInsets != null) {
                object = CoreUIPainter.this.getSearchFieldCancelButtonRenderer(this.g);
                object2 = this.cancelButtonInsets.apply2D(f, f2);
                renderer = Renderer.createOffsetRenderer((Renderer)object, (Rectangle2D)object2);
                renderer.composeTo(reusableCompositor);
            }
        }
    }
}

