/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.vappearances;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.vappearances.NativeSupport;
import org.violetlib.vappearances.VAppearance;
import org.violetlib.vappearances.VAppearanceImpl;

public class VAppearances {
    @NotNull
    private static final Map<String, VAppearance> appearancesByName = new HashMap<String, VAppearance>();
    @NotNull
    private static final Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();
    @NotNull
    public static final String aquaAppearance = "NSAppearanceNameAqua";
    @NotNull
    public static final String darkAquaAppearance = "NSAppearanceNameDarkAqua";
    @NotNull
    public static final String vibrantLightAppearance = "NSAppearanceNameVibrantLight";
    @NotNull
    public static final String vibrantDarkAppearance = "NSAppearanceNameVibrantDark";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VAppearance getAppearance(@NotNull String appearanceName) throws IOException {
        Class<VAppearanceImpl> clazz = VAppearanceImpl.class;
        synchronized (VAppearanceImpl.class) {
            VAppearance appearance = appearancesByName.get(appearanceName);
            if (appearance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return appearance;
            }
            if (!NativeSupport.load()) {
                throw new IOException("Unable to load native library");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            String data = VAppearances.getSystemColorsData(appearanceName);
            if (data == null) {
                throw new IOException("Appearance " + appearanceName + " is not available");
            }
            appearance = VAppearanceImpl.parse(data);
            if (appearance != null) {
                VAppearances.installAppearance(appearance, "requested");
                Class<VAppearanceImpl> clazz2 = VAppearanceImpl.class;
                synchronized (VAppearanceImpl.class) {
                    VAppearance a = appearancesByName.get(appearanceName);
                    assert (a != null);
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return a;
                }
            }
            throw new IOException("Unable to parse appearance data");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VAppearance getApplicationEffectiveAppearance() throws IOException {
        Class<VAppearanceImpl> clazz = VAppearanceImpl.class;
        synchronized (VAppearanceImpl.class) {
            if (!NativeSupport.load()) {
                throw new IOException("Unable to load native library");
            }
            String name = VAppearances.nativeGetApplicationAppearanceName();
            // ** MonitorExit[var1] (shouldn't be in output)
            if (name == null) {
                throw new IOException("Application effective appearance is not available");
            }
            return VAppearances.getAppearance(name);
        }
    }

    private static void appearanceChanged(@NotNull String data) {
        SwingUtilities.invokeLater(() -> VAppearances.installAppearance(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installAppearance(@NotNull String data) {
        VAppearance a = VAppearanceImpl.parse(data);
        if (a != null) {
            Class<VAppearances> clazz = VAppearances.class;
            synchronized (VAppearances.class) {
                VAppearanceImpl old = (VAppearanceImpl)appearancesByName.get(a.getName());
                if (old == null || !data.equals(old.getData())) {
                    VAppearances.installAppearance(a, "updated");
                } else {
                    System.err.println("VAppearances: redundant data received for " + a.getName());
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            System.err.println("VAppearances: invalid data received");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installAppearance(@NotNull VAppearance a, @NotNull String source) {
        String name = a.getName();
        Class<VAppearances> clazz = VAppearances.class;
        synchronized (VAppearances.class) {
            VAppearanceImpl old = (VAppearanceImpl)appearancesByName.get(name);
            appearancesByName.put(name, a);
            ArrayList<ChangeListener> listenersToCall = new ArrayList<ChangeListener>(changeListeners);
            if (old != null) {
                old.setReplacement(a);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (old != null) {
                old.setReplacement(a);
            }
            System.err.println("VAppearances: installed " + source + " " + name);
            if (!listenersToCall.isEmpty()) {
                SwingUtilities.invokeLater(() -> VAppearances.invokeListeners(listenersToCall, a));
            }
            return;
        }
    }

    private static void invokeListeners(@NotNull List<ChangeListener> listeners, @NotNull VAppearance appearance) {
        AppearanceChangeEvent event = new AppearanceChangeEvent(appearance);
        for (ChangeListener listener : listeners) {
            listener.stateChanged(event);
        }
    }

    public static synchronized void addChangeListener(@NotNull ChangeListener listener) {
        changeListeners.add(listener);
    }

    public static synchronized void removeChangeListener(@NotNull ChangeListener listener) {
        changeListeners.remove(listener);
    }

    @Nullable
    private static native String getSystemColorsData(@NotNull String var0);

    private static native void registerChangeListener(@Nullable AppearanceChangedListener var0);

    @Nullable
    public static native String nativeGetApplicationAppearanceName();

    static {
        if (NativeSupport.load()) {
            VAppearances.registerChangeListener(VAppearances::appearanceChanged);
        }
    }

    private static interface AppearanceChangedListener {
        public void appearanceChanged(@NotNull String var1);
    }

    public static class AppearanceChangeEvent
    extends ChangeEvent {
        @NotNull
        private final VAppearance appearance;

        public AppearanceChangeEvent(@NotNull VAppearance appearance) {
            super(VAppearances.class);
            this.appearance = appearance;
        }

        @NotNull
        public VAppearance getAppearance() {
            return this.appearance;
        }
    }
}

