/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.vappearances;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.vappearances.VAppearance;

public class VAppearanceImpl
implements VAppearance {
    @NotNull
    private final String name;
    private final boolean isDark;
    private final boolean isHighContrast;
    @NotNull
    private final String data;
    @NotNull
    private final Map<String, Color> colors;
    @Nullable
    private VAppearance replacement;

    @Nullable
    public static VAppearance parse(@NotNull String data) {
        String prefix;
        String line;
        int pos = data.indexOf(10);
        if (pos > 0 && (line = data.substring(0, pos)).startsWith(prefix = "Appearance: ")) {
            String firstLine = line.substring(prefix.length()).trim();
            String name = null;
            boolean isHighContrast = false;
            StringTokenizer st = new StringTokenizer(firstLine, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (name == null) {
                    name = token;
                    continue;
                }
                if (token.equals("HighContrast")) {
                    isHighContrast = true;
                    continue;
                }
                System.err.println("VAppearance: unrecognized attribute: " + token);
            }
            if (name != null) {
                String rest = data.substring(pos + 1);
                Map<String, Color> colors = VAppearanceImpl.parseData(rest);
                boolean isDark = name.contains("Dark");
                return new VAppearanceImpl(name, isDark, isHighContrast, data, colors);
            }
        }
        return null;
    }

    @NotNull
    private static Map<String, Color> parseData(@NotNull String data) {
        HashMap<String, Color> colors = new HashMap<String, Color>();
        StringTokenizer st = new StringTokenizer(data, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int pos = line.indexOf(58);
            if (pos <= 0) continue;
            String name = line.substring(0, pos);
            String rest = line.substring(pos + 1).trim();
            Color color = VAppearanceImpl.parseColor(rest);
            if (color == null) continue;
            colors.put(name, color);
        }
        return colors;
    }

    @Nullable
    private static Color parseColor(@NotNull String s) {
        StringTokenizer st = new StringTokenizer(s, " ");
        Float red = VAppearanceImpl.parseParameter(st);
        Float green = VAppearanceImpl.parseParameter(st);
        Float blue = VAppearanceImpl.parseParameter(st);
        Float alpha = VAppearanceImpl.parseParameter(st);
        if (red != null && green != null && blue != null && alpha != null) {
            return new Color(red.floatValue(), green.floatValue(), blue.floatValue(), alpha.floatValue());
        }
        return null;
    }

    @Nullable
    private static Float parseParameter(@NotNull StringTokenizer st) {
        if (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                float f = Float.parseFloat(s);
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                return Float.valueOf(f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private VAppearanceImpl(@NotNull String name, boolean isDark, boolean isHighContrast, @NotNull String data, @NotNull Map<String, Color> colors) {
        this.name = name;
        this.isDark = isDark;
        this.isHighContrast = isHighContrast;
        this.data = data;
        this.colors = Collections.unmodifiableMap(colors);
    }

    public boolean isValid() {
        return this.replacement == null;
    }

    @Nullable
    public synchronized VAppearance getReplacement() {
        return this.replacement;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDark() {
        return this.isDark;
    }

    @Override
    public boolean isHighContrast() {
        return this.isHighContrast;
    }

    @NotNull
    String getData() {
        return this.data;
    }

    @Override
    @NotNull
    public Map<String, Color> getColors() {
        return this.colors;
    }

    synchronized void setReplacement(@NotNull VAppearance replacement) {
        this.replacement = replacement;
    }
}

