/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class JNRUtils {
    @NotNull
    static final DecimalFormat df2 = new DecimalFormat("0.00");
    public static final float NO_CHANGE = -123456.0f;

    public static int size(@NotNull AquaUIPainter.Size size, int n, int n2, int n3) {
        switch (size) {
            case SMALL: {
                return n2;
            }
            case MINI: {
                return n3;
            }
        }
        return n;
    }

    public static float size2D(@NotNull AquaUIPainter.Size size, float f, float f2, float f3) {
        switch (size) {
            case SMALL: {
                return f2;
            }
            case MINI: {
                return f3;
            }
        }
        return f;
    }

    @NotNull
    public static String format2(double d) {
        return df2.format(d);
    }

    @Nullable
    public static BasicRendererDescription toBasicRendererDescription(@NotNull RendererDescription rendererDescription) {
        if (rendererDescription instanceof BasicRendererDescription) {
            return (BasicRendererDescription)rendererDescription;
        }
        return null;
    }

    @Nullable
    public static BasicRendererDescription toBasicRendererDescription(@NotNull RendererDescription rendererDescription, int n) {
        if (rendererDescription instanceof BasicRendererDescription) {
            return (BasicRendererDescription)rendererDescription;
        }
        if (rendererDescription instanceof MultiResolutionRendererDescription) {
            RendererDescription rendererDescription2;
            MultiResolutionRendererDescription multiResolutionRendererDescription = (MultiResolutionRendererDescription)rendererDescription;
            RendererDescription rendererDescription3 = rendererDescription2 = n == 1 ? multiResolutionRendererDescription.getDescription1() : multiResolutionRendererDescription.getDescription2();
            if (rendererDescription2 instanceof BasicRendererDescription) {
                return (BasicRendererDescription)rendererDescription2;
            }
        }
        return null;
    }

    @NotNull
    public static RendererDescription adjustRendererDescription(@NotNull RendererDescription rendererDescription, float f, float f2, float f3, float f4) throws UnsupportedOperationException {
        if (f == 0.0f && f2 == 0.0f && f3 == 0.0f && f4 == 0.0f) {
            return rendererDescription;
        }
        BasicRendererDescription basicRendererDescription = JNRUtils.toBasicRendererDescription(rendererDescription);
        if (basicRendererDescription != null) {
            return basicRendererDescription.withAdjustments(f, f2, f3, f4);
        }
        if (rendererDescription instanceof MultiResolutionRendererDescription) {
            MultiResolutionRendererDescription multiResolutionRendererDescription = (MultiResolutionRendererDescription)rendererDescription;
            BasicRendererDescription basicRendererDescription2 = JNRUtils.toBasicRendererDescription(multiResolutionRendererDescription.getDescription1());
            BasicRendererDescription basicRendererDescription3 = JNRUtils.toBasicRendererDescription(multiResolutionRendererDescription.getDescription2());
            if (basicRendererDescription2 != null && basicRendererDescription3 != null) {
                basicRendererDescription2 = basicRendererDescription2.withAdjustments(f, f2, f3, f4);
                basicRendererDescription3 = basicRendererDescription3.withAdjustments(f, f2, f3, f4);
                return new MultiResolutionRendererDescription(basicRendererDescription2, basicRendererDescription3);
            }
        }
        throw new UnsupportedOperationException("Renderer description cannot be adjusted");
    }

    @NotNull
    public static RendererDescription changeRendererDescription(@NotNull RendererDescription rendererDescription, float f, float f2, float f3, float f4) throws UnsupportedOperationException {
        if (f == -123456.0f && f2 == -123456.0f && f3 == -123456.0f && f4 == -123456.0f) {
            return rendererDescription;
        }
        BasicRendererDescription basicRendererDescription = JNRUtils.toBasicRendererDescription(rendererDescription);
        if (basicRendererDescription != null) {
            return JNRUtils.change(basicRendererDescription, f, f2, f3, f4);
        }
        if (rendererDescription instanceof MultiResolutionRendererDescription) {
            MultiResolutionRendererDescription multiResolutionRendererDescription = (MultiResolutionRendererDescription)rendererDescription;
            BasicRendererDescription basicRendererDescription2 = JNRUtils.toBasicRendererDescription(multiResolutionRendererDescription.getDescription1());
            BasicRendererDescription basicRendererDescription3 = JNRUtils.toBasicRendererDescription(multiResolutionRendererDescription.getDescription2());
            if (basicRendererDescription2 != null && basicRendererDescription3 != null) {
                basicRendererDescription2 = JNRUtils.change(basicRendererDescription2, f, f2, f3, f4);
                basicRendererDescription3 = JNRUtils.change(basicRendererDescription3, f, f2, f3, f4);
                return new MultiResolutionRendererDescription(basicRendererDescription2, basicRendererDescription3);
            }
        }
        throw new UnsupportedOperationException("Renderer description cannot be changed");
    }

    @NotNull
    private static BasicRendererDescription change(@NotNull BasicRendererDescription basicRendererDescription, float f, float f2, float f3, float f4) {
        float f5 = f == -123456.0f ? basicRendererDescription.getXOffset() : f;
        float f6 = f2 == -123456.0f ? basicRendererDescription.getYOffset() : f2;
        float f7 = f3 == -123456.0f ? basicRendererDescription.getWidthAdjustment() : f3;
        float f8 = f4 == -123456.0f ? basicRendererDescription.getHeightAdjustment() : f4;
        return new BasicRendererDescription(f5, f6, f7, f8);
    }

    static {
        df2.setDecimalSeparatorAlwaysShown(true);
    }
}

