/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.impl.CircularSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.ComboBoxButtonCellPainterExtension;
import org.violetlib.jnr.aqua.impl.LinearSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.OverlayScrollBarPainterExtension;
import org.violetlib.jnr.aqua.impl.PopUpArrowPainter;
import org.violetlib.jnr.aqua.impl.PullDownArrowPainter;
import org.violetlib.jnr.aqua.impl.TableColumnHeaderCellPainterExtension;
import org.violetlib.jnr.aqua.impl.ThickSplitPaneDividerPainterExtension;
import org.violetlib.jnr.aqua.impl.ThinSplitPaneDividerPainterExtension;
import org.violetlib.jnr.aqua.jrs.JRSPainter;
import org.violetlib.jnr.impl.Renderer;

public class AugmentedJRSPainter
extends JRSPainter {
    @Override
    @NotNull
    public AugmentedJRSPainter copy() {
        return new AugmentedJRSPainter();
    }

    @Override
    @NotNull
    public Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration tableColumnHeaderConfiguration) {
        TableColumnHeaderCellPainterExtension tableColumnHeaderCellPainterExtension = new TableColumnHeaderCellPainterExtension(tableColumnHeaderConfiguration);
        return Renderer.create(tableColumnHeaderCellPainterExtension);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration splitPaneDividerConfiguration) {
        if (splitPaneDividerConfiguration.getWidget() == AquaUIPainter.DividerWidget.THICK_DIVIDER) {
            ThickSplitPaneDividerPainterExtension thickSplitPaneDividerPainterExtension = new ThickSplitPaneDividerPainterExtension(splitPaneDividerConfiguration);
            return Renderer.create(thickSplitPaneDividerPainterExtension);
        }
        if (splitPaneDividerConfiguration.getWidget() == AquaUIPainter.DividerWidget.THIN_DIVIDER) {
            ThinSplitPaneDividerPainterExtension thinSplitPaneDividerPainterExtension = new ThinSplitPaneDividerPainterExtension(splitPaneDividerConfiguration);
            return Renderer.create(thinSplitPaneDividerPainterExtension);
        }
        return super.getSplitPaneDividerRenderer(splitPaneDividerConfiguration);
    }

    @Override
    @NotNull
    protected Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration comboBoxConfiguration) {
        AquaUIPainter.ComboBoxWidget comboBoxWidget = comboBoxConfiguration.getWidget();
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            ComboBoxButtonCellPainterExtension comboBoxButtonCellPainterExtension = new ComboBoxButtonCellPainterExtension(comboBoxConfiguration);
            return Renderer.create(comboBoxButtonCellPainterExtension);
        }
        return super.getComboBoxButtonRenderer(comboBoxConfiguration);
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        Renderer renderer = super.getPopupArrowRenderer(popupButtonConfiguration);
        if (this.isArrowNeeded(popupButtonConfiguration)) {
            if (popupButtonConfiguration.isPopUp()) {
                return Renderer.create(new PopUpArrowPainter(popupButtonConfiguration));
            }
            return Renderer.create(new PullDownArrowPainter(popupButtonConfiguration));
        }
        return renderer;
    }

    private boolean isArrowNeeded(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
        if (popupButtonConfiguration.isPopUp()) {
            return popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED;
        }
        switch (popupButtonWidget) {
            case BUTTON_POP_DOWN: 
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    protected Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration scrollBarConfiguration) {
        AquaUIPainter.ScrollBarWidget scrollBarWidget = scrollBarConfiguration.getWidget();
        if (scrollBarWidget == AquaUIPainter.ScrollBarWidget.LEGACY) {
            return super.getScrollBarRenderer(scrollBarConfiguration);
        }
        return Renderer.create(new OverlayScrollBarPainterExtension(uiLayout, scrollBarConfiguration));
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        Renderer renderer = super.getSliderRenderer(sliderConfiguration);
        if (sliderConfiguration.getWidget() == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            Renderer renderer2 = Renderer.create(new CircularSliderPainterExtension(sliderConfiguration));
            return Renderer.createCompositeRenderer(renderer, renderer2);
        }
        return renderer;
    }

    @Override
    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        if (sliderConfiguration.getWidget() != AquaUIPainter.SliderWidget.SLIDER_CIRCULAR && sliderConfiguration.hasTickMarks()) {
            return Renderer.create(new LinearSliderPainterExtension(uiLayout, sliderConfiguration));
        }
        return null;
    }
}

