/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.impl.AquaNativePainter;
import org.violetlib.jnr.aqua.impl.HybridAquaUIPainter;
import org.violetlib.jnr.aqua.impl.NativeSupport;

public class AquaNativeRendering {
    private static boolean isInitialized;
    @Nullable
    private static AquaUIPainter preferredPainter;

    @NotNull
    public static AquaUIPainter createPainter() throws UnsupportedOperationException {
        if (!isInitialized) {
            AquaNativeRendering.findPainterClasses();
        }
        if (preferredPainter != null) {
            return preferredPainter.copy();
        }
        throw new UnsupportedOperationException("Unable to create a native painter");
    }

    private AquaNativeRendering() {
    }

    @NotNull
    public static String getReleaseName() {
        return AquaNativeRendering.getStringResource("RELEASE.txt");
    }

    @NotNull
    public static String getBuildID() {
        return AquaNativeRendering.getStringResource("BUILD.txt");
    }

    @NotNull
    public static String getVersionString() {
        return "VAquaRendering: release " + AquaNativeRendering.getReleaseName() + " (build " + AquaNativeRendering.getBuildID() + ")";
    }

    public static void showVersion() {
        System.err.println("VAquaRendering: release " + AquaNativeRendering.getReleaseName() + ", build " + AquaNativeRendering.getBuildID());
    }

    @NotNull
    private static String getStringResource(@NotNull String string) {
        InputStream inputStream = AquaNativeRendering.class.getResourceAsStream(string);
        if (inputStream != null) {
            try {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder stringBuilder = new StringBuilder();
                while ((n = bufferedReader.read()) >= 0) {
                    stringBuilder.append((char)n);
                }
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "Unknown";
    }

    private static synchronized void findPainterClasses() {
        Class clazz;
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        AquaNativePainter aquaNativePainter = null;
        AquaUIPainter aquaUIPainter = null;
        AquaUIPainter aquaUIPainter2 = null;
        try {
            Class clazz2 = AquaNativeRendering.getClass("org.violetlib.jnr.aqua.impl.AugmentedAquaNativePainter");
            if (AquaNativePainter.class.isAssignableFrom(clazz2)) {
                aquaNativePainter = (AquaNativePainter)clazz2.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = NativeSupport.getJavaRuntimeSupportMajorVersion();
        boolean bl = n >= 15;
        try {
            clazz = AquaNativeRendering.getClass("org.violetlib.jnr.aqua.coreui.AugmentedCoreUIPainter");
            if (AquaUIPainter.class.isAssignableFrom(clazz)) {
                Constructor constructor = clazz.getConstructor(Boolean.TYPE);
                aquaUIPainter = (AquaUIPainter)constructor.newInstance(bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            try {
                clazz = AquaNativeRendering.getClass("org.violetlib.jnr.aqua.jrs.AugmentedJRSPainter");
                if (AquaUIPainter.class.isAssignableFrom(clazz)) {
                    aquaUIPainter2 = (AquaUIPainter)clazz.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        preferredPainter = aquaNativePainter != null && aquaUIPainter != null ? new HybridAquaUIPainter(aquaNativePainter, aquaUIPainter, aquaUIPainter2) : (aquaUIPainter != null ? aquaUIPainter : (aquaNativePainter != null ? aquaNativePainter : aquaUIPainter2));
    }

    @NotNull
    protected static Class getClass(@NotNull String string) throws ClassNotFoundException {
        ClassLoader classLoader = AquaNativeRendering.class.getClassLoader();
        return Class.forName(string, true, classLoader);
    }
}

