/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeSupport {
    private static final String libraryName = "VAquaRendering";
    private static boolean isAvailable;
    private static boolean isInitialized;

    public static synchronized boolean load() {
        if (!isInitialized) {
            isInitialized = true;
            NativeSupport.loadNativeSupport();
        }
        return isAvailable;
    }

    private static void loadNativeSupport() {
        try {
            String string = NativeSupport.findNativeLibrary(NativeSupport.class, libraryName);
            if (string == null) {
                NativeSupport.reportNativeLibraryError("Library not found");
                return;
            }
            System.load(string);
            NativeSupport.log("Java Runtime Support: " + NativeSupport.getJavaRuntimeSupportVersion());
            int n = NativeSupport.getJavaRuntimeSupportMajorVersion();
            if (n > 0 && n < 15) {
                NativeSupport.log("Found obsolete version of Java Runtime Support framework");
                NativeSupport.log("To upgrade, install Java for OS X 2015-001 from https://support.apple.com/kb/DL1572");
            }
            isAvailable = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            NativeSupport.reportNativeLibraryError(unsatisfiedLinkError.getMessage());
        }
        catch (AccessControlException accessControlException) {
            NativeSupport.reportNativeLibraryError("permission denied: " + accessControlException.getMessage());
        }
        catch (Throwable throwable) {
            NativeSupport.reportNativeLibraryError(throwable.toString());
            throwable.printStackTrace();
        }
    }

    public static void log(@NotNull String string) {
        System.err.println(string);
        try {
            NativeSupport.syslog(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void reportNativeLibraryError(@NotNull String string) {
        String string2 = System.mapLibraryName(libraryName);
        String string3 = "NativeSupport: Unable to load library " + string2 + ": " + string;
        System.err.println(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String findNativeLibrary(@NotNull Class<?> clazz, @NotNull String string) throws IllegalArgumentException {
        InputStream inputStream;
        File file = NativeSupport.findNativeLibraryOnPath(string);
        if (file != null) {
            return file.getPath();
        }
        String string2 = "lib" + string;
        String string3 = ".dylib";
        String string4 = string2 + string3;
        try {
            inputStream = clazz.getClassLoader().getResourceAsStream(string4);
        }
        catch (SecurityException securityException) {
            return null;
        }
        if (inputStream == null) {
            return null;
        }
        try {
            File file2 = File.createTempFile(string2, string3).getAbsoluteFile();
            try (Object object = new FileOutputStream(file2);){
                NativeSupport.internalInitializeFile(inputStream, (OutputStream)object);
            }
            object = file2.getPath();
            return object;
        }
        catch (IOException iOException) {
            System.err.println("Unable to extract native library resource: " + iOException.getMessage());
            String string5 = null;
            return string5;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Nullable
    private static File findNativeLibraryOnPath(@NotNull String string) throws IllegalArgumentException {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Invalid library name: name is empty");
        }
        if (string.indexOf(32) >= 0 || string.indexOf(46) >= 0 || string.indexOf(File.pathSeparatorChar) >= 0) {
            throw new IllegalArgumentException("Invalid library name");
        }
        String string2 = "lib" + string + ".dylib";
        String string3 = System.getProperty("java.library.path");
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                File file = new File(string4 + File.separator + string2).getAbsoluteFile();
                if (!file.isFile()) continue;
                return file;
            }
        }
        return null;
    }

    private static void internalInitializeFile(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static int getJavaRuntimeSupportMajorVersion() {
        int n;
        int n2;
        String string = NativeSupport.getJavaRuntimeSupportVersion();
        if (string != null && (n2 = string.indexOf(46)) > 0 && (n = Integer.parseInt(string.substring(0, n2))) > 0) {
            return n;
        }
        return 0;
    }

    @Nullable
    public static native String getJavaRuntimeSupportVersion();

    public static native void syslog(@NotNull String var0);
}

