/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class RoundToolbarButtonPainterExtension
implements PainterExtension {
    @NotNull
    protected final ButtonConfiguration bg;
    @Nullable
    protected final VAppearance appearance;
    @NotNull
    protected final Colors colors;

    public RoundToolbarButtonPainterExtension(@NotNull ButtonConfiguration buttonConfiguration, @Nullable VAppearance vAppearance) {
        this.bg = buttonConfiguration;
        this.appearance = vAppearance;
        this.colors = Colors.getColors(vAppearance);
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
        AquaUIPainter.State state = this.bg.getState();
        AquaUIPainter.ButtonState buttonState = this.bg.getButtonState();
        boolean bl = state == AquaUIPainter.State.PRESSED || buttonState == AquaUIPainter.ButtonState.ON || buttonState == AquaUIPainter.ButtonState.MIXED;
        double d = (double)f / 2.0;
        double d2 = (double)f2 / 2.0;
        double d3 = f2 - 2.0f;
        double d4 = d3 / 2.0;
        Color color = this.getColor();
        Ellipse2D.Double double_ = new Ellipse2D.Double(d - d4, d2 - d4, d3, d3);
        graphics2D.setColor(color);
        if (bl) {
            graphics2D.fill(double_);
        } else {
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.draw(double_);
        }
    }

    @NotNull
    protected Color getColor() {
        String string = "toolbarButton";
        AquaUIPainter.State state = this.bg.getState();
        AquaUIPainter.ButtonState buttonState = this.bg.getButtonState();
        if (buttonState == AquaUIPainter.ButtonState.ON || buttonState == AquaUIPainter.ButtonState.MIXED) {
            string = string + "Selected";
        }
        if (state == AquaUIPainter.State.PRESSED) {
            string = string + "Pressed";
        }
        return this.colors.get(string);
    }
}

