/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;
import org.violetlib.geom.GeneralRoundRectangle;

class GeneralRoundRectIterator
implements PathIterator {
    double x;
    double y;
    double w;
    double h;
    double tlaw;
    double tlah;
    double traw;
    double trah;
    double braw;
    double brah;
    double blaw;
    double blah;
    AffineTransform affine;
    int index;
    int cornerIndex;
    double[] arcWidths;
    double[] arcHeights;
    private static final double angle = 0.7853981633974483;
    private static final double a = 1.0 - Math.cos(0.7853981633974483);
    private static final double b = Math.tan(0.7853981633974483);
    private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
    private static final double cv = 1.3333333333333333 * a * b / c;
    private static final double acv = (1.0 - cv) / 2.0;
    private static double[][] ctrlpts = new double[][]{{0.0, 0.0, 0.0, 0.5}, {0.0, 0.0, 1.0, -0.5}, {0.0, 0.0, 1.0, -acv, 0.0, acv, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0}, {1.0, -0.5, 1.0, 0.0}, {1.0, -acv, 1.0, 0.0, 1.0, 0.0, 1.0, -acv, 1.0, 0.0, 1.0, -0.5}, {1.0, 0.0, 0.0, 0.5}, {1.0, 0.0, 0.0, acv, 1.0, -acv, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}, {0.0, acv, 0.0, 0.0, 0.0, 0.0, 0.0, acv, 0.0, 0.0, 0.0, 0.5}, new double[0]};
    private static int[] types = new int[]{0, 1, 3, 1, 3, 1, 3, 1, 3, 4};

    GeneralRoundRectIterator(GeneralRoundRectangle generalRoundRectangle, AffineTransform affineTransform) {
        this.x = generalRoundRectangle.getX();
        this.y = generalRoundRectangle.getY();
        this.w = generalRoundRectangle.getWidth();
        this.h = generalRoundRectangle.getHeight();
        this.tlaw = Math.min(this.w, Math.abs(generalRoundRectangle.getTopLeftArcWidth()));
        this.tlah = Math.min(this.h, Math.abs(generalRoundRectangle.getTopLeftArcHeight()));
        this.traw = Math.min(this.w, Math.abs(generalRoundRectangle.getTopRightArcWidth()));
        this.trah = Math.min(this.h, Math.abs(generalRoundRectangle.getTopRightArcHeight()));
        this.braw = Math.min(this.w, Math.abs(generalRoundRectangle.getBottomRightArcWidth()));
        this.brah = Math.min(this.h, Math.abs(generalRoundRectangle.getBottomRightArcHeight()));
        this.blaw = Math.min(this.w, Math.abs(generalRoundRectangle.getBottomLeftArcWidth()));
        this.blah = Math.min(this.h, Math.abs(generalRoundRectangle.getBottomLeftArcHeight()));
        this.affine = affineTransform;
        if (this.tlaw < 0.0 || this.tlah < 0.0 || this.traw < 0.0 || this.trah < 0.0 || this.braw < 0.0 || this.brah < 0.0 || this.blaw < 0.0 || this.blah < 0.0) {
            this.index = ctrlpts.length;
        }
        this.arcWidths = new double[]{this.tlaw, this.blaw, this.braw, this.traw};
        this.arcHeights = new double[]{this.tlah, this.blah, this.brah, this.trah};
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index >= ctrlpts.length;
    }

    @Override
    public void next() {
        ++this.index;
        if (this.index % 2 == 1) {
            ++this.cornerIndex;
            if (this.cornerIndex >= 4) {
                this.cornerIndex = 0;
            }
        }
    }

    @Override
    public int currentSegment(float[] fArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("GeneralRoundRect iterator out of bounds");
        }
        double[] dArray = ctrlpts[this.index];
        int n = 0;
        for (int i = 0; i < dArray.length; i += 4) {
            fArray[n++] = (float)(this.x + dArray[i + 0] * this.w + dArray[i + 1] * this.arcWidths[this.cornerIndex]);
            fArray[n++] = (float)(this.y + dArray[i + 2] * this.h + dArray[i + 3] * this.arcHeights[this.cornerIndex]);
        }
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, n / 2);
        }
        return types[this.index];
    }

    @Override
    public int currentSegment(double[] dArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("GeneralRoundRect iterator out of bounds");
        }
        double[] dArray2 = ctrlpts[this.index];
        int n = 0;
        for (int i = 0; i < dArray2.length; i += 4) {
            dArray[n++] = this.x + dArray2[i + 0] * this.w + dArray2[i + 1] * this.arcWidths[this.cornerIndex];
            dArray[n++] = this.y + dArray2[i + 2] * this.h + dArray2[i + 3] * this.arcHeights[this.cornerIndex];
        }
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, n / 2);
        }
        return types[this.index];
    }
}

