/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.geom.ExpandableEllipseOutline;
import org.violetlib.geom.ExpandableRectangleOutline;
import org.violetlib.geom.ExpandableRoundRectOutline;

public abstract class ExpandableOutline {
    @NotNull
    public abstract Shape getShape(float var1);

    @NotNull
    public static ExpandableOutline fromShape(@NotNull Shape shape) {
        if (shape instanceof RoundRectangle2D) {
            return new ExpandableRoundRectOutline((RoundRectangle2D)shape);
        }
        if (shape instanceof Rectangle2D) {
            return new ExpandableRectangleOutline((Rectangle2D)shape);
        }
        if (shape instanceof Ellipse2D) {
            return new ExpandableEllipseOutline((Ellipse2D)shape);
        }
        if (shape instanceof ExpandableShape) {
            ExpandableShape expandableShape = (ExpandableShape)((Object)shape);
            return new ExpandableShapeOutline(expandableShape);
        }
        return new GenericOutline(shape);
    }

    @NotNull
    public static Shape createTranslatedShape(@NotNull Shape shape, double d, double d2) {
        if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
            return new RoundRectangle2D.Double(roundRectangle2D.getX() + d, roundRectangle2D.getY() + d2, roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            return new Rectangle2D.Double(rectangle2D.getX() + d, rectangle2D.getY() + d2, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            return new Ellipse2D.Double(ellipse2D.getX() + d, ellipse2D.getY() + d2, ellipse2D.getWidth(), ellipse2D.getHeight());
        }
        if (shape instanceof ExpandableShape) {
            ExpandableShape expandableShape = (ExpandableShape)((Object)shape);
            return expandableShape.createTranslatedShape(d, d2);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        return affineTransform.createTransformedShape(shape);
    }

    public static interface ExpandableShape {
        @NotNull
        public Shape createExpandedShape(float var1);

        @NotNull
        public Shape createTranslatedShape(double var1, double var3);
    }

    private static class ExpandableShapeOutline
    extends ExpandableOutline {
        @NotNull
        private final ExpandableShape s;

        public ExpandableShapeOutline(@NotNull ExpandableShape expandableShape) {
            this.s = expandableShape;
        }

        @Override
        @NotNull
        public Shape getShape(float f) {
            return this.s.createExpandedShape(f);
        }
    }

    private static class GenericOutline
    extends ExpandableOutline {
        @NotNull
        private final Shape s;

        public GenericOutline(@NotNull Shape shape) {
            this.s = shape;
        }

        @Override
        @NotNull
        public Shape getShape(float f) {
            Rectangle2D rectangle2D = this.s.getBounds2D();
            double d = rectangle2D.getCenterX();
            double d2 = rectangle2D.getCenterY();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
            double d3 = (rectangle2D.getWidth() + (double)(2.0f * f)) / rectangle2D.getWidth();
            double d4 = (rectangle2D.getHeight() + (double)(2.0f * f)) / rectangle2D.getHeight();
            affineTransform.scale(d3, d4);
            affineTransform.translate(-d, -d2);
            return affineTransform.createTransformedShape(this.s);
        }
    }
}

